/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import twitter4j.Dispatcher;
import twitter4j.conf.Configuration;

final class DispatcherImpl
implements Dispatcher {
    private final ExecutorService executorService;

    public DispatcherImpl(final Configuration conf) {
        this.executorService = Executors.newFixedThreadPool(conf.getAsyncNumThreads(), new ThreadFactory(){
            int count = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(String.format("Twitter4J Async Dispatcher[%d]", this.count++));
                thread.setDaemon(conf.isDaemonEnabled());
                return thread;
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DispatcherImpl.this.executorService.shutdown();
            }
        });
    }

    @Override
    public synchronized void invokeLater(Runnable task) {
        this.executorService.execute(task);
    }

    @Override
    public synchronized void shutdown() {
        this.executorService.shutdown();
    }
}

