/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.DirectPosition2D;
import org.opengis.geometry.DirectPosition;

class Polygon
implements Cloneable {
    private DirectPosition[] vertices;

    Polygon(DirectPosition ... coordinates) {
        this.vertices = coordinates;
    }

    public void setCoordinates(DirectPosition ... coordinates) {
        this.vertices = coordinates;
    }

    public DirectPosition[] getPoints() {
        return this.vertices;
    }

    public String toString() {
        String wkt = "";
        for (int i = 0; i < this.vertices.length; ++i) {
            wkt = wkt + this.vertices[i].getCoordinate()[0] + " " + this.vertices[i].getCoordinate()[1];
            if (i == this.vertices.length - 1) continue;
            wkt = wkt + ", ";
        }
        return "LINESTRING (" + wkt + ")";
    }

    protected GeneralPath generateGeneralPath(DirectPosition ... points) {
        GeneralPath ring = new GeneralPath();
        ring.moveTo((float)points[0].getCoordinate()[0], (float)points[0].getCoordinate()[1]);
        for (int i = 1; i < points.length; ++i) {
            ring.lineTo((float)points[i].getCoordinate()[0], (float)points[i].getCoordinate()[1]);
        }
        return ring;
    }

    protected boolean containsOrIsVertex(DirectPosition dp) {
        return this.generateGeneralPath(this.vertices).contains((Point2D)dp) || this.hasVertex(dp);
    }

    public boolean hasVertex(DirectPosition p) {
        for (DirectPosition vertex : this.vertices) {
            if (p != vertex) continue;
            return true;
        }
        return false;
    }

    protected void enlarge(double scale) {
        double sumX = 0.0;
        double sumY = 0.0;
        for (DirectPosition directPosition : this.vertices) {
            sumX += directPosition.getCoordinate()[0];
            sumY += directPosition.getCoordinate()[1];
        }
        sumX /= (double)this.vertices.length;
        sumY /= (double)this.vertices.length;
        for (DirectPosition vertex : this.vertices) {
            vertex.getCoordinate()[0] = scale * (vertex.getCoordinate()[0] - sumX) + sumX;
            vertex.getCoordinate()[1] = scale * (vertex.getCoordinate()[1] - sumY) + sumY;
        }
    }

    protected List<DirectPosition> reduce() {
        ArrayList<DirectPosition> redCoords = new ArrayList<DirectPosition>();
        for (DirectPosition vertex : this.vertices) {
            redCoords.add(new DirectPosition2D(vertex.getCoordinateReferenceSystem(), vertex.getCoordinate()[0] - this.vertices[0].getCoordinate()[0], vertex.getCoordinate()[1] - this.vertices[0].getCoordinate()[1]));
        }
        return redCoords;
    }

    protected boolean containsAll(List<DirectPosition> coordinate) {
        for (DirectPosition directPosition : coordinate) {
            if (this.containsOrIsVertex(directPosition)) continue;
            return false;
        }
        return true;
    }

    public Polygon clone() {
        return new Polygon(this.vertices);
    }
}

