/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.S3ObjectTag;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.StaxUnmarshallerContext;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class S3ObjectTagStaxUnmarshaller
implements Unmarshaller<S3ObjectTag, StaxUnmarshallerContext> {
    private static S3ObjectTagStaxUnmarshaller instance;

    @Override
    public S3ObjectTag unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3ObjectTag s3ObjectTag = new S3ObjectTag();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3ObjectTag;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Key", targetDepth)) {
                    s3ObjectTag.setKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Value", targetDepth)) continue;
                s3ObjectTag.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3ObjectTag;
    }

    public static S3ObjectTagStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ObjectTagStaxUnmarshaller();
        }
        return instance;
    }
}

