/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.vector.validate;

import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.MetadataVersion;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.ArrowType;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.Field;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.Schema;
import java.io.IOException;
import java.util.Iterator;

public final class MetadataV4UnionChecker {
    static boolean isUnion(Field field) {
        return field.getType().getTypeID() == ArrowType.ArrowTypeID.Union;
    }

    static Field check(Field field) {
        if (MetadataV4UnionChecker.isUnion(field)) {
            return field;
        }
        for (Field child : field.getChildren()) {
            Field result = MetadataV4UnionChecker.check(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static void checkForUnion(Iterator<Field> fields, MetadataVersion metadataVersion) {
        if (metadataVersion.toFlatbufID() >= MetadataVersion.V5.toFlatbufID()) {
            return;
        }
        while (fields.hasNext()) {
            Field union = MetadataV4UnionChecker.check(fields.next());
            if (union == null) continue;
            throw new IllegalArgumentException("Cannot write union with V4 metadata version, use V5 instead. Found field: " + union);
        }
    }

    public static void checkRead(Schema schema, MetadataVersion metadataVersion) throws IOException {
        if (metadataVersion.toFlatbufID() >= MetadataVersion.V5.toFlatbufID()) {
            return;
        }
        for (Field field : schema.getFields()) {
            Field union = MetadataV4UnionChecker.check(field);
            if (union == null) continue;
            throw new IOException("Cannot read union with V4 metadata version. Found field: " + union);
        }
    }
}

