/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.core;

import com.databricks.client.hivecommon.AbstractServerVersionUtils;
import com.databricks.client.hivecommon.AuthMech;
import com.databricks.client.hivecommon.HiveJDBCCasePreservingAlias;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.IServerVersion;
import com.databricks.client.hivecommon.TransportMode;
import com.databricks.client.hivecommon.core.CoreUtils;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc.common.OAuthFlow;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TProtocolVersion;
import com.databricks.client.spark.core.SparkJDBCServerVersion;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.Arrays;

public class SparkJDBCServerVersionUtils
extends AbstractServerVersionUtils {
    @Override
    public boolean isServerVersionSet(IServerVersion iServerVersion) {
        switch ((SparkJDBCServerVersion)iServerVersion) {
            case AUTO: {
                return false;
            }
        }
        return true;
    }

    @Override
    public OAuthFlow getDefaultOAuthFlow() {
        return OAuthFlow.TOKEN_PASSTHROUGH;
    }

    @Override
    public TProtocolVersion getHighestClientProtocol() {
        return TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V8;
    }

    @Override
    public IServerVersion getHighestServerVersion() {
        SparkJDBCServerVersion[] sparkJDBCServerVersionArray = SparkJDBCServerVersion.values();
        return sparkJDBCServerVersionArray[sparkJDBCServerVersionArray.length - 1];
    }

    @Override
    public int getIsTemporaryColIndex(IServerVersion iServerVersion) {
        if (this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_2_1)) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getTableNameColIndex(IServerVersion iServerVersion) {
        if (this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_2_1)) {
            return 1;
        }
        return 0;
    }

    public boolean isDatabricksServer(HiveJDBCSettings hiveJDBCSettings) {
        return hiveJDBCSettings.m_protocolVersion != null && hiveJDBCSettings.m_protocolVersion.getValue() >= TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V1.getValue();
    }

    @Override
    public boolean isSupportedProtocol(TProtocolVersion tProtocolVersion) {
        return tProtocolVersion.compareTo(TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V1) >= 0 || super.isSupportedProtocol(tProtocolVersion);
    }

    @Override
    public IServerVersion parseServerVersion(String string, ILogger iLogger) {
        try {
            if (string == "AUTO") {
                return SparkJDBCServerVersion.AUTO;
            }
            String[] stringArray = string.split("\\.");
            if (stringArray.length >= 1) {
                int n = new Integer(stringArray[0]);
                int n2 = 0;
                int n3 = 0;
                if (stringArray.length >= 2) {
                    n2 = new Integer(stringArray[1]);
                }
                if (stringArray.length >= 3) {
                    n3 = CoreUtils.extractPatchNumber(stringArray[2]);
                }
                if (0 == n) {
                    return SparkJDBCServerVersion.S_0_9;
                }
                if (1 == n) {
                    if (1 > n2) {
                        return SparkJDBCServerVersion.S_1_0;
                    }
                    if (2 > n2) {
                        if (n3 == 0) {
                            return SparkJDBCServerVersion.S_1_1_0;
                        }
                        return SparkJDBCServerVersion.S_1_1;
                    }
                    if (3 > n2) {
                        return SparkJDBCServerVersion.S_1_2;
                    }
                    if (4 > n2) {
                        return SparkJDBCServerVersion.S_1_3;
                    }
                    if (5 > n2) {
                        return SparkJDBCServerVersion.S_1_4;
                    }
                    if (6 > n2) {
                        if (n3 == 2) {
                            return SparkJDBCServerVersion.S_1_5_2;
                        }
                        return SparkJDBCServerVersion.S_1_5;
                    }
                    return SparkJDBCServerVersion.S_1_6;
                }
                if (2 == n) {
                    if (1 > n2) {
                        return SparkJDBCServerVersion.S_2_0;
                    }
                    if (2 > n2) {
                        return SparkJDBCServerVersion.S_2_1;
                    }
                    return SparkJDBCServerVersion.S_2_2;
                }
                if (3 == n) {
                    if (n2 < 6) {
                        int n4 = Arrays.asList(SparkJDBCServerVersion.values()).indexOf(SparkJDBCServerVersion.S_3_0);
                        return SparkJDBCServerVersion.values()[n4 + n2];
                    }
                    return this.getHighestServerVersion();
                }
                if (3 < n) {
                    return this.getHighestServerVersion();
                }
            }
        }
        catch (Exception exception) {
            SparkJDBCServerVersion sparkJDBCServerVersion = (SparkJDBCServerVersion)this.getHighestServerVersion();
            if (null != iLogger) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SERVER_VERSION_SET_HIGHEST_ERR.name(), new String[]{sparkJDBCServerVersion.name(), exception.getMessage()});
                LogUtilities.logWarning(errorException, iLogger);
            }
            return sparkJDBCServerVersion;
        }
        return SparkJDBCServerVersion.S_0_9;
    }

    @Override
    public boolean reportsTypeChar(HiveJDBCSettings hiveJDBCSettings) {
        if (null != hiveJDBCSettings.m_reportCharAndVarcharSupportForSpark) {
            return hiveJDBCSettings.m_reportCharAndVarcharSupportForSpark;
        }
        return this.greaterThanOrEqualTo(hiveJDBCSettings.m_serverVersion, SparkJDBCServerVersion.S_3_1);
    }

    @Override
    public boolean reportsTypeVarchar(HiveJDBCSettings hiveJDBCSettings) {
        if (null != hiveJDBCSettings.m_reportCharAndVarcharSupportForSpark) {
            return hiveJDBCSettings.m_reportCharAndVarcharSupportForSpark;
        }
        return this.greaterThanOrEqualTo(hiveJDBCSettings.m_serverVersion, SparkJDBCServerVersion.S_3_1);
    }

    @Override
    public AuthMech resolveDefaultAuthMech(HiveJDBCSettings hiveJDBCSettings) {
        if (TransportMode.BINARY == hiveJDBCSettings.m_transportMode) {
            return AuthMech.NOAUTH;
        }
        if (TransportMode.HTTP == hiveJDBCSettings.m_transportMode) {
            return AuthMech.UIDPWD;
        }
        return AuthMech.SASL_PLAIN_UID;
    }

    @Override
    public boolean shouldMapUnknownTypeToVarchar(HiveJDBCSettings hiveJDBCSettings) {
        return this.isDatabricksServer(hiveJDBCSettings);
    }

    @Override
    public boolean supportsComplexTypesInResults() {
        return true;
    }

    @Override
    public boolean supportsDescribeTable(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsV3Protocol(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_1_0);
    }

    @Override
    public boolean supportsV6Protocol(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_1_2);
    }

    @Override
    public boolean supportsV8Protocol(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_1_6);
    }

    @Override
    public boolean supportsAsynchronousOperations(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_1_2);
    }

    @Override
    public boolean supportsCharLength(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_1_6);
    }

    @Override
    public boolean supportsGetColumnsAPINullability(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_3_0);
    }

    @Override
    public boolean supportsVarcharLength(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsDecimalPrecisionAndScale(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_1_2);
    }

    @Override
    public boolean supportsTypeBinary(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsTypeChar(HiveJDBCSettings hiveJDBCSettings) {
        return true;
    }

    @Override
    public boolean supportsTypeDate(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_1_2);
    }

    @Override
    public boolean supportsTypeDecimal(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportSTypeReal(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsTypeTimestamp(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsTypeVarchar(HiveJDBCSettings hiveJDBCSettings) {
        return true;
    }

    @Override
    public boolean supportsNestedDataTypes(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsUnionDataTypes(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsDMLstatement(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_2_0);
    }

    @Override
    public boolean hqlSupportsDefaultOrderBy(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean hqlSupportsDefaultOuterJoin(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_1_1);
    }

    @Override
    public String supportsBackTickedAliases(IServerVersion iServerVersion, String string) {
        switch ((SparkJDBCServerVersion)iServerVersion) {
            case S_1_1_0: {
                return string;
            }
        }
        return "`" + string + "`";
    }

    @Override
    public boolean supportI16BufferForSmallInt(IServerVersion iServerVersion) {
        switch ((SparkJDBCServerVersion)iServerVersion) {
            case S_1_1_0: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportPushdownCatalogFilter(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsAliasingInScalarFun(IServerVersion iServerVersion) {
        switch ((SparkJDBCServerVersion)iServerVersion) {
            case S_1_2: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsGetColumnsAPI(IServerVersion iServerVersion) {
        return !this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_1_5) || this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_3_0);
    }

    @Override
    public boolean supportsQueryCommentHints(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean isDisableLimitZeroForSimpleQuery() {
        return false;
    }

    @Override
    public boolean hasIssueWithNullTypeMetadata(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean hasIssueWithNullTypeData(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsGetSchemasAPI(IServerVersion iServerVersion) {
        return !this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_1_5_2) || this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_3_0);
    }

    @Override
    public boolean supportsGetTablesAPI(IServerVersion iServerVersion) {
        return !this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_1_5_2) || this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_3_0);
    }

    @Override
    public boolean supportsGetTablesAPIComments(IServerVersion iServerVersion) {
        return !this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_1_5_2) || this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_3_0);
    }

    @Override
    public boolean needsColumnTypeCastForInsert(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean needsInsertOptimization(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean preservesAliasCase(HiveJDBCSettings hiveJDBCSettings) {
        if (HiveJDBCCasePreservingAlias.LOWERCASE == hiveJDBCSettings.m_columnNameAliaseCase) {
            return false;
        }
        if (HiveJDBCCasePreservingAlias.PRESERVE_CASE == hiveJDBCSettings.m_columnNameAliaseCase) {
            return true;
        }
        switch ((SparkJDBCServerVersion)hiveJDBCSettings.m_serverVersion) {
            case S_1_1_0: 
            case S_1_1: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsTimeOnlyTimestamp(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsDateOnlyTimestamp(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsNewLineCharacter(IServerVersion iServerVersion) {
        switch ((SparkJDBCServerVersion)iServerVersion) {
            case S_1_1_0: 
            case S_1_2: 
            case S_1_1: 
            case S_1_6: 
            case S_1_5: 
            case S_1_5_2: 
            case S_1_4: 
            case S_1_3: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsAuthMech(AuthMech authMech) {
        switch (authMech) {
            default: 
        }
        return true;
    }

    @Override
    public boolean sendUidViaOpenSessionReq(AuthMech authMech) {
        return false;
    }

    @Override
    public boolean supportsHttp(AuthMech authMech) {
        switch (authMech) {
            case UIDPWD: 
            case SASL_KERBEROS: 
            case OAUTH_2: 
            case SAML_2_0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsUnsetClientProtocol() {
        return true;
    }

    @Override
    public boolean supportsQualifiedTypeNames(IServerVersion iServerVersion) {
        return this.greaterThanOrEqualTo(iServerVersion, SparkJDBCServerVersion.S_3_0);
    }

    @Override
    public boolean supportsGetPrimaryForeignKeyAPI(HiveJDBCSettings hiveJDBCSettings) {
        return TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V4.getValue() <= hiveJDBCSettings.m_protocolVersion.getValue();
    }

    @Override
    public String getDriverNamePrefix() {
        return "SparkJDBCDriver";
    }

    @Override
    public boolean supportsAsyncModeForMetadataOperation(HiveJDBCSettings hiveJDBCSettings) {
        return TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V9.getValue() <= hiveJDBCSettings.m_protocolVersion.getValue();
    }

    @Override
    public boolean supportsNativeModeParameterizedQuery(HiveJDBCSettings hiveJDBCSettings) {
        return TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V8.getValue() <= hiveJDBCSettings.m_protocolVersion.getValue();
    }

    @Override
    public boolean supportsTypeVariant(HiveJDBCSettings hiveJDBCSettings) {
        return hiveJDBCSettings.m_protocolVersion.getValue() >= TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V8.getValue();
    }

    @Override
    public boolean supportsTypeVoid(HiveJDBCSettings hiveJDBCSettings) {
        return this.isDatabricksServer(hiveJDBCSettings);
    }

    @Override
    public boolean supportsTypeTimeStamp_NTZ(HiveJDBCSettings hiveJDBCSettings) {
        return hiveJDBCSettings.m_protocolVersion.getValue() >= TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V8.getValue();
    }
}

