/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.Serializable;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.spark.snowflake.ConnectionCacheKey;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.Parameters$;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.TelemetryClientInfoFields$;
import net.snowflake.spark.snowflake.Utils$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ServerConnection$ {
    public static ServerConnection$ MODULE$;
    private final Logger log;
    private final AtomicLong serverConnectionCount;
    private final AtomicLong jdbcConnectionCount;
    private boolean supportSharingJDBCConnection;
    private final Map<ConnectionCacheKey, Connection> cachedJdbcConnections;

    static {
        new ServerConnection$();
    }

    private Logger log() {
        return this.log;
    }

    public AtomicLong serverConnectionCount() {
        return this.serverConnectionCount;
    }

    public AtomicLong jdbcConnectionCount() {
        return this.jdbcConnectionCount;
    }

    public boolean supportSharingJDBCConnection() {
        return this.supportSharingJDBCConnection;
    }

    public void supportSharingJDBCConnection_$eq(boolean x$1) {
        this.supportSharingJDBCConnection = x$1;
    }

    public void setSupportSharingJDBCConnection(boolean enabled) {
        this.supportSharingJDBCConnection_$eq(enabled);
    }

    public ServerConnection apply(Connection jdbcConnection, boolean enableCache) {
        return new ServerConnection(jdbcConnection, enableCache);
    }

    public ServerConnection apply(Connection jdbcConnection) {
        return new ServerConnection(jdbcConnection, true);
    }

    private Map<ConnectionCacheKey, Connection> cachedJdbcConnections() {
        return this.cachedJdbcConnections;
    }

    public synchronized void closeAllCachedConnections() {
        this.log().info(new StringBuilder(29).append("Close all ").append(this.cachedJdbcConnections().size()).append(" cached connection.").toString());
        this.cachedJdbcConnections().values().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        this.cachedJdbcConnections().clear();
    }

    public synchronized ServerConnection getServerConnection(Parameters.MergedParameters parameters, boolean useCache) {
        ServerConnection serverConnection;
        block5: {
            Tuple2 tuple2;
            Tuple2 tuple22;
            boolean enableCache;
            ConnectionCacheKey connectionCacheKey = new ConnectionCacheKey(parameters);
            boolean bl = enableCache = useCache && connectionCacheKey.isConnectionCacheSupported();
            if (enableCache && this.cachedJdbcConnections().keySet().contains((Object)connectionCacheKey)) {
                tuple22 = new Tuple2(this.cachedJdbcConnections().apply((Object)connectionCacheKey), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            } else {
                BoxedUnit boxedUnit;
                Connection createdJdbcConnection = this.createJDBCConnection(parameters);
                if (enableCache) {
                    this.log().debug("Cache the new created JDBCConnection");
                    boxedUnit = this.cachedJdbcConnections().put((Object)connectionCacheKey, (Object)createdJdbcConnection);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                tuple22 = tuple2 = new Tuple2((Object)createdJdbcConnection, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Connection jdbcConnection = (Connection)tuple2._1();
            boolean newConnection = tuple2._2$mcZ$sp();
            Tuple2 tuple23 = new Tuple2((Object)jdbcConnection, (Object)BoxesRunTime.boxToBoolean((boolean)newConnection));
            Tuple2 tuple24 = tuple23;
            Connection jdbcConnection2 = (Connection)tuple24._1();
            boolean newConnection2 = tuple24._2$mcZ$sp();
            serverConnection = this.apply(jdbcConnection2, enableCache);
            this.log().info(new StringBuilder(47).append("Create ServerConnection with ").append((Object)(newConnection2 ? "new" : "cached")).append(" JDBC connection: ").append(serverConnection.getSessionID()).toString());
            if (!newConnection2) break block5;
            scala.collection.immutable.Map extraValues = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TelemetryClientInfoFields$.MODULE$.SFURL()), (Object)parameters.sfURL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TelemetryClientInfoFields$.MODULE$.SHARED()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)enableCache)).toString())}));
            SnowflakeTelemetry$.MODULE$.sendClientInfoTelemetry((scala.collection.immutable.Map<String, String>)extraValues, serverConnection);
        }
        return serverConnection;
    }

    public boolean getServerConnection$default$2() {
        return true;
    }

    private Connection createJDBCConnection(Parameters.MergedParameters params) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String driverClassName = Utils$.MODULE$.JDBC_DRIVER();
        try {
            Class<?> driverClass = Utils$.MODULE$.classForName(driverClassName);
            DriverRegistry$.MODULE$.register(driverClass.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException(new StringBuilder(50).append("Could not load a Snowflake JDBC driver class < ").append(driverClassName).append(" > ").toString(), e);
        }
        String sfURL = params.sfURL();
        String jdbcURL = new StringBuilder(17).append("jdbc:snowflake://").append(sfURL).toString();
        Properties jdbcProperties = new Properties();
        jdbcProperties.put("db", params.sfDatabase());
        jdbcProperties.put("schema", params.sfSchema());
        Object object6 = params.sfUser() != null ? jdbcProperties.put("user", params.sfUser()) : BoxedUnit.UNIT;
        Option<PrivateKey> option = params.privateKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            PrivateKey privateKey = (PrivateKey)some.value();
            object5 = jdbcProperties.put("privateKey", privateKey);
        } else if (None$.MODULE$.equals(option)) {
            Object object7;
            Option<String> option2 = params.sfToken();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String value = (String)some.value();
                object7 = jdbcProperties.put("token", value);
            } else if (None$.MODULE$.equals(option2)) {
                object7 = jdbcProperties.put("password", params.sfPassword());
            } else {
                throw new MatchError(option2);
            }
            object5 = object7;
        } else {
            throw new MatchError(option);
        }
        jdbcProperties.put("ssl", params.sfSSL());
        Object object8 = params.sfAccount().isDefined() ? jdbcProperties.put("account", params.sfAccount().get()) : BoxedUnit.UNIT;
        Object object9 = params.sfWarehouse().isDefined() ? jdbcProperties.put("warehouse", params.sfWarehouse().get()) : BoxedUnit.UNIT;
        Object object10 = params.sfRole().isDefined() ? jdbcProperties.put("role", params.sfRole().get()) : BoxedUnit.UNIT;
        Option<String> option3 = params.getTimeOutputFormat();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String value = (String)some.value();
            object4 = jdbcProperties.put(Parameters$.MODULE$.PARAM_TIME_OUTPUT_FORMAT(), value);
        } else {
            object4 = BoxedUnit.UNIT;
        }
        Option<String> option4 = params.getQueryResultFormat();
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            String value = (String)some.value();
            object3 = jdbcProperties.put(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT(), value);
        } else {
            object3 = BoxedUnit.UNIT;
        }
        params.setJDBCProxyIfNecessary(jdbcProperties);
        Option<String> option5 = params.sfAuthenticator();
        if (option5 instanceof Some) {
            Some some = (Some)option5;
            String value = (String)some.value();
            object2 = jdbcProperties.put("authenticator", value);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        jdbcProperties.put("client_session_keep_alive", "true");
        Object object11 = params.treatDecimalAsLong() ? jdbcProperties.put("JDBC_TREAT_DECIMAL_AS_INT", "true") : jdbcProperties.put("JDBC_TREAT_DECIMAL_AS_INT", "false");
        scala.collection.immutable.Map<String, Object> extraOptions = params.sfExtraOptions();
        extraOptions.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ServerConnection$.$anonfun$createJDBCConnection$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            String string;
            Object v;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$3;
                    if (tuple2 == null) break block2;
                    String k = (String)tuple2._1();
                    v = tuple2._2();
                    if (k == null) break block2;
                    string = k;
                    if (v != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Object object = v;
            Object object2 = jdbcProperties.put(string.toLowerCase(), object.toString());
            return object2;
        });
        if (!Utils$.MODULE$.CERTIFIED_JDBC_VERSION().equals(Utils$.MODULE$.jdbcVersion())) {
            this.log().warn((String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(107).append("JDBC ").append(Utils$.MODULE$.jdbcVersion()).append(" is being used.\n           | But the certified JDBC version\n           | ").append(Utils$.MODULE$.CERTIFIED_JDBC_VERSION()).append(" is recommended.\n           |").toString())).stripMargin())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ServerConnection$.$anonfun$createJDBCConnection$3(BoxesRunTime.unboxToChar((Object)x$4)))));
        }
        jdbcProperties.put(SFSessionProperty.CLIENT_INFO.getPropertyKey(), Utils$.MODULE$.getClientInfoString());
        Connection conn = DriverManager.getConnection(jdbcURL, jdbcProperties);
        if (jdbcProperties.getProperty(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT()) != null) {
            try {
                String resultFormat = jdbcProperties.getProperty(Parameters$.MODULE$.PARAM_JDBC_QUERY_RESULT_FORMAT());
                object = BoxesRunTime.boxToBoolean((boolean)conn.createStatement().execute(new StringBuilder(47).append("alter session set JDBC_QUERY_RESULT_FORMAT = '").append(resultFormat).append("'").toString()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof SQLException)) {
                    if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        throw throwable3;
                    }
                    throw throwable;
                }
                SQLException sQLException = (SQLException)throwable2;
                this.log().info(sQLException.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                object = boxedUnit;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        conn.createStatement().execute(new StringBuilder(41).append("alter session set ABORT_DETACHED_QUERY = ").append(params.abortDetachedQuery()).toString());
        Object object12 = params.supportAWSStageEndPoint() ? params.getS3StageVpceDnsName().map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ServerConnection$.$anonfun$createJDBCConnection$4(conn, x))) : BoxedUnit.UNIT;
        this.jdbcConnectionCount().incrementAndGet();
        return conn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$createJDBCConnection$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String k = (String)tuple2._1();
        Object v = tuple2._2();
        if (k == null) return false;
        if (v == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$createJDBCConnection$3(char x$4) {
        return x$4 >= ' ';
    }

    public static final /* synthetic */ boolean $anonfun$createJDBCConnection$4(Connection conn$1, String x) {
        return conn$1.createStatement().execute(new StringBuilder(45).append("alter session set S3_STAGE_VPCE_DNS_NAME = '").append(x).append("'").toString());
    }

    private ServerConnection$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.serverConnectionCount = new AtomicLong();
        this.jdbcConnectionCount = new AtomicLong();
        this.supportSharingJDBCConnection = true;
        this.cachedJdbcConnections = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

