/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.types;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.CollationIdentifier;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.FieldMetadata;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Evolving
public class StructField {
    private static String IS_METADATA_COLUMN_KEY = "isMetadataColumn";
    public static String METADATA_ROW_INDEX_COLUMN_NAME = "_metadata.row_index";
    public static StructField METADATA_ROW_INDEX_COLUMN = new StructField(METADATA_ROW_INDEX_COLUMN_NAME, LongType.LONG, false, FieldMetadata.builder().putBoolean(IS_METADATA_COLUMN_KEY, true).build());
    public static final String COLLATIONS_METADATA_KEY = "__COLLATIONS";
    private final String name;
    private final DataType dataType;
    private final boolean nullable;
    private final FieldMetadata metadata;

    public StructField(String string, DataType dataType, boolean bl) {
        this(string, dataType, bl, FieldMetadata.empty());
    }

    public StructField(String string, DataType dataType, boolean bl, FieldMetadata fieldMetadata) {
        this.name = string;
        this.dataType = dataType;
        this.nullable = bl;
        FieldMetadata fieldMetadata2 = this.fetchCollationMetadata();
        this.metadata = new FieldMetadata.Builder().fromMetadata(fieldMetadata).fromMetadata(fieldMetadata2).build();
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public FieldMetadata getMetadata() {
        return this.metadata;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isMetadataColumn() {
        return this.metadata.contains(IS_METADATA_COLUMN_KEY) && (Boolean)this.metadata.get(IS_METADATA_COLUMN_KEY) != false;
    }

    public boolean isDataColumn() {
        return !this.isMetadataColumn();
    }

    public String toString() {
        return String.format("StructField(name=%s,type=%s,nullable=%s,metadata=%s)", this.name, this.dataType, this.nullable, this.metadata);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StructField structField = (StructField)object;
        return this.nullable == structField.nullable && this.name.equals(structField.name) && this.dataType.equals(structField.dataType) && this.metadata.equals(structField.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataType, this.nullable, this.metadata);
    }

    public StructField withNewMetadata(FieldMetadata fieldMetadata) {
        return new StructField(this.name, this.dataType, this.nullable, fieldMetadata);
    }

    private List<Tuple2<String, String>> getNestedCollatedFields(DataType dataType, String string) {
        ArrayList<Tuple2<String, String>> arrayList = new ArrayList<Tuple2<String, String>>();
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            if (!stringType.getCollationIdentifier().equals(CollationIdentifier.fromString("SPARK.UTF8_BINARY"))) {
                arrayList.add(new Tuple2<String, String>(string, ((StringType)dataType).getCollationIdentifier().toStringWithoutVersion()));
            }
        } else if (dataType instanceof MapType) {
            arrayList.addAll(this.getNestedCollatedFields(((MapType)dataType).getKeyType(), string + ".key"));
            arrayList.addAll(this.getNestedCollatedFields(((MapType)dataType).getValueType(), string + ".value"));
        } else if (dataType instanceof ArrayType) {
            arrayList.addAll(this.getNestedCollatedFields(((ArrayType)dataType).getElementType(), string + ".element"));
        }
        return arrayList;
    }

    private FieldMetadata fetchCollationMetadata() {
        List<Tuple2<String, String>> list = this.getNestedCollatedFields(this.dataType, this.name);
        if (list.isEmpty()) {
            return FieldMetadata.empty();
        }
        FieldMetadata.Builder builder = new FieldMetadata.Builder();
        for (Tuple2<String, String> tuple2 : list) {
            builder.putString((String)tuple2._1, (String)tuple2._2);
        }
        return new FieldMetadata.Builder().putFieldMetadata(COLLATIONS_METADATA_KEY, builder.build()).build();
    }
}

