/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.plugins.builtinmacros;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.plugin.BackendClient;
import com.dataiku.dip.plugin.CustomRunnable;
import com.dataiku.dip.plugin.ProgressTracker;
import com.dataiku.dip.plugin.ResultTableDTO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class DropPipelineViews
implements CustomRunnable {
    private AuthCtx authCtx;
    private String projectKey;
    private String connectionName;
    private String schema;
    private boolean performDeletion;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.macro.clearpipelineviews");

    public void init(String projectKey, JsonObject config, JsonObject pluginConfig, ProgressTracker progressTracker, BackendClient backendClient) {
        this.authCtx = (AuthCtx)backendClient.getAuthCtx();
        this.projectKey = projectKey;
        this.connectionName = config.get("connection").getAsString();
        if (config.has("schema")) {
            this.schema = config.get("schema").getAsString();
        }
        this.performDeletion = config.get("performDeletion").getAsBoolean();
        SpringUtils.getInstance().autowire((Object)this);
    }

    public byte[] run() throws Exception {
        ArrayList<List<String>> resultTableDTOData;
        List<ResultTableDTO.ResultTableColumnDTO> resultTableDTOColumns;
        block31: {
            DSSConnection connection = this.connectionsDAO.getConnection(this.authCtx, this.connectionName);
            if (connection == null) {
                throw new IllegalArgumentException("Unable to find connection named '" + this.connectionName + "'");
            }
            if (!connection.isProperSQL()) {
                throw new IllegalArgumentException("Connection '" + this.connectionName + "' is not a SQL connection");
            }
            SQLDialect dialect = ((AbstractSQLConnection)connection).getDialect();
            resultTableDTOColumns = Arrays.asList(new ResultTableDTO.ResultTableColumnDTO("Schema", "STRING"), new ResultTableDTO.ResultTableColumnDTO("View name", "STRING"), new ResultTableDTO.ResultTableColumnDTO("Deleted", "STRING"));
            resultTableDTOData = new ArrayList<List<String>>();
            try (SQLConnectionProvider.SQLConnectionWrapper connectionWrapper = SQLConnectionProvider.newConnection((String)this.connectionName, (AuthCtx)this.authCtx, (String)this.projectKey);){
                ArrayList<View> views = new ArrayList<View>();
                String leftoverPipelineQuery = dialect.getLeftoverPipelineViewsQuery(this.schema);
                logger.infoV("Executing statement to get views: %s", new Object[]{leftoverPipelineQuery});
                try (Statement statement = connectionWrapper.createStatement();){
                    ResultSet resultSet = statement.executeQuery(leftoverPipelineQuery);
                    while (resultSet.next()) {
                        String schemaName = resultSet.getString(1);
                        String viewName = resultSet.getString(2);
                        String catalogName = null;
                        if (resultSet.getMetaData().getColumnCount() > 2) {
                            catalogName = resultSet.getString(3);
                        }
                        views.add(new View(catalogName, schemaName, viewName));
                    }
                }
                if (dialect.supportsCommitAndRollback()) {
                    connectionWrapper.commit();
                }
                if (this.performDeletion) {
                    ArrayList viewsToDelete = new ArrayList(views);
                    while (viewsToDelete.size() > 0) {
                        ArrayList<View> viewsToRetry = new ArrayList<View>();
                        SQLException lastException = null;
                        for (View view : viewsToDelete) {
                            String dropViewSql = dialect.getDropViewInstruction(view.catalog, view.schema, view.name);
                            logger.infoV("Executing statement to drop a view: %s", new Object[]{dropViewSql});
                            try {
                                Statement statement = connectionWrapper.createStatement();
                                try {
                                    statement.execute(dropViewSql);
                                    if (dialect.supportsCommitAndRollback()) {
                                        connectionWrapper.commit();
                                    }
                                    resultTableDTOData.add(Arrays.asList(view.schema, view.name, "Yes"));
                                }
                                finally {
                                    if (statement == null) continue;
                                    statement.close();
                                }
                            }
                            catch (SQLException e) {
                                lastException = e;
                                logger.warnV((Throwable)e, "Failed to drop view %s.%s", new Object[]{view.schema, view.name});
                                viewsToRetry.add(view);
                                if (!dialect.supportsCommitAndRollback()) continue;
                                connectionWrapper.rollback();
                            }
                        }
                        if (viewsToDelete.size() == viewsToRetry.size()) {
                            throw new CodedSQLException((InfoMessage.MessageCode)InfoMessage.GenericCodes.ERR_UNKNOWN, "Unable to drop all views", lastException);
                        }
                        viewsToDelete = viewsToRetry;
                    }
                    break block31;
                }
                for (View view : views) {
                    resultTableDTOData.add(Arrays.asList(view.schema, view.name, "No"));
                }
            }
        }
        return JSON.json((Object)new ResultTableDTO("Leftover Views", resultTableDTOColumns, resultTableDTOData)).getBytes(StandardCharsets.UTF_8);
    }

    public void abort() {
    }

    private static class View {
        final String catalog;
        final String schema;
        final String name;

        View(String catalog, String schema, String name) {
            this.catalog = catalog;
            this.schema = schema;
            this.name = name;
        }
    }
}

