(function(){
    'use strict';

    const requestApp = {
        bindings: {
            request: '<',
            requester: '<',
            requestingUserGroups: '<',
            selectedPermission: '<',
            selectedUserOrGroup: '=',
            appName: '<',
            closer: '<',
            onChange: '&'
        },
        templateUrl: '/static/dataiku/inbox/components/request-center/request/request-app/request-app.component.html',
        controller: function(){
            this.callback = () => {
                const response = { selectedUserOrGroup: this.selectedUserOrGroup, selectedPermission: this.selectedPermission, type: 'ProjectAccessResponse'}; // keep type in sync with backend
                this.onChange({response});
            }
            this.$onInit = () => {
                this.callback(); // initialize the selection
            }
        }
    }

    angular.module('dataiku.inbox')
    .component('requestApp', requestApp);
})();
