(function(){
    'use strict';

    const request = {
        require: {
            requestCenter: '^^requestCenter',
        },
        templateUrl: '/static/dataiku/inbox/components/request-center/request/request.component.html',
        controller: function($scope, $stateParams, DataikuAPI, RequestCenterService, Notification, StateUtils, $window){
            this.request;
            this.requester;
            this.requestResponse = {};
            this.selectedUserOrGroup;
            this.selectedPermission;
            this.closer;
            this.approveButtonLabel = "Approve request";
            this.rejectButtonLabel = "Reject request";
            this.pluginObjectLink;
            this.codeEnvObjectLink;

            const loadComponentData = () => {
                RequestCenterService.loadRequest($stateParams.requestId).then(data => {
                    this.request = data.request;
                    this.selectedPermission = data.selectedPermission;
                    this.requester = data.requester;
                    this.requestingUserGroups = data.requestingUserGroups;
                    this.selectedUserOrGroup = data.selectedUserOrGroup;
                    this.closer = data.closer;
                    if(this.request && this.request.objectType === 'CODE_ENV'){
                        this.codeEnvObjectLink = RequestCenterService.getObjectLink("", "CODE_ENV", this.request.requestDetails.targetName || this.request.objectId, data, this.request.requestDetails.envLang);
                    }
                    if (this.request && this.request.objectType === 'PLUGIN') {
                        RequestCenterService.listPlugins().
                        then((data) => {
                            this.pluginObjectLink = RequestCenterService.getObjectLink("", "PLUGIN", this.request.objectId, data);
                        }, setErrorInScope.bind($scope));
                    }
                    this.setButtonsLabels(); 
                }, setErrorInScope.bind($scope));
            }
            loadComponentData();
            
            this.setButtonsLabels = () => {
                if (this.isInstanceAccessRequest()) {
                    this.approveButtonLabel = "Grant access";
                    this.rejectButtonLabel = "Reject access";
                } else if (this.isProfileUpgradeRequest()) {
                    this.approveButtonLabel = "Upgrade profile";
                    this.rejectButtonLabel = "Reject request";
                } else {
                    this.approveButtonLabel = "Approve request";
                    this.rejectButtonLabel = "Reject request";
                }  
            }

            this.updateRequestResponse = (response) => {
                this.requestResponse = response;
            }

            this.approveRequest = function() {
                DataikuAPI.requests.approve($stateParams.requestId, this.requestResponse).success(() => {
                    RequestCenterService.WT1Events.onRequestManaged(this.request, this.requestResponse, 'approved');
                    loadComponentData();
                    this.requestCenter.updateRequest();
                    $scope.fatalAPIError = "";
                }).error(setErrorInScope.bind($scope));
            }

            this.rejectRequest = function() {
                DataikuAPI.requests.reject($stateParams.requestId).success(() => {
                    RequestCenterService.WT1Events.onRequestManaged(this.request, this.requestResponse, 'rejected');
                    loadComponentData();
                    this.requestCenter.updateRequest();
                    $scope.fatalAPIError = "";
                }).error(setErrorInScope.bind($scope));
            }

            this.processCodeEnvRequest = function() {
                DataikuAPI.admin.codeenvs.design.prepareDraftFromRequest($stateParams.requestId).success((data) => {
                    RequestCenterService.WT1Events.onRequestManaged(this.request, this.requestResponse, 'processed');
                    StateUtils.go.codeEnvCreation(data.config.id);
                }).error(setErrorInScope.bind($scope));
            }

            this.markAsCompletedCodeEnvRequest = function(){
                const response = {type: 'CodeEnvResponse', targetName: this.request.requestDetails.targetName}; // keep type in sync with backend
                this.updateRequestResponse(response);
                this.approveRequest();
            }

            this.processPluginRequest = function() {
                RequestCenterService.WT1Events.onRequestManaged(this.request, this.requestResponse, 'processed');
                $window.location.href = this.pluginObjectLink;
            }

            this.canApproveRequest = function(){
                return !(this.isPluginRequest() || this.isCodeEnvRequest());
            }

            this.isInstanceAccessRequest = () => {
                return this.request && this.request.requestType === "INSTANCE_ACCESS";
            }

            this.isProfileUpgradeRequest = () => {
                return this.request && this.request.requestType === "PROFILE_UPGRADE";
            }

            this.isPluginRequest = function(){
                return this.request && this.request.objectType === 'PLUGIN';
            }

            this.isCodeEnvRequest = function(){
                return this.request && this.request.objectType === 'CODE_ENV';
            }

            this.isInternalCodeEnvRequest = function(){
                return this.request && this.request.objectId.startsWith("INTERNAL");
            }

            this.isCodeEnvManualRequest = function(){
                return this.isCodeEnvRequest() && this.request.requestDetails.source === 'MANUAL';
            }

            this.getRequestTypeLabel = function(){
                if (this.isPluginRequest()) {
                    return 'Plugin';
                } else if (this.isCodeEnvRequest()) {
                    return 'Code env';
                } else if (this.isProfileUpgradeRequest()) {
                    return 'Profile upgrade';
                }
                return 'Access';
            }

            this.isValidResponse = () => {
                if (this.request.requestType === 'OBJECT_SHARE') {
                    return this.selectedUserOrGroup !== undefined;
                } else if (this.request.requestType === 'INSTANCE_ACCESS') {
                    return this.requestResponse.selectedUserProfile != undefined && this.requestResponse.selectedProfileType != undefined;
                }
                return true;
            }
        }
    }

    angular.module('dataiku.inbox')
    .component('request', request);
})();
