(function(){
'use strict';

const app = angular.module('dataiku.experimenttracking', []);

// use createOrAppendModelsToExperimentTrackingModalDirective when calling CreateModalFromComponent
app.component("createOrAppendModelsToExperimentTrackingModal", {
    bindings: {
        experiments: '<',
        fmis: '<',
        projectKey: '<',
        trackFrom: '<'
    },
    templateUrl: '/templates/ml/create-or-append-to-et-modal.html',
    controller: function($scope, DataikuAPI, $state, $stateParams, WT1) {
            const $ctrl = this;
            $scope.mode = 'CREATE';
            $scope.newExperiment = {experimentName : "New experiment"};

            $scope.switchToAppendModeIfPossible = function() {
                if($ctrl.experiments.length > 0) {
                    $scope.mode = 'APPEND';
                }
            }

            $scope.canCompare = function() {
                return ($scope.mode == 'APPEND' && $scope.selectedExperiment) || ($scope.mode == 'CREATE' && $scope.newExperiment.experimentName.length > 0);
            }

            $scope.createExperimentTrackingWithLabModels = function() {
                let creationPromise;
                if ($scope.mode === 'CREATE') {
                    creationPromise = DataikuAPI.experimenttracking.createExperimentForAnalysisModels(
                                            $stateParams.projectKey,
                                            $scope.newExperiment.experimentName
                                        ).error(setErrorInScope.bind($scope));
                    WT1.event("analysis-create-experiment-for-lab-models", { from: $ctrl.trackFrom });
                } else {
                    creationPromise = Promise.resolve({data: $scope.selectedExperiment.id});
                }

                creationPromise.then((resp) => {
                    const experimentId = resp.data;
                    DataikuAPI.experimenttracking.compareWithExperimentTracking(
                        $stateParams.projectKey,
                        $ctrl.fmis,
                        experimentId
                    ).error(setErrorInScope.bind($scope))
                    .then(()=> {
                        WT1.event("analysis-import-lab-models-to-experiment", 
                        {
                            from: $ctrl.trackFrom,
                            modelCount : $ctrl.fmis.length
                        });
                        $state.go("projects.project.experiment-tracking.runs-list", {experimentIds: experimentId})
                    });
                });
            }
        }
    });
})();
