(function() {
'use strict';

const app = angular.module('dataiku.featurestore', []);

app.controller("_FeatureGroupRightColumnActions", function($scope, $rootScope, CreateModalFromTemplate) {

    $scope.setAsFeatureGroup = function(dataset) {
        CreateModalFromTemplate("/templates/featurestore/promote-as-feature-group-modal.html", $scope, "PromoteAsFeatureGroupModalController", function(newScope) {
            newScope.init(dataset, $scope.datasetFullInfo.objectAuthorizations);
        });
    };
});

app.controller("PromoteAsFeatureGroupModalController", function($scope, $rootScope, DataikuAPI) {

    function setAsFeatureGroup() {
        DataikuAPI.featureStore.setFeatureGroup($scope.dataset.projectKey, $scope.dataset.smartName, true)
            .success(function() {
                $scope.dataset.featureGroup = true;
                $rootScope.$emit('featureGroupStatusChanged');
                $scope.resolveModal();
            })
            .error(setErrorInScope.bind($scope));
    }

    $scope.init = (dataset, objectAuthorizations) => {
        $scope.missingQuickSharing = $rootScope.appConfig.quickSharingElementsEnabled && !objectAuthorizations.isQuicklyShareable;
        $scope.showEnableQuickSharingOption = $scope.missingQuickSharing && objectAuthorizations.canManageExposedElements;
        $scope.dataset = dataset;
        $scope.options = {enableQuickSharing : $scope.missingQuickSharing && objectAuthorizations.canManageExposedElements};
    }

    $scope.promote = function() {
        if ($scope.options.enableQuickSharing) {
            DataikuAPI.projects.enableQuickSharing($scope.dataset.projectKey, "DATASET", $scope.dataset.smartName)
                .success(setAsFeatureGroup).error(setErrorInScope.bind($scope));
        } else {
            setAsFeatureGroup();
        }
    };
});
})();