(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This directive previously was in static/dataiku/js/simple_report/config_ui.js
    app.directive('extentFormatter', function() {
        return {
            restrict: 'A',
            require: 'ngModel',
            scope: {
                defaultExtentValue: '<'
            },
            link: function($scope, _element, attrs, ngModelController) {
                if ($scope.defaultExtentValue === null) {
                    return;
                }

                // On null input use default $autoExtent value
                const formatExtent = (newValue) => {
                    return newValue === null ? $scope.defaultExtentValue : newValue;
                }

                ngModelController.$formatters.push(formatExtent);

                $scope.$on('formatManualExtent', () => {
                    let viewValue = ngModelController.$modelValue;
                    ngModelController.$formatters.forEach(formatter => {
                        viewValue = formatter(viewValue);
                    });
                    ngModelController.$viewValue = viewValue;
                    ngModelController.$render();
                });
            }
        }
    });
})();
