(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    app.factory('KpiChart', function(ChartCustomMeasures, ChartUsableColumns, ColumnAvailability) {
        return function(element, scope, chartDef, theme) {
            const dataSpec = scope.getDataSpec();
            const customMeasures = ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey, dataSpec.datasetName, scope.getCurrentChartsContext());
            const allMeasures = ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey, dataSpec.datasetName, scope.getCurrentChartsContext()).filter(m => ['NUMERICAL', 'ALPHANUM', 'DATE'].includes(m.type));
            ColumnAvailability.updateAvailableColumns(chartDef.genericMeasures, allMeasures, customMeasures);

            scope.$broadcast('window-resized-kpi', { theme });
        };
    });

})();
