from .artifact import Artifact

class ScriptOutput:
    def __init__(self):
        """
        Instantiate a new governance script output.
        """
        self.json = {}

    @property
    def action(self):
        """
        Return the auto governance action.
        Possible values: DO_NOTHING, GOVERN, HIDE

        :return: the auto governance action as a Python str
        """
        return self.json.get('action')

    @action.setter
    def action(self, action):
        """
        Set the action.
        Possible values: DO_NOTHING, GOVERN, HIDE

        :param str action: the artifact governance action

        :return: None
        """
        self.json['action'] = action


    @property
    def status(self):
        """
        Return the auto governance status.
        Possible values: AUTO, SUGGESTED


        :return: the auto governance status as a Python str
        """
        return self.json.get('status')

    @status.setter
    def status(self, status):
        """
        Set the status.
        Possible values: AUTO, SUGGESTED

        :param str status: the artifact governance status

        :return: None
        """
        self.json['status'] = status


    @property
    def blueprintVersionId(self):
        """
        Return the auto governance blueprintVersionId.

        :return: the auto governance blueprintVersionId as a Python dict.
            A blueprint version id consists of a blueprint id and a blueprint version id.
        """
        return self.json.get('blueprintVersionId')

    @blueprintVersionId.setter
    def blueprintVersionId(self, blueprintVersionId):
        """
        Set the blueprintVersionId.

        :param dict blueprintVersionId: the artifact governance blueprintVersionId
            A blueprint version id consists of a blueprint id and a blueprint version id.

        :return: None
        """
        self.json['blueprintVersionId'] = blueprintVersionId

    @property
    def projectBusinessInitiativeArtifactId(self):
        """
        Return the auto governance business initiative for project artifact.

        :return: the auto governance business initiative for project artifact as a Python str
        """
        return self.json.get('projectBusinessInitiativeArtifactId')

    @projectBusinessInitiativeArtifactId.setter
    def projectBusinessInitiativeArtifactId(self, projectBusinessInitiativeArtifactId):
        """
        Set the business initiative for project artifact .

        :param str status: the business initiative for project artifact

        :return: None
        """
        self.json['projectBusinessInitiativeArtifactId'] = projectBusinessInitiativeArtifactId

    @property
    def projectExistingArtifactId(self):
        """
        Return the auto governance business initiative for project artifact .

        :return: the auto governance business initiative for project artifact as a Python str
        """
        return self.json.get('projectExistingArtifactId')

    @projectExistingArtifactId.setter
    def projectExistingArtifactId(self, projectExistingArtifactId):
        """
        Set the business initiative for project artifact .

        :param str status: the business initiative for project artifact

        :return: None
        """
        self.json['projectExistingArtifactId'] = projectExistingArtifactId

    @property
    def childrenConfiguration(self):
        """
        Return the children autoconfiguration.

        :return: the children autoconfiguration as a Python dict
        """
        return self.json.get('childrenConfiguration')

    @childrenConfiguration.setter
    def childrenConfiguration(self, childrenConfiguration):
        """
        Set the children autoconfiguration.

        :param dict childrenConfiguration: the children autoconfiguration

        :return: None
        """
        self.json['childrenConfiguration'] = childrenConfiguration

    @property
    def artifactPrefill(self):
        """
        Return the artifact to prefill.

        :return: the underlying :class:`govern.models.Artifact` referenced by this enriched artifact
        """
        if 'artifactPrefill' not in self.json:
            self.json['artifactPrefill'] = {'id': None, 'fields':{}}
        return Artifact(self.json['artifactPrefill'])
