import dataiku
from dataiku import pandasutils as pdu
import pandas as pd
import json
import requests
from requests.auth import HTTPBasicAuth

JIRA_TOKEN = "__TO_BE_DEFINED__"
JIRA_USER = "__TO_BE_DEFINED__"
JIRA_URL="__TO_BE_DEFINED__"

def execute(requesting_user, deployment_id, deployment_report, deployer_client, **kwargs):

    if deployment_report['status'] == "ERROR":
        # Define global JIRA call setup
        auth = HTTPBasicAuth(JIRA_USER, JIRA_TOKEN)
        headers = {
          "Accept": "application/json",
          "Content-Type": "application/json"
        }

        # Create content
        apidpl = deployer_client.get_apideployer()
        deplyt = apidpl.get_deployment(deployment_id).get_settings()
        service_id = deplyt.get_raw()['publishedServiceId']
        infra = deplyt.get_raw()['infraId']
        desc = f"The deployment of service '{service_id}' on infrastructure '{infra}' has failed with error(s):\r\n{deployment_report['messages']}"
        payload = json.dumps({
          "fields": {
                "summary": f"Dataiku deployment failure for {deployment_id}",
                "description": desc,
                "issuetype": {
                  "name": "Bug"
                },
                "project": {
                  "key": "SCRUM"
                }
            }
        })
        print("Creating JIRA upon deployment failure")
        print(desc)
        # Post the new issue
        response = requests.request(
           "POST",
           f'{JIRA_URL}/rest/api/latest/issue',
           headers=headers,
           auth=auth,
           data=payload    
        )

        # Print the response
        print(response.json())
        response.raise_for_status()

    return HookResult.success("Ok")
    