import os
from pprint import pprint
from dataikuscoring import load_model


path_to_export = os.path.dirname(os.path.realpath(__file__))

# Load the model from current export path
model = load_model(path_to_export)

# The model provides a simple api similar to scikit-learn with:
# * model.predict to get scoring for a given input data
# * model.predict_proba to get probabilities in case of classification
#
# The accepted format for input data can be either:
# * pandas.DataFrame
# * List of dictionnaries
# * 2D numpy array
# * List of List
#
# The first dimension corresponds to observations
data_to_score = SAMPLE_DATA


# For instance the following will output a numpy array containing the predictions for each
# observation

predict_result = model.predict(data_to_score)
print(" \nOutput of model.predict():\n")
pprint(predict_result)

# In case of classification the following will output a dictionnary of numpy array with
# probabilities for each class
predict_proba_result = model.predict_proba(data_to_score)
print(" \nOutput of model.predict_proba():\n")
pprint(predict_proba_result)
