/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class StringUtils$
implements Logging {
    public static StringUtils$ MODULE$;
    private final Set<UTF8String> trueStrings;
    private final Set<UTF8String> falseStrings;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StringUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String escapeLikeRegex(String pattern, char escapeChar) {
        Iterator in = new StringOps(Predef$.MODULE$.augmentString(pattern)).iterator();
        scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
        block3: while (in.hasNext()) {
            char c = BoxesRunTime.unboxToChar((Object)in.next());
            if (c == escapeChar && in.hasNext()) {
                char c2;
                char c3 = c2 = BoxesRunTime.unboxToChar((Object)in.next());
                switch (c3) {
                    case '%': 
                    case '_': {
                        out.$plus$plus$eq(Pattern.quote(Character.toString(c2)));
                        continue block3;
                    }
                }
                if (c3 == escapeChar) {
                    out.$plus$plus$eq(Pattern.quote(Character.toString(c3)));
                    continue;
                }
                throw QueryCompilationErrors$.MODULE$.escapeCharacterInTheMiddleError(pattern, Character.toString(c2));
            }
            if (c == escapeChar) {
                throw QueryCompilationErrors$.MODULE$.escapeCharacterAtTheEndError(pattern);
            }
            if ('_' == c) {
                out.$plus$plus$eq(".");
                continue;
            }
            if ('%' == c) {
                out.$plus$plus$eq(".*");
                continue;
            }
            out.$plus$plus$eq(Pattern.quote(Character.toString(c)));
        }
        return new StringBuilder(4).append("(?s)").append(out.result()).toString();
    }

    public String getHexString(byte[] bytes) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).map((Function1 & Serializable & scala.Serializable)x$1 -> StringUtils$.$anonfun$getHexString$1(BoxesRunTime.unboxToByte((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", " ", "]");
    }

    public Seq<String> orderSuggestedIdentifiersBySimilarity(String baseString, Seq<Seq<String>> candidates) {
        Seq<String> baseParts = UnresolvedAttribute$.MODULE$.parseAttributeName(baseString);
        Seq strippedCandidates = baseParts.size() == 1 && candidates.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (Seq)x$2.dropRight(1)).size() == 1 ? (Seq)candidates.map((Function1 & Serializable & scala.Serializable)x$3 -> (Seq)x$3.takeRight(1), Seq$.MODULE$.canBuildFrom()) : (baseParts.size() <= 2 && candidates.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> (Seq)x$4.dropRight(2)).size() == 1 ? (Seq)candidates.map((Function1 & Serializable & scala.Serializable)x$5 -> (Seq)x$5.takeRight(2), Seq$.MODULE$.canBuildFrom()) : candidates);
        return (Seq)((SeqLike)strippedCandidates.map((Function1 & Serializable & scala.Serializable)name -> package$.MODULE$.quoteNameParts((Seq<String>)name), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> LevenshteinDistance.getDefaultInstance().apply((CharSequence)x$6, (CharSequence)baseString), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
    }

    public boolean isTrueString(UTF8String s) {
        return this.trueStrings.contains((Object)s.trimAll().toLowerCase());
    }

    public boolean isFalseString(UTF8String s) {
        return this.falseStrings.contains((Object)s.trimAll().toLowerCase());
    }

    public Seq<String> filterPattern(Seq<String> names, String pattern) {
        SortedSet funcNames = SortedSet$.MODULE$.empty((Ordering)Ordering.String$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pattern.trim().split("\\|"))).foreach((Function1 & Serializable & scala.Serializable)subPattern -> {
            BoxedUnit boxedUnit;
            try {
                Regex regex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(4).append("(?i)").append(subPattern.replaceAll("\\*", ".*")).toString())).r();
                boxedUnit = funcNames.$plus$plus$eq((TraversableOnce)names.filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)StringUtils$.$anonfun$filterPattern$2(regex, name))));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return funcNames.toSeq();
    }

    public static final /* synthetic */ String $anonfun$getHexString$1(byte x$1) {
        return new StringOps(Predef$.MODULE$.augmentString("%02X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
    }

    public static final /* synthetic */ boolean $anonfun$filterPattern$2(Regex regex$1, String name) {
        return regex$1.pattern().matcher(name).matches();
    }

    private StringUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.trueStrings = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "true", "y", "yes", "1"}))).map((Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1), Set$.MODULE$.canBuildFrom());
        this.falseStrings = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f", "false", "n", "no", "0"}))).map((Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1), Set$.MODULE$.canBuildFrom());
    }
}

