/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.util;

import com.amazonaws.glue.shims.ShimsLoader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.log4j.Logger;

public final class ExpressionHelper {
    private static final String HIVE_STRING_TYPE_NAME = "string";
    private static final String HIVE_IN_OPERATOR = "IN";
    private static final String HIVE_NOT_IN_OPERATOR = "NOT IN";
    private static final String HIVE_NOT_OPERATOR = "not";
    private static final Logger logger = Logger.getLogger(ExpressionHelper.class);
    private static final List<String> QUOTED_TYPES = ImmutableList.of((Object)"string", (Object)"char", (Object)"varchar", (Object)"date", (Object)"datetime", (Object)"timestamp");
    private static final Joiner JOINER = Joiner.on((String)" AND ");

    public static String convertHiveExpressionToCatalogExpression(byte[] exprBytes) throws MetaException {
        ExprNodeGenericFuncDesc exprTree = ExpressionHelper.deserializeExpr(exprBytes);
        HashSet columnNamesInNotInExpression = Sets.newHashSet();
        ExpressionHelper.fieldEscaper(exprTree.getChildren(), (ExprNodeDesc)exprTree, columnNamesInNotInExpression);
        String expression = ExpressionHelper.rewriteExpressionForNotIn(exprTree.getExprString(), columnNamesInNotInExpression);
        return ExpressionHelper.removeDecimalTypeSuffixIfNecessary(expression);
    }

    @VisibleForTesting
    protected static String removeDecimalTypeSuffixIfNecessary(String expression) {
        expression = expression.replaceAll("L\\)|D\\)|S\\)|Y\\)|BD\\)", ")");
        return expression;
    }

    private static ExprNodeGenericFuncDesc deserializeExpr(byte[] exprBytes) throws MetaException {
        ExprNodeGenericFuncDesc expr = null;
        try {
            expr = ShimsLoader.getHiveShims().getDeserializeExpression(exprBytes);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to deserialize the expression", (Throwable)ex);
            throw new MetaException(ex.getMessage());
        }
        if (expr == null) {
            throw new MetaException("Failed to deserialize expression - ExprNodeDesc not present");
        }
        return expr;
    }

    private static void fieldEscaper(List<ExprNodeDesc> exprNodes, ExprNodeDesc parent, Set<String> columnNamesInNotInExpression) {
        if (exprNodes == null || exprNodes.isEmpty()) {
            return;
        }
        for (ExprNodeDesc nodeDesc : exprNodes) {
            String nodeType = nodeDesc.getTypeString().toLowerCase();
            if (QUOTED_TYPES.contains(nodeType)) {
                PrimitiveTypeInfo tInfo = new PrimitiveTypeInfo();
                tInfo.setTypeName(HIVE_STRING_TYPE_NAME);
                nodeDesc.setTypeInfo((TypeInfo)tInfo);
            }
            ExpressionHelper.addColumnNamesOfNotInExpressionToSet(nodeDesc, parent, columnNamesInNotInExpression);
            ExpressionHelper.fieldEscaper(nodeDesc.getChildren(), nodeDesc, columnNamesInNotInExpression);
        }
    }

    private static void addColumnNamesOfNotInExpressionToSet(ExprNodeDesc childNode, ExprNodeDesc parentNode, Set<String> columnsInNotInExpression) {
        if (parentNode != null && childNode != null && parentNode instanceof ExprNodeGenericFuncDesc && childNode instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc parentFuncNode = (ExprNodeGenericFuncDesc)parentNode;
            ExprNodeGenericFuncDesc childFuncNode = (ExprNodeGenericFuncDesc)childNode;
            if (parentFuncNode.getGenericUDF() instanceof GenericUDFOPNot && childFuncNode.getGenericUDF() instanceof GenericUDFIn) {
                columnsInNotInExpression.addAll(childFuncNode.getCols());
            }
        }
    }

    private static String rewriteExpressionForNotIn(String expression, Set<String> columnsInNotInExpression) {
        for (String columnName : columnsInNotInExpression) {
            if (columnName == null) continue;
            String hiveExpression = ExpressionHelper.getHiveCompatibleNotInExpression(columnName);
            hiveExpression = ExpressionHelper.escapeParentheses(hiveExpression);
            String catalogExpression = ExpressionHelper.getCatalogCompatibleNotInExpression(columnName);
            catalogExpression = ExpressionHelper.escapeParentheses(catalogExpression);
            expression = expression.replaceAll(hiveExpression, catalogExpression);
        }
        return expression;
    }

    private static String getHiveCompatibleNotInExpression(String columnName) {
        return String.format("%s (%s) %s (", HIVE_NOT_OPERATOR, columnName, HIVE_IN_OPERATOR);
    }

    private static String getCatalogCompatibleNotInExpression(String columnName) {
        return String.format("(%s) %s (", columnName, HIVE_NOT_IN_OPERATOR);
    }

    private static String escapeParentheses(String expression) {
        expression = expression.replaceAll("\\(", "\\\\\\(");
        expression = expression.replaceAll("\\)", "\\\\\\)");
        return expression;
    }

    public static String buildExpressionFromPartialSpecification(Table table, List<String> partitionValues) throws MetaException {
        List partitionKeys = table.getPartitionKeys();
        if (partitionValues == null || partitionValues.isEmpty()) {
            return null;
        }
        if (partitionKeys == null || partitionValues.size() > partitionKeys.size()) {
            throw new MetaException("Incorrect number of partition values: " + partitionValues);
        }
        partitionKeys = partitionKeys.subList(0, partitionValues.size());
        LinkedList<String> predicates = new LinkedList<String>();
        for (int i = 0; i < partitionValues.size(); ++i) {
            if (Strings.isNullOrEmpty((String)partitionValues.get(i))) continue;
            predicates.add(ExpressionHelper.buildPredicate((FieldSchema)partitionKeys.get(i), partitionValues.get(i)));
        }
        return JOINER.join(predicates);
    }

    private static String buildPredicate(FieldSchema schema, String value) {
        if (ExpressionHelper.isQuotedType(schema.getType())) {
            return String.format("(%s='%s')", schema.getName(), ExpressionHelper.escapeSingleQuotes(value));
        }
        return String.format("(%s=%s)", schema.getName(), value);
    }

    private static String escapeSingleQuotes(String s) {
        return s.replaceAll("'", "\\\\'");
    }

    private static boolean isQuotedType(String type) {
        return QUOTED_TYPES.contains(type);
    }

    public static String replaceDoubleQuoteWithSingleQuotes(String s) {
        return s.replaceAll("\"", "'");
    }
}

