/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.util;

import com.amazonaws.services.glue.model.InvalidInputException;
import com.amazonaws.services.glue.model.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.TableType;

public enum HiveTableValidator {
    REQUIRED_PROPERTIES_VALIDATOR{

        @Override
        public void validate(Table table) {
            String missingProperty = null;
            if (HiveTableValidator.notApplicableTableType(table)) {
                return;
            }
            if (table.getTableType() == null) {
                missingProperty = "TableType";
            } else if (table.getStorageDescriptor() == null) {
                missingProperty = "StorageDescriptor";
            } else if (table.getStorageDescriptor().getInputFormat() == null) {
                missingProperty = "StorageDescriptor#InputFormat";
            } else if (table.getStorageDescriptor().getOutputFormat() == null) {
                missingProperty = "StorageDescriptor#OutputFormat";
            } else if (table.getStorageDescriptor().getSerdeInfo() == null) {
                missingProperty = "StorageDescriptor#SerdeInfo";
            } else if (table.getStorageDescriptor().getSerdeInfo().getSerializationLibrary() == null) {
                missingProperty = "StorageDescriptor#SerdeInfo#SerializationLibrary";
            }
            if (missingProperty != null) {
                throw new InvalidInputException(String.format("%s cannot be null for table: %s", missingProperty, table.getName()));
            }
        }
    };


    public abstract void validate(Table var1);

    private static boolean notApplicableTableType(Table table) {
        return HiveTableValidator.isNotManagedOrExternalTable(table) || HiveTableValidator.isStorageHandlerType(table);
    }

    private static boolean isNotManagedOrExternalTable(Table table) {
        return table.getTableType() != null && TableType.valueOf((String)table.getTableType()) != TableType.MANAGED_TABLE && TableType.valueOf((String)table.getTableType()) != TableType.EXTERNAL_TABLE;
    }

    private static boolean isStorageHandlerType(Table table) {
        return table.getParameters() != null && table.getParameters().containsKey("storage_handler") && StringUtils.isNotEmpty((CharSequence)((CharSequence)table.getParameters().get("storage_handler")));
    }
}

