/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.util;

import com.amazonaws.glue.catalog.util.PartitionKey;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.InvalidInputException;
import com.amazonaws.services.glue.model.Partition;
import com.amazonaws.services.glue.model.PartitionValueList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PartitionUtils {
    public static Map<PartitionKey, Partition> buildPartitionMap(List<Partition> partitions) {
        HashMap partitionValuesMap = Maps.newHashMap();
        for (Partition partition : partitions) {
            partitionValuesMap.put(new PartitionKey(partition), partition);
        }
        return partitionValuesMap;
    }

    public static List<PartitionValueList> getPartitionValuesList(Map<PartitionKey, Partition> partitionMap) {
        ArrayList partitionValuesList = Lists.newArrayList();
        for (Map.Entry<PartitionKey, Partition> entry : partitionMap.entrySet()) {
            partitionValuesList.add(new PartitionValueList().withValues((Collection)entry.getValue().getValues()));
        }
        return partitionValuesList;
    }

    public static boolean isInvalidUserInputException(Exception e) {
        return e instanceof EntityNotFoundException || e instanceof InvalidInputException;
    }
}

