/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.converters;

import com.amazonaws.glue.catalog.converters.HiveToCatalogConverter;
import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.Partition;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UserDefinedFunctionInput;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.Table;

public final class GlueInputConverter {
    public static DatabaseInput convertToDatabaseInput(Database hiveDatabase) {
        return GlueInputConverter.convertToDatabaseInput(HiveToCatalogConverter.convertDatabase(hiveDatabase));
    }

    public static DatabaseInput convertToDatabaseInput(com.amazonaws.services.glue.model.Database database) {
        DatabaseInput input = new DatabaseInput();
        input.setName(database.getName());
        input.setDescription(database.getDescription());
        input.setLocationUri(database.getLocationUri());
        input.setParameters(database.getParameters());
        return input;
    }

    public static TableInput convertToTableInput(Table hiveTable) {
        return GlueInputConverter.convertToTableInput(HiveToCatalogConverter.convertTable(hiveTable));
    }

    public static TableInput convertToTableInput(com.amazonaws.services.glue.model.Table table) {
        TableInput tableInput = new TableInput();
        tableInput.setRetention(table.getRetention());
        tableInput.setPartitionKeys((Collection)table.getPartitionKeys());
        tableInput.setTableType(table.getTableType());
        tableInput.setName(table.getName());
        tableInput.setOwner(table.getOwner());
        tableInput.setLastAccessTime(table.getLastAccessTime());
        tableInput.setStorageDescriptor(table.getStorageDescriptor());
        tableInput.setParameters(table.getParameters());
        tableInput.setViewExpandedText(table.getViewExpandedText());
        tableInput.setViewOriginalText(table.getViewOriginalText());
        return tableInput;
    }

    public static PartitionInput convertToPartitionInput(org.apache.hadoop.hive.metastore.api.Partition src) {
        return GlueInputConverter.convertToPartitionInput(HiveToCatalogConverter.convertPartition(src));
    }

    public static PartitionInput convertToPartitionInput(Partition src) {
        PartitionInput partitionInput = new PartitionInput();
        partitionInput.setLastAccessTime(src.getLastAccessTime());
        partitionInput.setParameters(src.getParameters());
        partitionInput.setStorageDescriptor(src.getStorageDescriptor());
        partitionInput.setValues((Collection)src.getValues());
        return partitionInput;
    }

    public static Collection<PartitionInput> convertToPartitionInputs(Collection<Partition> parts) {
        ArrayList<PartitionInput> inputList = new ArrayList<PartitionInput>();
        for (Partition part : parts) {
            inputList.add(GlueInputConverter.convertToPartitionInput(part));
        }
        return inputList;
    }

    public static UserDefinedFunctionInput convertToUserDefinedFunctionInput(Function hiveFunction) {
        UserDefinedFunctionInput functionInput = new UserDefinedFunctionInput();
        functionInput.setClassName(hiveFunction.getClassName());
        functionInput.setFunctionName(hiveFunction.getFunctionName());
        functionInput.setOwnerName(hiveFunction.getOwnerName());
        if (hiveFunction.getOwnerType() != null) {
            functionInput.setOwnerType(hiveFunction.getOwnerType().name());
        }
        functionInput.setResourceUris(HiveToCatalogConverter.covertResourceUriList(hiveFunction.getResourceUris()));
        return functionInput;
    }
}

