/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.util;

import com.amazonaws.glue.catalog.util.HiveTableValidator;
import com.amazonaws.glue.shims.AwsGlueHiveShims;
import com.amazonaws.glue.shims.ShimsLoader;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;

public final class MetastoreClientUtils {
    private static final AwsGlueHiveShims hiveShims = ShimsLoader.getHiveShims();

    private MetastoreClientUtils() {
    }

    public static boolean makeDirs(Warehouse wh, Path path) throws MetaException {
        Preconditions.checkNotNull((Object)wh, (Object)"Warehouse cannot be null");
        Preconditions.checkNotNull((Object)path, (Object)"Path cannot be null");
        boolean madeDir = false;
        if (!wh.isDir(path)) {
            if (!hiveShims.mkdirs(wh, path)) {
                throw new MetaException("Unable to create path: " + path);
            }
            madeDir = true;
        }
        return madeDir;
    }

    public static void validateTableObject(Table table, Configuration conf) throws InvalidObjectException {
        Preconditions.checkNotNull((Object)table, (Object)"table cannot be null");
        Preconditions.checkNotNull((Object)table.getSd(), (Object)"Table#StorageDescriptor cannot be null");
        if (!hiveShims.validateTableName(table.getTableName(), conf)) {
            throw new InvalidObjectException(table.getTableName() + " is not a valid object name");
        }
        String validate = hiveShims.validateTblColumns(table.getSd().getCols());
        if (validate != null) {
            throw new InvalidObjectException("Invalid column " + validate);
        }
        if (table.getPartitionKeys() != null && (validate = hiveShims.validateTblColumns(table.getPartitionKeys())) != null) {
            throw new InvalidObjectException("Invalid partition column " + validate);
        }
    }

    public static void validateGlueTable(com.amazonaws.services.glue.model.Table table) {
        Preconditions.checkNotNull((Object)table, (Object)"table cannot be null");
        for (HiveTableValidator validator : HiveTableValidator.values()) {
            validator.validate(table);
        }
    }

    public static <K, V> Map<K, V> deepCopyMap(Map<K, V> originalMap) {
        HashMap deepCopy = Maps.newHashMap();
        if (originalMap == null) {
            return deepCopy;
        }
        for (Map.Entry<K, V> entry : originalMap.entrySet()) {
            deepCopy.put(entry.getKey(), entry.getValue());
        }
        return deepCopy;
    }

    public static boolean isExternalTable(Table table) {
        String paramsExternalStr;
        if (table == null) {
            return false;
        }
        Map params = table.getParameters();
        String string = paramsExternalStr = params == null ? null : (String)params.get("EXTERNAL");
        if (paramsExternalStr != null) {
            return "TRUE".equalsIgnoreCase(paramsExternalStr);
        }
        return table.getTableType() != null && TableType.EXTERNAL_TABLE.name().equalsIgnoreCase(table.getTableType());
    }

    public static String getCatalogId(Configuration conf) {
        if (StringUtils.isNotEmpty((CharSequence)conf.get("hive.metastore.glue.catalogid"))) {
            return conf.get("hive.metastore.glue.catalogid");
        }
        return null;
    }

    public static boolean isLakeFormationCatalog(Configuration conf) {
        return conf.getBoolean("hive.metastore.glue.lake-formation.enabled", false);
    }
}

