/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.CheckpointInstance;
import org.apache.spark.sql.delta.CheckpointInstance$;
import org.apache.spark.sql.delta.CheckpointInstance$Format$SENTINEL$;
import org.apache.spark.sql.delta.CheckpointInstance$Format$SINGLE$;
import org.apache.spark.sql.delta.CheckpointInstance$Format$V2$;
import org.apache.spark.sql.delta.CheckpointInstance$Format$WITH_PARTS$;
import org.apache.spark.sql.delta.Checkpoints$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.LastCheckpointInfo;
import org.apache.spark.sql.delta.LastCheckpointInfo$;
import org.apache.spark.sql.delta.LastCheckpointV2;
import org.apache.spark.sql.delta.MetadataCleanup;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotManagement;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005c\u0001\u0003\u0017.!\u0003\r\t\u0001O?\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b)\u0003a\u0011A&\t\u000bQ\u0003a\u0011A&\t\u000bU\u0003a\u0011\u0003,\t\u000bu\u0003a\u0011\u00030\t\u000b\u0015\u0004A\u0011\u00014\t\u000fI\u0004!\u0019!C\u0001\u0017\")1\u000f\u0001C\ti\"1\u00111\u0004\u0001\u0005\u0002\u0019Cq!a\u0007\u0001\t\u0003\ti\u0003C\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!A\u0011q\t\u0001\u0005\u00125\nI\u0005C\u0004\u0002b\u0001!\t\"a\u0019\t\u0011\u0005\u001d\u0004\u0001\"\u0001.\u0003SBq!!\u001d\u0001\t\u0013\t\u0019\bC\u0004\u0002z\u0001!\t\"a\u001f\t\u000f\u0005\u001d\u0005\u0001\"\u0005\u0002\n\"9\u0011q\u0011\u0001\u0005\u0012\u0005=\u0005\"CAK\u0001E\u0005I\u0011CAL\u0011!\ti\u000b\u0001C\t[\u0005=\u0006BCAa\u0001E\u0005I\u0011C\u0017\u0002D\u001e9\u0011qY\u0017\t\u0002\u0005%gA\u0002\u0017.\u0011\u0003\tY\rC\u0004\u0002Nb!\t!a4\t\u0013\u0005E\u0007D1A\u0005\u0002\u0005M\u0007\u0002CAr1\u0001\u0006I!!6\t\u0011\u0005\u0015\b\u0004\"\u0001.\u0003OD\u0001B!\u0002\u0019\t\u0003i#q\u0001\u0005\b\u0005#AB\u0011\u0001B\n\u0011!\u0011i\u0004\u0007C\t[\t}\u0002b\u0002BQ1\u0011\u0005!1\u0015\u0005\b\u0005\u007fCB\u0011\u0001Ba\u0011!\u0011I\r\u0007C\u0001[\t-\u0007\u0002\u0003Bn1\u0011\u0005QF!8\t\u0011\t\u0015\b\u0004\"\u0001.\u0005ODqaa\u0003\u0019\t\u0003\u0019i\u0001C\u0004\u0004 a!\ta!\t\t\u0013\r\u0015\u0002D1A\u0005\u0002\u0005M\u0007\u0002CB\u00141\u0001\u0006I!!6\t\u0013\r%\u0002D1A\u0005\u0002\u0005M\u0007\u0002CB\u00161\u0001\u0006I!!6\t\u000f\r5\u0002\u0004\"\u0001\u00040\tY1\t[3dWB|\u0017N\u001c;t\u0015\tqs&A\u0003eK2$\u0018M\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001aE\u0002\u0001s}\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012a!\u00118z%\u00164\u0007C\u0001!D\u001b\u0005\t%B\u0001\".\u0003!iW\r^3sS:<\u0017B\u0001#B\u00051!U\r\u001c;b\u0019><w-\u001b8h\u0003\u0019!\u0013N\\5uIQ\tq\t\u0005\u0002;\u0011&\u0011\u0011j\u000f\u0002\u0005+:LG/A\u0004m_\u001e\u0004\u0016\r\u001e5\u0016\u00031\u0003\"!\u0014*\u000e\u00039S!a\u0014)\u0002\u0005\u0019\u001c(BA)4\u0003\u0019A\u0017\rZ8pa&\u00111K\u0014\u0002\u0005!\u0006$\b.\u0001\u0005eCR\f\u0007+\u0019;i\u0003\u0015\u0019Ho\u001c:f+\u00059\u0006C\u0001-\\\u001b\u0005I&B\u0001..\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001X-\u0003\u00111{wm\u0015;pe\u0016\fA\u0002Z8M_\u001e\u001cE.Z1okB$\"aR0\t\u000b\u0001,\u0001\u0019A1\u0002#Mt\u0017\r]:i_R$vn\u00117fC:,\b\u000f\u0005\u0002cG6\tQ&\u0003\u0002e[\tA1K\\1qg\"|G/\u0001\ndQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dGCA4k!\tQ\u0004.\u0003\u0002jw\t\u0019\u0011J\u001c;\t\u000b-4\u0001\u0019\u00017\u0002\u00115,G/\u00193bi\u0006\u0004\"!\u001c9\u000e\u00039T!a\\\u0017\u0002\u000f\u0005\u001cG/[8og&\u0011\u0011O\u001c\u0002\t\u001b\u0016$\u0018\rZ1uC\u0006yA*Q*U?\u000eCUiQ&Q\u001f&sE+A\u0010xSRD7\t[3dWB|\u0017N\u001c;Fq\u000e,\u0007\u000f^5p]\"\u000bg\u000e\u001a7j]\u001e$B!^>\u0002\u0002Q\u0011qI\u001e\u0005\u0007o\"!\t\u0019\u0001=\u0002\u000bQDWO\\6\u0011\u0007iJx)\u0003\u0002{w\tAAHY=oC6,g\bC\u0003}\u0011\u0001\u0007Q0\u0001\u0005eK2$\u0018\rT8h!\t\u0011g0\u0003\u0002\u0000[\tAA)\u001a7uC2{w\rC\u0004\u0002\u0004!\u0001\r!!\u0002\u0002\r=\u0004H+\u001f9f!\u0011\t9!!\u0006\u000f\t\u0005%\u0011\u0011\u0003\t\u0004\u0003\u0017YTBAA\u0007\u0015\r\tyaN\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M1(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\tIB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'Y\u0014AC2iK\u000e\\\u0007o\\5oi\":\u0011\"a\b\u0002&\u0005%\u0002c\u0001\u001e\u0002\"%\u0019\u00111E\u001e\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0002(\u0005\tE\u000b[5tA5,G\u000f[8eA%\u001c\b\u0005Z3qe\u0016\u001c\u0017\r^3eA\u0005tG\rI<jY2\u0004#-\u001a\u0011sK6|g/\u001a3!S:\u0004c-\u001e;ve\u0016\u0004c/\u001a:tS>t7OL\u0011\u0003\u0003W\tA!\r\u001a/aQ\u0019q)a\f\t\r\u0005E\"\u00021\u0001b\u0003Q\u0019h.\u00199tQ>$Hk\\\"iK\u000e\\\u0007o\\5oi\u0006I2M]3bi\u0016\u001c\u0005.Z2la>Lg\u000e^!u-\u0016\u00148/[8o)\r9\u0015q\u0007\u0005\b\u0003sY\u0001\u0019AA\u001e\u0003\u001d1XM]:j_:\u00042AOA\u001f\u0013\r\tyd\u000f\u0002\u0005\u0019>tw-\u0001\u000fdQ\u0016\u001c7\u000e]8j]R\fe\u000eZ\"mK\u0006tW\u000b\u001d#fYR\fGj\\4\u0015\u0007\u001d\u000b)\u0005\u0003\u0004\u000221\u0001\r!Y\u0001\u0018oJLG/\u001a'bgR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016$raRA&\u0003\u001b\n9\u0006C\u0003}\u001b\u0001\u0007Q\u0010C\u0004\u0002P5\u0001\r!!\u0015\u0002%1\f7\u000f^\"iK\u000e\\\u0007o\\5oi&sgm\u001c\t\u0004E\u0006M\u0013bAA+[\t\u0011B*Y:u\u0007\",7m\u001b9pS:$\u0018J\u001c4p\u0011\u001d\tI&\u0004a\u0001\u00037\n1\"\u00193e\u0007\",7m[:v[B\u0019!(!\u0018\n\u0007\u0005}3HA\u0004C_>dW-\u00198\u0002)]\u0014\u0018\u000e^3DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3t)\u0011\t\t&!\u001a\t\r\u0005Eb\u00021\u0001b\u0003Y\u0011X-\u00193MCN$8\t[3dWB|\u0017N\u001c;GS2,GCAA6!\u0015Q\u0014QNA)\u0013\r\tyg\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0002)1|\u0017\rZ'fi\u0006$\u0017\r^1Ge>lg)\u001b7f)\u0011\tY'!\u001e\t\r\u0005]\u0004\u00031\u0001h\u0003\u0015!(/[3t\u0003Yi\u0017M\\;bY2LHj\\1e\u0007\",7m\u001b9pS:$H\u0003BA)\u0003{Bq!a \u0012\u0001\u0004\t\t)\u0001\u0002dmB\u0019!-a!\n\u0007\u0005\u0015UF\u0001\nDQ\u0016\u001c7\u000e]8j]RLen\u001d;b]\u000e,\u0017\u0001\t4j]\u0012d\u0015m\u001d;D_6\u0004H.\u001a;f\u0007\",7m\u001b9pS:$()\u001a4pe\u0016$B!a#\u0002\u000eB)!(!\u001c\u0002\u0002\"9\u0011\u0011\b\nA\u0002\u0005mB\u0003BAF\u0003#C\u0011\"a%\u0014!\u0003\u0005\r!a#\u0002%\rDWmY6q_&tG/\u00138ti\u0006t7-Z\u0001+M&tG\rT1ti\u000e{W\u000e\u001d7fi\u0016\u001c\u0005.Z2la>Lg\u000e\u001e\"fM>\u0014X\r\n3fM\u0006,H\u000e\u001e\u00132+\t\tIJ\u000b\u0003\u0002\f\u0006m5FAAO!\u0011\ty*!+\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d6(\u0001\u0006b]:|G/\u0019;j_:LA!a+\u0002\"\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002G\u001d,G\u000fT1uKN$8i\\7qY\u0016$Xm\u00115fG.\u0004x.\u001b8u\rJ|W\u000eT5tiR1\u00111RAY\u0003wCq!a-\u0016\u0001\u0004\t),A\u0005j]N$\u0018M\\2fgB)!(a.\u0002\u0002&\u0019\u0011\u0011X\u001e\u0003\u000b\u0005\u0013(/Y=\t\u0013\u0005uV\u0003%AA\u0002\u0005}\u0016a\u00058pi2\u000bG/\u001a:UQ\u0006tg+\u001a:tS>t\u0007#\u0002\u001e\u0002n\u0005m\u0012!L4fi2\u000bG/Z:u\u0007>l\u0007\u000f\\3uK\u000eCWmY6q_&tGO\u0012:p[2K7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0019\u0016\u0005\u0003\u007f\u000bY*A\u0006DQ\u0016\u001c7\u000e]8j]R\u001c\bC\u00012\u0019'\rA\u0012hP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005%\u0017!\u0007'B'R{6\tS#D\u0017B{\u0015J\u0014+`\r&cUi\u0018(B\u001b\u0016+\"!!6\u0011\t\u0005]\u0017\u0011]\u0007\u0003\u00033TA!a7\u0002^\u0006!A.\u00198h\u0015\t\ty.\u0001\u0003kCZ\f\u0017\u0002BA\f\u00033\f!\u0004T!T)~\u001b\u0005*R\"L!>Ke\nV0G\u00132+uLT!N\u000b\u0002\n1f\u00195fG.\u0004x.\u001b8u'\u000eDW-\\1U_^\u0013\u0018\u000e^3J]2\u000b7\u000f^\"iK\u000e\\\u0007o\\5oi\u001aKG.\u001a\u000b\u0007\u0003S\f9P!\u0001\u0011\u000bi\ni'a;\u0011\t\u00055\u00181_\u0007\u0003\u0003_T1!!=0\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t)0a<\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u000439\u0001\u0007\u0011\u0011 \t\u0005\u0003w\fi0D\u00010\u0013\r\typ\f\u0002\r'B\f'o[*fgNLwN\u001c\u0005\b\u0005\u0007a\u0002\u0019AAv\u0003\u0019\u00198\r[3nC\u0006yqO]5uK\u000eCWmY6q_&tG\u000f\u0006\u0005\u0002R\t%!1\u0002B\u0007\u0011\u0019\u0011T\u00041\u0001\u0002z\")A0\ba\u0001{\"1!qB\u000fA\u0002\u0005\f\u0001b\u001d8baNDw\u000e^\u0001\u0017O\u0016$8\t[3dWB|\u0017N\u001c;Xe&$X\rU1uQR\u0001\"Q\u0003B\u000e\u0005S\u0011YC!\f\u00032\tU\"\u0011\b\t\u0006u\t]A\nT\u0005\u0004\u00053Y$A\u0002+va2,'\u0007C\u0004\u0003\u001ey\u0001\rAa\b\u0002\t\r|gN\u001a\t\u0005\u0005C\u0011)#\u0004\u0002\u0003$)\u0019!Q\u0004)\n\t\t\u001d\"1\u0005\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b)s\u0002\u0019\u0001'\t\u000f\u0005eb\u00041\u0001\u0002<!1!q\u0006\u0010A\u0002\u001d\f\u0001B\\;n!\u0006\u0014Ho\u001d\u0005\u0007\u0005gq\u0002\u0019A4\u0002\tA\f'\u000f\u001e\u0005\b\u0005oq\u0002\u0019AA.\u0003%)8/\u001a*f]\u0006lW\rC\u0004\u0003<y\u0001\r!a\u0017\u0002'Y\u00144\t[3dWB|\u0017N\u001c;F]\u0006\u0014G.\u001a3\u00023]\u0014\u0018\u000e^3U_BdUM^3m-J\u001a\u0005.Z2la>Lg\u000e\u001e\u000b\u0017\u0005\u0003\u0012YG! \u0003\n\n-%q\u0012BI\u0005'\u00139Ja'\u0003 BY!Ha\u0011\u0003H\t5#QMAu\u0013\r\u0011)e\u000f\u0002\u0007)V\u0004H.\u001a\u001b\u0011\u00075\u0013I%C\u0002\u0003L9\u0013!BR5mKN#\u0018\r^;t!\u0019\u0011yE!\u0017\u0003`9!!\u0011\u000bB+\u001d\u0011\tYAa\u0015\n\u0003qJ1Aa\u0016<\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0017\u0003^\t\u00191+Z9\u000b\u0007\t]3\bE\u0002n\u0005CJ1Aa\u0019o\u0005\u0019\t5\r^5p]B\u0019!Ma\u001a\n\u0007\t%TF\u0001\tMCN$8\t[3dWB|\u0017N\u001c;We!9!QN\u0010A\u0002\t=\u0014A\u0005<3\u0007\",7m\u001b9pS:$hi\u001c:nCR\u0004BA!\u001d\u0003x9\u0019!Ma\u001d\n\u0007\tUT&\u0001\u0007We\rCWmY6q_&tG/\u0003\u0003\u0003z\tm$A\u0002$pe6\fGOC\u0002\u0003v5BqAa  \u0001\u0004\u0011\t)\u0001\ftS\u0012,7-\u0019:DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3t!\u0015Q\u0014q\u0017BB!\r\u0011'QQ\u0005\u0004\u0005\u000fk#AF*fe&\fG.\u001b>bE2,g)\u001b7f'R\fG/^:\t\rIz\u0002\u0019AA}\u0011\u001d\u0011ii\ba\u0001\u0003W\fQb]5eK\u000e\f'oU2iK6\f\u0007B\u0002B\b?\u0001\u0007\u0011\rC\u0003}?\u0001\u0007Q\u0010C\u0004\u0003\u0016~\u0001\r!a\u000f\u00025I|wo],sSR$XM\\%o\u0007\",7m\u001b9pS:$(j\u001c2\t\u000f\teu\u00041\u0001\u0002<\u00059\u0002/\u0019:rk\u0016$h)\u001b7fgNK'0Z%o\u0005f$Xm\u001d\u0005\b\u0005;{\u0002\u0019\u0001B\u0010\u0003)A\u0017\rZ8pa\u000e{gN\u001a\u0005\b\u0005oy\u0002\u0019AA.\u0003u\u0019'/Z1uK\u000eCWmY6q_&tGO\u0016\u001aQCJ\fX/\u001a;GS2,G\u0003DAv\u0005K\u00139Ka.\u0003<\nu\u0006B\u0002\u001a!\u0001\u0004\tI\u0010C\u0004\u0003*\u0002\u0002\rAa+\u0002\u0005\u0011\u001c\bCBA~\u0005[\u0013\t,C\u0002\u00030>\u0012q\u0001R1uCN,G\u000f\u0005\u0003\u0002|\nM\u0016b\u0001B[_\t\u0019!k\\<\t\r\te\u0006\u00051\u0001M\u0003%1\u0017N\\1m!\u0006$\b\u000eC\u0004\u0003\u001e\u0002\u0002\rAa\b\t\u000f\t]\u0002\u00051\u0001\u0002\\\u0005!BO]5n\u0019\u0006\u001cHo\u00115fG.\u0004x.\u001b8u-J\"bA!\u001a\u0003D\n\u001d\u0007b\u0002BcC\u0001\u0007!QM\u0001\u0011Y\u0006\u001cHo\u00115fG.\u0004x.\u001b8u-JBaAM\u0011A\u0002\u0005e\u0018\u0001\b:f]\u0006lW-\u00118e\u00072,\u0017M\\;q)\u0016l\u0007\u000fU1si\u001aKG.\u001a\u000b\b\u000f\n5'\u0011\u001bBj\u0011\u0019\u0011yM\ta\u0001\u0019\u0006AA/Z7q!\u0006$\b\u000e\u0003\u0004\u0003:\n\u0002\r\u0001\u0014\u0005\u0007\u001f\n\u0002\rA!6\u0011\u00075\u00139.C\u0002\u0003Z:\u0013!BR5mKNK8\u000f^3n\u0003%I7oR\"T!\u0006$\b\u000e\u0006\u0004\u0002\\\t}'\u0011\u001d\u0005\b\u0005;\u001b\u0003\u0019\u0001B\u0010\u0011\u0019\u0011\u0019o\ta\u0001\u0019\u0006!\u0001/\u0019;i\u0003=\u0011W/\u001b7e\u0007\",7m\u001b9pS:$HC\u0002Bu\u0007\u000b\u0019I\u0001\u0005\u0003\u0003l\n}h\u0002\u0002Bw\u0005{tAAa<\u0003|:!!\u0011\u001fB}\u001d\u0011\u0011\u0019Pa>\u000f\t\u0005-!Q_\u0005\u0002m%\u0011A'N\u0005\u0003eMJ!\u0001M\u0019\n\u0007\t]s&\u0003\u0003\u0004\u0002\r\r!!\u0003#bi\u00064%/Y7f\u0015\r\u00119f\f\u0005\b\u0007\u000f!\u0003\u0019\u0001Bu\u0003\u0015\u0019H/\u0019;f\u0011\u0019\u0011y\u0001\na\u0001C\u0006A2\u000f[8vY\u0012<&/\u001b;f'R\fGo]!t'R\u0014Xo\u0019;\u0015\r\u0005m3qBB\u000f\u0011\u001d\u0011i\"\na\u0001\u0007#\u0001Baa\u0005\u0004\u001a5\u00111Q\u0003\u0006\u0004\u0007/y\u0013\u0001C5oi\u0016\u0014h.\u00197\n\t\rm1Q\u0003\u0002\b'Fc5i\u001c8g\u0011\u0019\u0011y!\na\u0001C\u000612\u000f[8vY\u0012<&/\u001b;f'R\fGo]!t\u0015N|g\u000e\u0006\u0003\u0002\\\r\r\u0002B\u0002B\bM\u0001\u0007\u0011-\u0001\u000eT)J+6\tV0Q\u0003J#\u0016\nV%P\u001dN{6i\u0014'`\u001d\u0006kU)A\u000eT)J+6\tV0Q\u0003J#\u0016\nV%P\u001dN{6i\u0014'`\u001d\u0006kU\tI\u0001\u0016'R\u0013Vk\u0011+`'R\u000bEkU0D\u001f2{f*Q'F\u0003Y\u0019FKU+D)~\u001bF+\u0011+T?\u000e{Ej\u0018(B\u001b\u0016\u0003\u0013AF3yiJ\f7\r\u001e)beRLG/[8o-\u0006dW/Z:\u0015\r\rE2\u0011HB\u001f!\u0015Q\u0014QNB\u001a!\u0011\tYp!\u000e\n\u0007\r]rF\u0001\u0004D_2,XN\u001c\u0005\b\u0007wY\u0003\u0019AAv\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007bBB W\u0001\u0007\u0011QA\u0001\u0017a\u0006\u0014H/\u001b;j_:4\u0016\r\\;fg\u000e{GNT1nK\u0002")
public interface Checkpoints
extends DeltaLogging {
    public static Option<Column> extractPartitionValues(StructType structType, String string) {
        return Checkpoints$.MODULE$.extractPartitionValues(structType, string);
    }

    public static String STRUCT_STATS_COL_NAME() {
        return Checkpoints$.MODULE$.STRUCT_STATS_COL_NAME();
    }

    public static String STRUCT_PARTITIONS_COL_NAME() {
        return Checkpoints$.MODULE$.STRUCT_PARTITIONS_COL_NAME();
    }

    public static boolean shouldWriteStatsAsJson(Snapshot snapshot) {
        return Checkpoints$.MODULE$.shouldWriteStatsAsJson(snapshot);
    }

    public static boolean shouldWriteStatsAsStruct(SQLConf sQLConf, Snapshot snapshot) {
        return Checkpoints$.MODULE$.shouldWriteStatsAsStruct(sQLConf, snapshot);
    }

    public static LastCheckpointV2 trimLastCheckpointV2(LastCheckpointV2 lastCheckpointV2, SparkSession sparkSession) {
        return Checkpoints$.MODULE$.trimLastCheckpointV2(lastCheckpointV2, sparkSession);
    }

    public static StructType createCheckpointV2ParquetFile(SparkSession sparkSession, Dataset<Row> dataset, Path path, Configuration configuration, boolean bl) {
        return Checkpoints$.MODULE$.createCheckpointV2ParquetFile(sparkSession, dataset, path, configuration, bl);
    }

    public static Tuple2<Path, Path> getCheckpointWritePath(Configuration configuration, Path path, long l, int n, int n2, boolean bl, boolean bl2) {
        return Checkpoints$.MODULE$.getCheckpointWritePath(configuration, path, l, n, n2, bl, bl2);
    }

    public static String LAST_CHECKPOINT_FILE_NAME() {
        return Checkpoints$.MODULE$.LAST_CHECKPOINT_FILE_NAME();
    }

    public void org$apache$spark$sql$delta$Checkpoints$_setter_$LAST_CHECKPOINT_$eq(Path var1);

    public Path logPath();

    public Path dataPath();

    public LogStore store();

    public void doLogCleanup(Snapshot var1);

    public static /* synthetic */ int checkpointInterval$(Checkpoints $this, Metadata metadata) {
        return $this.checkpointInterval(metadata);
    }

    default public int checkpointInterval(Metadata metadata) {
        return BoxesRunTime.unboxToInt((Object)DeltaConfigs$.MODULE$.CHECKPOINT_INTERVAL().fromMetaData(metadata));
    }

    public Path LAST_CHECKPOINT();

    public static /* synthetic */ void withCheckpointExceptionHandling$(Checkpoints $this, DeltaLog deltaLog, String opType, Function0 thunk) {
        $this.withCheckpointExceptionHandling(deltaLog, opType, (Function0<BoxedUnit>)thunk);
    }

    default public void withCheckpointExceptionHandling(DeltaLog deltaLog, String opType, Function0<BoxedUnit> thunk) {
        try {
            thunk.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                boolean throwError;
                Throwable e = (Throwable)option.get();
                DeltaLog x$1 = deltaLog;
                String x$2 = opType;
                Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)e.getMessage()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stackTrace"), (Object)e.getStackTrace())}));
                Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                Option<Path> x$5 = this.recordDeltaEvent$default$5();
                this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Error when writing checkpoint-related files", e);
                boolean bl = throwError = Utils$.MODULE$.isTesting() || BoxesRunTime.unboxToBoolean((Object)((DeltaLog)this).spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_CHECKPOINT_THROW_EXCEPTION_WHEN_FAILED()));
                if (throwError) {
                    throw e;
                }
            }
            throw throwable;
        }
    }

    public static /* synthetic */ void checkpoint$(Checkpoints $this) {
        $this.checkpoint();
    }

    default public void checkpoint() {
        this.checkpoint(((SnapshotManagement)((Object)this)).unsafeVolatileSnapshot());
    }

    public static /* synthetic */ void checkpoint$(Checkpoints $this, Snapshot snapshotToCheckpoint) {
        $this.checkpoint(snapshotToCheckpoint);
    }

    default public void checkpoint(Snapshot snapshotToCheckpoint) {
        this.recordDeltaOperation((DeltaLog)this, "delta.checkpoint", this.recordDeltaOperation$default$3(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withCheckpointExceptionHandling(snapshotToCheckpoint.deltaLog(), "delta.checkpoint.sync.error", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (snapshotToCheckpoint.version() < 0L) {
                throw DeltaErrors$.MODULE$.checkpointNonExistTable(((DeltaLog)this).dataPath());
            }
            this.checkpointAndCleanUpDeltaLog(snapshotToCheckpoint);
        }));
    }

    public static /* synthetic */ void createCheckpointAtVersion$(Checkpoints $this, long version) {
        $this.createCheckpointAtVersion(version);
    }

    default public void createCheckpointAtVersion(long version) {
        this.recordDeltaOperation((DeltaLog)this, "delta.createCheckpointAtVersion", this.recordDeltaOperation$default$3(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Snapshot snapshot = ((SnapshotManagement)((Object)this)).getSnapshotAt(version, ((SnapshotManagement)((Object)this)).getSnapshotAt$default$2());
            this.withCheckpointExceptionHandling((DeltaLog)this, "delta.checkpoint.sync.error", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (snapshot.version() < 0L) {
                    throw DeltaErrors$.MODULE$.checkpointNonExistTable(((DeltaLog)this).dataPath());
                }
                this.writeCheckpointFiles(snapshot);
            });
        });
    }

    public static /* synthetic */ void checkpointAndCleanUpDeltaLog$(Checkpoints $this, Snapshot snapshotToCheckpoint) {
        $this.checkpointAndCleanUpDeltaLog(snapshotToCheckpoint);
    }

    default public void checkpointAndCleanUpDeltaLog(Snapshot snapshotToCheckpoint) {
        LastCheckpointInfo lastCheckpointInfo = this.writeCheckpointFiles(snapshotToCheckpoint);
        this.writeLastCheckpointFile(snapshotToCheckpoint.deltaLog(), lastCheckpointInfo, LastCheckpointInfo$.MODULE$.checksumEnabled(((DeltaLog)this).spark()));
        ((MetadataCleanup)((Object)this)).doLogCleanup(snapshotToCheckpoint);
    }

    public static /* synthetic */ void writeLastCheckpointFile$(Checkpoints $this, DeltaLog deltaLog, LastCheckpointInfo lastCheckpointInfo, boolean addChecksum) {
        $this.writeLastCheckpointFile(deltaLog, lastCheckpointInfo, addChecksum);
    }

    default public void writeLastCheckpointFile(DeltaLog deltaLog, LastCheckpointInfo lastCheckpointInfo, boolean addChecksum) {
        this.withCheckpointExceptionHandling(deltaLog, "delta.lastCheckpoint.write.error", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean suppressOptionalFields = BoxesRunTime.unboxToBoolean((Object)((DeltaLog)this).spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.SUPPRESS_OPTIONAL_LAST_CHECKPOINT_FIELDS()));
            LastCheckpointInfo lastCheckpointInfoToWrite = lastCheckpointInfo;
            String json = LastCheckpointInfo$.MODULE$.serializeToJson(lastCheckpointInfoToWrite, addChecksum, suppressOptionalFields);
            ((DeltaLog)this).store().write(this.LAST_CHECKPOINT(), (Iterator<String>)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{json})), true, ((DeltaLog)this).newDeltaHadoopConf());
        });
    }

    public static /* synthetic */ LastCheckpointInfo writeCheckpointFiles$(Checkpoints $this, Snapshot snapshotToCheckpoint) {
        return $this.writeCheckpointFiles(snapshotToCheckpoint);
    }

    default public LastCheckpointInfo writeCheckpointFiles(Snapshot snapshotToCheckpoint) {
        snapshotToCheckpoint.ensureCommitFilesBackfilled();
        return Checkpoints$.MODULE$.writeCheckpoint(((DeltaLog)this).spark(), (DeltaLog)this, snapshotToCheckpoint);
    }

    public static /* synthetic */ Option readLastCheckpointFile$(Checkpoints $this) {
        return $this.readLastCheckpointFile();
    }

    default public Option<LastCheckpointInfo> readLastCheckpointFile() {
        return this.loadMetadataFromFile(0);
    }

    private Option<LastCheckpointInfo> loadMetadataFromFile(int tries) {
        return (Option)this.recordDeltaOperation((DeltaLog)this, "delta.deltaLog.loadMetadataFromFile", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
            Option option;
            try {
                Seq<String> lastCheckpointInfoJson = ((DeltaLog)this).store().read(this.LAST_CHECKPOINT(), ((DeltaLog)this).newDeltaHadoopConf());
                boolean validate = LastCheckpointInfo$.MODULE$.checksumEnabled(((DeltaLog)this).spark());
                option = new Some((Object)LastCheckpointInfo$.MODULE$.deserializeFromJson((String)lastCheckpointInfoJson.head(), validate));
            }
            catch (Throwable throwable) {
                Option option2;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof FileNotFoundException) {
                    option = None$.MODULE$;
                }
                Option option3 = NonFatal$.MODULE$.unapply(throwable2);
                if (!option3.isEmpty()) {
                    Throwable e = (Throwable)option3.get();
                    if (tries < 3) {
                        this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(138).append("Failed to parse ").append(this.LAST_CHECKPOINT()).append(". This may happen if there was an error ").append("during read operation, or a file appears to be partial. Sleeping and trying again.").toString(), e);
                        Thread.sleep(1000L);
                        option = this.loadMetadataFromFile(tries + 1);
                    }
                }
                if (!(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option2.get();
                    DeltaLog x$1 = (DeltaLog)this;
                    String x$2 = "delta.lastCheckpoint.read.corruptedJson";
                    Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)Utils$.MODULE$.exceptionString(e))}));
                    Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                    Option<Path> x$5 = this.recordDeltaEvent$default$5();
                    this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append(this.LAST_CHECKPOINT()).append(" is corrupted. Will search the checkpoint files directly").toString(), e);
                    Option<CheckpointInstance> verifiedCheckpoint = this.findLastCompleteCheckpointBefore((Option<CheckpointInstance>)None$.MODULE$);
                    option = verifiedCheckpoint.map((Function1 & Serializable & scala.Serializable)cv -> this.manuallyLoadCheckpoint((CheckpointInstance)cv));
                }
                throw throwable;
            }
            return option;
        });
    }

    public static /* synthetic */ LastCheckpointInfo manuallyLoadCheckpoint$(Checkpoints $this, CheckpointInstance cv) {
        return $this.manuallyLoadCheckpoint(cv);
    }

    default public LastCheckpointInfo manuallyLoadCheckpoint(CheckpointInstance cv) {
        return new LastCheckpointInfo(cv.version(), -1L, cv.numParts(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<StructType>)None$.MODULE$, LastCheckpointInfo$.MODULE$.apply$default$7(), LastCheckpointInfo$.MODULE$.apply$default$8());
    }

    public static /* synthetic */ Option findLastCompleteCheckpointBefore$(Checkpoints $this, long version) {
        return $this.findLastCompleteCheckpointBefore(version);
    }

    default public Option<CheckpointInstance> findLastCompleteCheckpointBefore(long version) {
        long x$1 = version;
        CheckpointInstance$Format$SINGLE$ x$2 = CheckpointInstance$Format$SINGLE$.MODULE$;
        None$ x$3 = None$.MODULE$;
        Option<String> x$4 = CheckpointInstance$.MODULE$.apply$default$3();
        CheckpointInstance upperBound = new CheckpointInstance(x$1, x$2, x$4, (Option<Object>)x$3);
        return this.findLastCompleteCheckpointBefore((Option<CheckpointInstance>)new Some((Object)upperBound));
    }

    public static /* synthetic */ Option findLastCompleteCheckpointBefore$(Checkpoints $this, Option checkpointInstance) {
        return $this.findLastCompleteCheckpointBefore((Option<CheckpointInstance>)checkpointInstance);
    }

    default public Option<CheckpointInstance> findLastCompleteCheckpointBefore(Option<CheckpointInstance> checkpointInstance) {
        Tuple2 tuple2 = (Tuple2)checkpointInstance.collect((PartialFunction)new scala.Serializable((DeltaLog)this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends CheckpointInstance, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.version() >= 0L) {
                    return (B1)new Tuple2(A1, (Object)BoxesRunTime.boxToLong((long)A1.version()));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(CheckpointInstance x1) {
                CheckpointInstance checkpointInstance = x1;
                return checkpointInstance.version() >= 0L;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)CheckpointInstance$.MODULE$.sentinelValue((Option<Object>)None$.MODULE$), (Object)BoxesRunTime.boxToLong((long)0L)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        CheckpointInstance upperBoundCv = (CheckpointInstance)tuple2._1();
        long startVersion = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)upperBoundCv, (Object)BoxesRunTime.boxToLong((long)startVersion));
        CheckpointInstance upperBoundCv2 = (CheckpointInstance)tuple22._1();
        long startVersion2 = tuple22._2$mcJ$sp();
        LongRef cur = LongRef.create((long)startVersion2);
        Configuration hadoopConf = ((DeltaLog)this).newDeltaHadoopConf();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Try to find Delta last complete checkpoint before version ").append(startVersion2).toString());
        while (cur.elem >= 0L) {
            CheckpointInstance[] checkpoints = (CheckpointInstance[])((DeltaLog)this).store().listFrom(FileNames$.MODULE$.listingPrefix(((DeltaLog)this).logPath(), scala.math.package$.MODULE$.max(0L, cur.elem - 1000L)), hadoopConf).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Checkpoints.$anonfun$findLastCompleteCheckpointBefore$3(file))).map((Function1 & Serializable & scala.Serializable)file -> CheckpointInstance$.MODULE$.apply(file.getPath())).takeWhile((Function1 & Serializable & scala.Serializable)tv -> BoxesRunTime.boxToBoolean((boolean)Checkpoints.$anonfun$findLastCompleteCheckpointBefore$5(cur, upperBoundCv2, tv))).toArray(ClassTag$.MODULE$.apply(CheckpointInstance.class));
            Option<CheckpointInstance> lastCheckpoint = this.getLatestCompleteCheckpointFromList(checkpoints, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)upperBoundCv2.version())));
            if (lastCheckpoint.isDefined()) {
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Delta checkpoint is found at version ").append(((CheckpointInstance)lastCheckpoint.get()).version()).toString());
                return lastCheckpoint;
            }
            cur.elem -= 1000L;
        }
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("No checkpoint found for Delta table before version ").append(startVersion2).toString());
        return None$.MODULE$;
    }

    public static /* synthetic */ Option findLastCompleteCheckpointBefore$default$1$(Checkpoints $this) {
        return $this.findLastCompleteCheckpointBefore$default$1();
    }

    default public Option<CheckpointInstance> findLastCompleteCheckpointBefore$default$1() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Option getLatestCompleteCheckpointFromList$(Checkpoints $this, CheckpointInstance[] instances, Option notLaterThanVersion) {
        return $this.getLatestCompleteCheckpointFromList(instances, (Option<Object>)notLaterThanVersion);
    }

    default public Option<CheckpointInstance> getLatestCompleteCheckpointFromList(CheckpointInstance[] instances, Option<Object> notLaterThanVersion) {
        CheckpointInstance sentinelCv = CheckpointInstance$.MODULE$.sentinelValue(notLaterThanVersion);
        Map complete = (Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instances)).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.$less$eq(sentinelCv))))).groupBy((Function1 & Serializable & scala.Serializable)x -> (CheckpointInstance)Predef$.MODULE$.identity(x)).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Checkpoints.$anonfun$getLatestCompleteCheckpointFromList$3(x0$1)));
        if (complete.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some(complete.keys().max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
    }

    public static /* synthetic */ Option getLatestCompleteCheckpointFromList$default$2$(Checkpoints $this) {
        return $this.getLatestCompleteCheckpointFromList$default$2();
    }

    default public Option<Object> getLatestCompleteCheckpointFromList$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ boolean $anonfun$findLastCompleteCheckpointBefore$3(FileStatus file) {
        return FileNames$.MODULE$.isCheckpointFile(file) && file.getLen() != 0L;
    }

    public static /* synthetic */ boolean $anonfun$findLastCompleteCheckpointBefore$5(LongRef cur$1, CheckpointInstance upperBoundCv$1, CheckpointInstance tv) {
        return (cur$1.elem == 0L || tv.version() <= cur$1.elem) && tv.$less(upperBoundCv$1);
    }

    public static /* synthetic */ boolean $anonfun$getLatestCompleteCheckpointFromList$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            CheckpointInstance ci = (CheckpointInstance)tuple2._1();
            CheckpointInstance[] matchingCheckpointInstances = (CheckpointInstance[])tuple2._2();
            CheckpointInstance.Format format = ci.format();
            if (CheckpointInstance$Format$SINGLE$.MODULE$.equals(format)) {
                return matchingCheckpointInstances.length == 1;
            }
            if (CheckpointInstance$Format$WITH_PARTS$.MODULE$.equals(format)) {
                Predef$.MODULE$.assert(ci.numParts().nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Multi-Part Checkpoint must have non empty numParts");
                return matchingCheckpointInstances.length == BoxesRunTime.unboxToInt((Object)ci.numParts().get());
            }
            if (CheckpointInstance$Format$V2$.MODULE$.equals(format)) {
                return matchingCheckpointInstances.length == 1;
            }
            if (CheckpointInstance$Format$SENTINEL$.MODULE$.equals(format)) {
                return false;
            }
            throw new MatchError((Object)format);
        }
        throw new MatchError((Object)tuple2);
    }

    public static void $init$(Checkpoints $this) {
        $this.org$apache$spark$sql$delta$Checkpoints$_setter_$LAST_CHECKPOINT_$eq(new Path(((DeltaLog)$this).logPath(), Checkpoints$.MODULE$.LAST_CHECKPOINT_FILE_NAME()));
    }
}

