/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateVpcRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateVpcRequestMarshaller
implements Marshaller<Request<CreateVpcRequest>, CreateVpcRequest> {
    @Override
    public Request<CreateVpcRequest> marshall(CreateVpcRequest createVpcRequest) {
        SdkInternalList createVpcRequestTagSpecificationsList;
        if (createVpcRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateVpcRequest> request = new DefaultRequest<CreateVpcRequest>(createVpcRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVpc");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcRequest.getCidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString(createVpcRequest.getCidrBlock()));
        }
        if (createVpcRequest.getAmazonProvidedIpv6CidrBlock() != null) {
            request.addParameter("AmazonProvidedIpv6CidrBlock", StringUtils.fromBoolean(createVpcRequest.getAmazonProvidedIpv6CidrBlock()));
        }
        if (createVpcRequest.getIpv6Pool() != null) {
            request.addParameter("Ipv6Pool", StringUtils.fromString(createVpcRequest.getIpv6Pool()));
        }
        if (createVpcRequest.getIpv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringUtils.fromString(createVpcRequest.getIpv6CidrBlock()));
        }
        if (createVpcRequest.getIpv4IpamPoolId() != null) {
            request.addParameter("Ipv4IpamPoolId", StringUtils.fromString(createVpcRequest.getIpv4IpamPoolId()));
        }
        if (createVpcRequest.getIpv4NetmaskLength() != null) {
            request.addParameter("Ipv4NetmaskLength", StringUtils.fromInteger(createVpcRequest.getIpv4NetmaskLength()));
        }
        if (createVpcRequest.getIpv6IpamPoolId() != null) {
            request.addParameter("Ipv6IpamPoolId", StringUtils.fromString(createVpcRequest.getIpv6IpamPoolId()));
        }
        if (createVpcRequest.getIpv6NetmaskLength() != null) {
            request.addParameter("Ipv6NetmaskLength", StringUtils.fromInteger(createVpcRequest.getIpv6NetmaskLength()));
        }
        if (createVpcRequest.getInstanceTenancy() != null) {
            request.addParameter("InstanceTenancy", StringUtils.fromString(createVpcRequest.getInstanceTenancy()));
        }
        if (createVpcRequest.getIpv6CidrBlockNetworkBorderGroup() != null) {
            request.addParameter("Ipv6CidrBlockNetworkBorderGroup", StringUtils.fromString(createVpcRequest.getIpv6CidrBlockNetworkBorderGroup()));
        }
        if (!(createVpcRequestTagSpecificationsList = (SdkInternalList)createVpcRequest.getTagSpecifications()).isEmpty() || !createVpcRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVpcRequestTagSpecificationsListValue : createVpcRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVpcRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createVpcRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVpcRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

