/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.shared.WorkSetPreparator;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.distributed.metrics.ContainerUsageMetrics;
import com.dataiku.dip.security.AuthCtx;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class MLTaskHandler<T extends MLTask> {
    protected T task;
    protected MLTaskLoc taskLoc;
    protected AnalysisCoreParams acp;
    protected String sessionId;
    protected WorkSet ws;
    protected Queue<WorkSet.PreprocessingSet> workQueue;
    protected AuthCtx user;

    public MLTaskHandler(AnalysisCoreParams acp, MLTaskLoc taskLoc, T task, String sessionId, AuthCtx user) {
        this.acp = acp;
        this.taskLoc = taskLoc;
        this.sessionId = sessionId;
        this.user = user;
        this.task = task;
    }

    protected void dispatchWork() {
        if (this.ws.preprocessingSets.size() == 0) {
            throw new IllegalArgumentException("No model to train");
        }
        this.workQueue = new LinkedBlockingQueue<WorkSet.PreprocessingSet>(this.ws.preprocessingSets.size());
        this.workQueue.addAll(this.ws.preprocessingSets);
    }

    public List<FullModelId> getTrainedModelIds() {
        return this.ws.getModelIds();
    }

    public abstract void train() throws Exception;

    public abstract void init(WorkSetPreparator var1) throws Exception;

    public abstract void abort();

    public abstract void abort(List<FullModelId> var1) throws IOException;

    public abstract Map<FullModelId, ContainerUsageMetrics> getContainerUsageMetricsPerModel();

    public abstract List<Integer> getKernelPids();
}

