/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.clustering.MLLibClusteringRescoringHandler;
import com.dataiku.dip.analysis.ml.clustering.PythonClusteringRescoringHandler;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class ClusteringRescoringHandler {
    private static Logger logger = Logger.getLogger((String)"dku.analysis.prediction");

    public abstract void rescore() throws Exception;

    public abstract void abort() throws Exception;

    static ClusteringRescoringHandler from(AuthCtx authCtx, FullModelId fmid) throws IOException, NotFoundException {
        MLTask.BackendType backend = fmid.getHeadMLTask().backendType;
        switch (backend) {
            case H2O: 
            case MLLIB: {
                return new MLLibClusteringRescoringHandler(authCtx, fmid);
            }
            case PY_MEMORY: {
                return new PythonClusteringRescoringHandler(authCtx, fmid);
            }
        }
        throw new IllegalArgumentException("Rescoring not available on backend " + String.valueOf((Object)backend));
    }

    public static FuturePayload buildFuturePayload(FullModelId fmi) {
        FuturePayload fp = new FuturePayload();
        fp.action = "rescore";
        fp.targets.add(DSSFuturePayloadUtils.forFMI(fmi).withPart("rescore"));
        fp.displayName = "Rescoring work";
        return fp;
    }

    public static class RescoringWorkThread
    extends FutureThread<Void> {
        private final FullModelId modelId;
        private final FuturePayload futurePayload;
        protected MLTaskLoc loc;
        protected AnalysisCoreParams cp;

        public RescoringWorkThread(DSSAuthCtx user, FullModelId modelId) {
            super(user);
            this.modelId = modelId;
            this.futurePayload = ClusteringRescoringHandler.buildFuturePayload(modelId);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public Void getResult() {
            return null;
        }

        public void execute() throws Exception {
            final ClusteringRescoringHandler handler = ClusteringRescoringHandler.from(this.owner, this.modelId);
            try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        handler.abort();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Error white aborting the rescoring task", (Throwable)e);
                    }
                }
            });){
                handler.rescore();
            }
        }

        public String getModelId() {
            return this.modelId.toString();
        }
    }
}

