/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProcessorWithResolvedParams;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.ProcessorWithSubProcess;
import com.dataiku.dip.SingleCopyAdditionalInputsLoader;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLFlowUtils;
import com.dataiku.dip.analysis.ml.SavedModelCodes;
import com.dataiku.dip.analysis.ml.ScoringRecipeUtils;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.AbstractScoringRecipeRunner;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesBasicService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesUtils;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionScoringJobDef;
import com.dataiku.dip.analysis.ml.prediction.flow.PyPredictionScoringRecipeSubrunner;
import com.dataiku.dip.analysis.ml.prediction.flow.SQLPredictionRecipeSubrunner;
import com.dataiku.dip.analysis.ml.prediction.flow.SnowflakeJavaUDFPredictionRecipeSubrunner;
import com.dataiku.dip.analysis.ml.prediction.flow.TabularPredictionScoringRecipePayloadParams;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.ConditionalOutput;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbstractPythonRecipeRunner;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.FilteringProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.ProcessorWithFactories;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SRPAdapter;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalayer.SingleOutputRowProcessor;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.AdditionalInputsHelper;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.server.StreamedAdditionalInputAccessor;
import com.dataiku.dip.shaker.streamimpl.StreamPipelineFactory;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.CollectionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.scoring.Try;
import com.dataiku.scoring.builders.Build;
import com.dataiku.scoring.builders.ObservationBuilder;
import com.dataiku.scoring.pipelines.AbstractPipeline;
import com.dataiku.scoring.pipelines.AbstractProbabilisticClassificationPipeline;
import com.dataiku.scoring.pipelines.BinaryProbabilisticPipeline;
import com.dataiku.scoring.pipelines.ClassificationResult;
import com.dataiku.scoring.pipelines.Coercion;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationPipeline;
import com.dataiku.scoring.pipelines.NonProbabilisticClassificationResult;
import com.dataiku.scoring.pipelines.Normalization;
import com.dataiku.scoring.pipelines.PartitionedPipeline;
import com.dataiku.scoring.pipelines.Pipeline;
import com.dataiku.scoring.pipelines.ProbabilisticClassificationPipeline;
import com.dataiku.scoring.pipelines.RegressionPipeline;
import com.dataiku.scoring.pipelines.RegressionResult;
import com.dataiku.scoring.pipelines.Result;
import com.dataiku.scoring.util.RawObservation;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ClassicalPredictionScoringRecipeRunner
extends AbstractScoringRecipeRunner {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private PredictionRecipesBasicService predictionRecipesBasicService;
    private TabularPredictionScoringRecipePayloadParams desc;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.prediction.scoring");

    public ClassicalPredictionScoringRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    public void setPayload(String payload) {
        this.desc = (TabularPredictionScoringRecipePayloadParams)JSON.parse((String)payload, TabularPredictionScoringRecipePayloadParams.class);
    }

    @Override
    public void run() throws Exception {
        List<FlowDataset> inputFDS = this.activity.getSubgraph().getSourceDatasets();
        if (inputFDS.size() == 0) {
            throw ErrorContext.iae((String)"Missing input dataset in scoring recipe");
        }
        String managedFolderSmartId = PredictionRecipesUtils.getManagedFolderSmartNameOrNull(this.recipe);
        try (AutoDelete outputTmpDir = FlowJobUtils.getTmpFolder("prediction-scoring-recipe", "run");){
            MLFlowUtils.PredictionScoringRecipeStatusComputer computer = new MLFlowUtils.PredictionScoringRecipeStatusComputer(this.recipe.getModel(), JSON.json((Object)this.desc));
            MLFlowUtils.PredictionScoringRecipeScorability scorability = computer.getScorability_T(this.authCtx, this.activity);
            InitializableAbortableRecipeRunner runner = null;
            String hadMetadataColName = ScoringRecipeUtils.ModelMetadataUtils.schemaIncludesModelMetadata(scorability.inputDataset.getSchema());
            if (this.desc.outputModelMetadata && hadMetadataColName != null) {
                throw new Exception("\"" + hadMetadataColName + "\" is a reserved column name for model metadata output");
            }
            block2 : switch (scorability.model.savedModelType.savedModelHandlingType) {
                case INTERNAL: {
                    if (scorability.modelPartitionMode == MLFlowUtils.ModelPartitionMode.PARTITIONED_DISPATCH && this.desc.outputExplanations) {
                        this.activity.warnContext.addWarning(WarningsContext.WarningType.PARTITION_MODE_UNSUPPORTED, "Computing explanations is not supported with partition redispatch", logger);
                    }
                    if (this.desc.outputExplanations) {
                        if (this.desc.backendType.supportsExplanations()) {
                            if (!this.desc.forceOriginalEngine) {
                                this.desc.forceOriginalEngine = true;
                                logger.info((Object)"Force original engine to compute explanations");
                            }
                        } else {
                            this.activity.warnContext.addWarning(WarningsContext.WarningType.ENGINE_UNSUPPORTED, "Can not compute individual explanations with backend: " + String.valueOf((Object)this.desc.backendType), logger);
                        }
                    }
                    ClassicalPredictionModelDetails details = PredictionResultsReader.makeDetails(scorability.fmi);
                    SerializedShakerScript script = (SerializedShakerScript)JSON.parseFile((File)new File(scorability.activeModelFolder, "script.json"), SerializedShakerScript.class);
                    script.contextProjectKey = scorability.model.projectKey;
                    if (details.coreParams.prediction_type == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION) {
                        if (!this.desc.overrideModelSpecifiedThreshold) {
                            ModelUserMeta mum = (ModelUserMeta)JSON.parseFile((File)new File(scorability.activeModelFolder.getAbsoluteFile(), "user_meta.json"), ModelUserMeta.class);
                            this.desc.forcedClassifierThreshold = mum.activeClassifierThreshold;
                        }
                        logger.info((Object)("Will predict with threshold = " + this.desc.forcedClassifierThreshold));
                    }
                    logger.info((Object)"Adapting inferred output schema from training schema to avoid inconsistencies");
                    Schema preparationOSchemaToUse = MLFlowUtils.getSchemaToUseForPreparedScoringInput(details.preprocessing, details.splitDesc.schema, scorability.inferredPreparedSchema, false, false, this.activity);
                    JSON.prettyToFile((Object)this.desc, (File)new File((File)outputTmpDir, "desc.json"));
                    JSON.prettyToFile((Object)preparationOSchemaToUse, (File)new File((File)outputTmpDir, "preparation_output_schema.json"));
                    JSON.prettyToFile(scorability.model.conditionalOutputs, (File)new File((File)outputTmpDir, "conditional_outputs.json"));
                    ResolvedClassicalPredictionPreprocessingParams rppp = (ResolvedClassicalPredictionPreprocessingParams)JSON.parseFile((File)new File(scorability.activeModelFolder.getAbsoluteFile(), "rpreprocessing_params.json"), ResolvedClassicalPredictionPreprocessingParams.class);
                    PreTrainPredictionModelingParams rpmp = (PreTrainPredictionModelingParams)JSON.parseFile((File)new File(scorability.activeModelFolder.getAbsoluteFile(), "rmodeling_params.json"), PreTrainPredictionModelingParams.class);
                    ResolvedClassicalPredictionCoreParams coreParams = (ResolvedClassicalPredictionCoreParams)scorability.fmi.getResolvedCoreParams();
                    RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)this.activity.getSubgraph();
                    FlowDataset inputFD = subgraph.getSourceDataset(scorability.inputDataset.getFullName());
                    FlowDataset outputFD = subgraph.getTargetDataset(scorability.outputDataset.getFullName());
                    List<Partition> inputPartitions = subgraph.getSourcePartitions(inputFD);
                    Partition outputPartition = subgraph.getTargetPartition(outputFD);
                    ContainerExecSelection containerSelection = this.recipe.getModel().getParamsAs(ContainerRecipeParams.class).getContainerSelection();
                    logger.info((Object)("Selected engine type: " + scorability.engineToUse.type));
                    JobContext.getCurrentActivitySummary().engineType = scorability.engineToUse.type;
                    if (!scorability.engineToUse.isSelectable) {
                        throw new Exception("No allowed engine could be selected");
                    }
                    switch (scorability.engineToUse.type) {
                        case "DSS": {
                            if (scorability.isJavaCompatible && (scorability.backendType.isSparkBased() || !this.desc.forceOriginalEngine)) {
                                if (containerSelection.containerMode == ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER) {
                                    logger.warnV("Ignoring container config %s, scoring with DSS engine.", new Object[]{containerSelection.containerConf});
                                }
                                if (scorability.modelPartitionMode != MLFlowUtils.ModelPartitionMode.PARTITIONED_DISPATCH) {
                                    this.runJavaStreaming(coreParams, rpmp, rppp, scorability.model, script, scorability.inputDataset, inputPartitions, scorability.outputDataset, outputPartition, scorability.activeModelFolder, (File)outputTmpDir, this.desc.outputModelMetadata, scorability.fmi);
                                    break block2;
                                }
                                this.runPartitionDispatchJavaStreaming(scorability.fmi, coreParams, rpmp, rppp, scorability.model, script, scorability.inputDataset, inputPartitions, scorability.outputDataset, outputPartition, scorability.activeModelFolder, (File)outputTmpDir, this.desc.outputModelMetadata);
                                break block2;
                            }
                            runner = this.createRunnerWithOriginalEngine(scorability.model, scorability.activeModelFolder, script, scorability.inputDataset, scorability.outputDataset, outputTmpDir, scorability.fmi, managedFolderSmartId);
                            break block2;
                        }
                        case "SPARK": {
                            if (scorability.backendType.isSparkBased()) {
                                if (this.desc.forceOriginalEngine || !scorability.isJavaCompatible) {
                                    runner = this.createRunnerWithOriginalEngine(scorability.model, scorability.activeModelFolder, script, scorability.inputDataset, scorability.outputDataset, outputTmpDir, scorability.fmi, managedFolderSmartId);
                                    break block2;
                                }
                                runner = this.createRunnerSparkJavaBased(script, scorability.inputDataset, inputPartitions, scorability.outputDataset, outputPartition, scorability.activeModelFolder, preparationOSchemaToUse, (File)outputTmpDir, scorability.fmi, scorability.modelPartitionMode);
                                break block2;
                            }
                            if (!scorability.isJavaCompatible) {
                                throw new IllegalArgumentException("This model cannot be converted to a java model; Spark scoring not applicable.");
                            }
                            runner = this.createRunnerSparkJavaBased(script, scorability.inputDataset, inputPartitions, scorability.outputDataset, outputPartition, scorability.activeModelFolder, preparationOSchemaToUse, (File)outputTmpDir, scorability.fmi, scorability.modelPartitionMode);
                            break block2;
                        }
                        case "SQL": {
                            if (scorability.backendType == MLTask.BackendType.VERTICA) {
                                throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_VERTICA_NOT_SUPPORTED, "Cannot run prediction scoring recipe " + this.recipe.getName());
                            }
                            if (containerSelection.containerMode == ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER) {
                                logger.warnV("Ignoring container config %s, scoring with SQL engine.", new Object[]{containerSelection.containerConf});
                            }
                            RecipeRunnableSubgraph sg = (RecipeRunnableSubgraph)this.activity.getSubgraph();
                            String connection = SQLQueryRecipeUtils.getSourceConnections((AuthCtx)this.authCtx, (RecipeRunnableSubgraph)sg).firstConnection;
                            AbstractSQLConnection conn = SQLConnectionProvider.getDSSConnection(this.authCtx, connection);
                            Schema predictedColumns = this.predictionRecipesBasicService.getColumnsToAddForPrediction(this.desc, details, scorability.model);
                            if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn) && SnowflakeJavaUDFPredictionRecipeSubrunner.isModelSupported(scorability.fmi)) {
                                if (!scorability.isJavaCompatible) {
                                    throw new IllegalArgumentException("Model cannot be converted to SQL; in-database scoring not applicable.");
                                }
                                runner = new SnowflakeJavaUDFPredictionRecipeSubrunner(this.activity, scorability.fmi, predictedColumns, this.desc);
                                logger.info((Object)"Running with Snowflake UDF backend");
                                break block2;
                            }
                            if (!scorability.isSqlCompatible) {
                                throw new IllegalArgumentException("Model cannot be converted to SQL; in-database scoring not applicable.");
                            }
                            runner = new SQLPredictionRecipeSubrunner(this.activity, scorability.fmi, predictedColumns, this.desc);
                            logger.info((Object)"Running with SQL query backend");
                            break block2;
                        }
                    }
                    throw new IllegalStateException("Unexpected value: " + scorability.engineToUse.type);
                }
                case EXTERNAL_MLFLOW: {
                    String proxy;
                    logger.info((Object)("Selected engine type: " + scorability.engineToUse.type));
                    JobContext.getCurrentActivitySummary().engineType = scorability.engineToUse.type;
                    JSON.prettyToFile((Object)this.desc, (File)new File((File)outputTmpDir, "desc.json"));
                    if (Objects.nonNull(scorability.model.proxyModelConfiguration) && StringUtils.isNotBlank((String)scorability.model.proxyModelConfiguration.connection)) {
                        ConnectionsDAO cdao = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
                        DSSConnection connection = cdao.getMandatoryConnection(this.authCtx, scorability.model.proxyModelConfiguration.connection);
                        if (!connection.isFreelyUsableBy(this.authCtx)) {
                            throw new UnauthorizedException("Access to this connection is not authorized.", "connection-access-denied");
                        }
                        proxy = ExternalInfrasUtils.getProxy(connection).getAsString();
                    } else {
                        proxy = ApplicationConfigurator.getProxySettings().getAsString();
                    }
                    runner = this.createMLflowPyfuncRunner(scorability.model, scorability.fmi.getMLflowImportedModelMetadata(), scorability.activeModelFolder, scorability.inputDataset, scorability.outputDataset, outputTmpDir, this.desc, scorability.fmi, proxy);
                    break;
                }
                case PYTHON_AGENT: 
                case PLUGIN_AGENT: 
                case TOOLS_USING_AGENT: {
                    throw new IllegalArgumentException("Agents are not supported in scoring recipe");
                }
                case LLM_GENERIC: {
                    throw new IllegalArgumentException("Fine-tuned LLMs are not supported in scoring recipe");
                }
                case RETRIEVAL_AUGMENTED_LLM: {
                    throw new IllegalArgumentException("Retrieval Augmented LLMs are not supported in scoring recipe");
                }
            }
            if (runner != null) {
                this.startRunner(runner);
            }
        }
    }

    private void runJavaStreaming(ResolvedClassicalPredictionCoreParams coreParams, PreTrainPredictionModelingParams rpmp, ResolvedPredictionPreprocessingParams rppp, SavedModel sm, SerializedShakerScript script, Dataset inputDS, List<Partition> inputPartitions, Dataset outputDS, Partition outputPartition, File activeModelFolder, File outputTmpDir, boolean hadModelMetadata, FullModelId fmi) throws Exception {
        logger.info((Object)"Running with a java streaming scoring engine.");
        Schema preparationOutputSchema = (Schema)JSON.parseFile((File)new File(outputTmpDir, "preparation_output_schema.json"), Schema.class);
        URL resources = activeModelFolder.getAbsoluteFile().toURI().toURL();
        fmi = hadModelMetadata ? fmi : null;
        this.scoreDatasetStreaming(this.activity, inputDS, inputPartitions, outputDS, outputPartition, script, switch (coreParams.prediction_type) {
            case PredictionMLTask.PredictionType.REGRESSION -> new RegressionScoringOutput(rppp, rpmp.algorithm.backendType, preparationOutputSchema, Build.regressionPipeline((URL)resources), fmi);
            case PredictionMLTask.PredictionType.BINARY_CLASSIFICATION, PredictionMLTask.PredictionType.MULTICLASS -> {
                if (rpmp.algorithm.meta.hasProbabilities(rpmp)) {
                    if (coreParams.prediction_type == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION) {
                        Double threshold = this.desc.overrideModelSpecifiedThreshold ? Double.valueOf(this.desc.forcedClassifierThreshold) : null;
                        logger.info((Object)("Scoring binary model streaming with threshold: " + this.desc.forcedClassifierThreshold));
                        yield new BinaryProbabilisticClassificationScoringOutput(rppp, rpmp.algorithm.backendType, preparationOutputSchema, Build.binaryProbabilisticPipeline((URL)resources, (Double)threshold, null), sm.conditionalOutputs, this.desc.outputProbaPercentiles, fmi);
                    }
                    yield new MulticlassProbabilisticClassificationScoringOutput(rppp, rpmp.algorithm.backendType, preparationOutputSchema, (ProbabilisticClassificationPipeline)Build.multiclassProbabilisticPipeline((URL)resources), fmi);
                }
                yield new NonProbabilisticClassificationScoringOutput(rppp, rpmp.algorithm.backendType, preparationOutputSchema, Build.nonProbabilisticClassificationPipeline((URL)resources), fmi);
            }
            default -> throw new IllegalArgumentException("Unsupported prediction type:" + String.valueOf((Object)coreParams.prediction_type));
        });
    }

    private void runPartitionDispatchJavaStreaming(FullModelId fmi, ResolvedClassicalPredictionCoreParams coreParams, PreTrainPredictionModelingParams rpmp, ResolvedPredictionPreprocessingParams rppp, SavedModel sm, SerializedShakerScript script, Dataset inputDS, List<Partition> inputPartitions, Dataset outputDS, Partition outputPartition, File activeModelFolder, File outputTmpDir, boolean hadModelMetadata) throws Exception {
        logger.info((Object)"Running with a java streaming scoring engine, with partition redispatch.");
        Schema schema = (Schema)JSON.parseFile((File)new File(outputTmpDir, "preparation_output_schema.json"), Schema.class);
        for (String dimension : coreParams.partitionedModel.dimensionNames) {
            schema.addColumn(inputDS.getSchema().getColumn(dimension));
        }
        FullModelId modelMetadataFMI = hadModelMetadata ? fmi : null;
        URL resources = activeModelFolder.getAbsoluteFile().toURI().toURL();
        this.scoreDatasetStreaming(this.activity, inputDS, inputPartitions, outputDS, outputPartition, script, switch (coreParams.prediction_type) {
            case PredictionMLTask.PredictionType.REGRESSION -> new RegressionScoringOutput(rppp, rpmp.algorithm.backendType, schema, Build.regressionPipeline((URL)resources, fmi.getPartitionModelUrls()), modelMetadataFMI);
            case PredictionMLTask.PredictionType.BINARY_CLASSIFICATION, PredictionMLTask.PredictionType.MULTICLASS -> {
                if (rpmp.algorithm.meta.hasProbabilities(rpmp)) {
                    if (coreParams.prediction_type == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION) {
                        yield new BinaryProbabilisticClassificationScoringOutput(rppp, rpmp.algorithm.backendType, schema, Build.binaryProbabilisticPipeline((URL)resources, null, fmi.getPartitionModelUrls()), sm.conditionalOutputs, this.desc.outputProbaPercentiles, modelMetadataFMI);
                    }
                    yield new MulticlassProbabilisticClassificationScoringOutput(rppp, rpmp.algorithm.backendType, schema, (ProbabilisticClassificationPipeline)Build.multiclassProbabilisticPipeline((URL)resources, fmi.getPartitionModelUrls()), modelMetadataFMI);
                }
                yield new NonProbabilisticClassificationScoringOutput(rppp, rpmp.algorithm.backendType, schema, Build.nonProbabilisticClassificationPipeline((URL)resources, fmi.getPartitionModelUrls()), modelMetadataFMI);
            }
            default -> throw new IllegalArgumentException("Unsupported prediction type:" + String.valueOf((Object)coreParams.prediction_type));
        });
    }

    private InitializableAbortableRecipeRunner createRunnerWithOriginalEngine(SavedModel sm, File activeModelFolder, SerializedShakerScript script, Dataset inputDataset, Dataset outputDataset, AutoDelete outputTmpDir, FullModelId fmi, @Nullable String managedFolderSmartId) throws IOException {
        logger.info((Object)"Running with original engine");
        if (this.desc.backendType != MLTask.BackendType.PY_MEMORY && this.desc.backendType != MLTask.BackendType.KERAS) {
            ContainerExecSelection containerSelection = this.recipe.getModel().getParamsAs(ContainerRecipeParams.class).getContainerSelection();
            if (containerSelection.containerMode == ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER) {
                logger.warnV("Ignoring container config %s, not compatible with %s scoring.", new Object[]{containerSelection.containerConf, this.desc.backendType});
            }
        }
        switch (this.desc.backendType) {
            case PY_MEMORY: {
                logger.info((Object)"Running with a python backend");
                return this.createPythonRunner(sm, script, inputDataset, managedFolderSmartId, outputDataset, activeModelFolder, outputTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_SCORE_PYTHON, "dataiku.doctor.prediction.reg_scoring_recipe", fmi);
            }
            case KERAS: {
                logger.info((Object)"Running with a keras backend");
                return this.createPythonRunner(sm, script, inputDataset, managedFolderSmartId, outputDataset, activeModelFolder, outputTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_SCORE_KERAS, "dataiku.doctor.prediction.keras_scoring_recipe", fmi);
            }
            case MLLIB: 
            case H2O: {
                logger.info((Object)"Running with a spark backend");
                return this.createOriginalSparkRunner(script, inputDataset, outputDataset, fmi, activeModelFolder, (File)outputTmpDir);
            }
        }
        throw new NotImplementedException("Unsupported backend type: " + String.valueOf((Object)this.desc.backendType));
    }

    private InitializableAbortableRecipeRunner createOriginalSparkRunner(final SerializedShakerScript script, final Dataset inputDataset, final Dataset outputDataset, final FullModelId fmi, final File activeModelFolder, final File outputTmpDir) throws IOException {
        final String hiveDb = SparkRecipeUtils.getHiveMetastoreDatabase(this.activity, this.datasetsDAO);
        return new AbstractSparkBasedRecipeRunner(this.activity){

            @Override
            public void run() throws Exception {
                SerializedShakerScript expandedScript = script.expandedDeepCopy(ClassicalPredictionScoringRecipeRunner.this.variablesService.getForProject(this.projectKey));
                ClassicalPredictionScoringRecipeRunner.this.gatherer.gatherAndCompute(ClassicalPredictionScoringRecipeRunner.this.authCtx, this.projectKey, expandedScript.steps);
                JSON.prettyToFile((Object)expandedScript, (File)new File(outputTmpDir, "script.json"));
                JSON.prettyToFile(ClassicalPredictionScoringRecipeRunner.this.gatherer.getResourceMapping(), (File)new File(outputTmpDir, "resource_mapping.json"));
                FilesystemACLUtils.grantFSReadACLs(this.authCtxService.getAuthCtx(), fmi.getProjectKey(), fmi.getFolderEnsuringSecurity());
                this.runSpark("prediction", ClassicalPredictionScoringRecipeRunner.this.desc.sparkParams.sparkExecutionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

                    @Override
                    public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                        return helper.makeClassJobWithNonSecretGlobalFiles("DSS  (predict): " + activity.id(), effectiveConf, ClassicalPredictionScoringRecipeRunner.this.gatherer.getResourceFiles(), ClassicalPredictionScoringRecipeRunner.this.desc.backendType == MLTask.BackendType.H2O, "com.dataiku.dip.spark.MLLibPredictionScoringJob", activeModelFolder.getAbsolutePath(), recipe.getProjectKey(), AnyLoc.resolveFull(inputDataset.getFullName()).getSmartName(recipe.getProjectKey()), AnyLoc.resolveFull(outputDataset.getFullName()).getSmartName(recipe.getProjectKey()), outputTmpDir.getAbsolutePath());
                    }

                    @Override
                    public SparkOverrideConfig getRecipeOverrideConf() {
                        return ClassicalPredictionScoringRecipeRunner.this.desc.sparkParams.sparkConf;
                    }

                    @Override
                    public Map<String, String> getContextOverrideConf() {
                        return CollectionUtils.appendableSSMap().put("spark.dku.ml.preparedDF.storageLevel", ClassicalPredictionScoringRecipeRunner.this.desc.sparkParams.sparkPreparedDFStorageLevel).put("spark.dku.ml.repartitionNonHDFS", String.valueOf(ClassicalPredictionScoringRecipeRunner.this.desc.sparkParams.sparkRepartitionNonHDFS)).put("spark.dku.ml.useGlobalMetastore", Boolean.toString(ClassicalPredictionScoringRecipeRunner.this.desc.sparkParams.sparkUseGlobalMetastore)).put("spark.dku.ml.hiveDb", StringUtils.defaultIfBlank((String)hiveDb, (String)"")).get();
                    }

                    @Override
                    public List<File> getExtraRecursiveFolders() {
                        return Lists.newArrayList((Object[])new File[]{outputTmpDir, activeModelFolder});
                    }
                }, null);
            }

            @Override
            public void init() throws Exception {
            }
        };
    }

    private InitializableAbortableRecipeRunner createRunnerSparkJavaBased(final SerializedShakerScript script, final Dataset inputDataset, final List<Partition> inputPartitions, final Dataset outputDataset, final Partition outputPartition, final File activeModelFolder, final Schema preparationOSchemaToUse, final File outputTmpDir, final FullModelId fmi, final MLFlowUtils.ModelPartitionMode modelPartitionMode) throws Exception {
        return new AbstractSparkBasedRecipeRunner(this.activity){

            @Override
            public void run() throws Exception {
                final SerializedShakerScript expandedScript = script.expandedDeepCopy(ClassicalPredictionScoringRecipeRunner.this.variablesService.getForProject(this.projectKey));
                ClassicalPredictionScoringRecipeRunner.this.gatherer.gatherAndCompute(ClassicalPredictionScoringRecipeRunner.this.authCtx, this.projectKey, expandedScript.steps);
                final InputDatasetsReadParams readParams = new InputDatasetsReadParams();
                InputDatasetsReadParams.InputDatasetReadParams inputReadParams = new InputDatasetsReadParams.InputDatasetReadParams();
                inputReadParams.repartition = ClassicalPredictionScoringRecipeRunner.this.desc.sparkParams.sparkRepartitionNonHDFS;
                readParams.map.put(DatasetLocUtils.resolveFull(inputDataset.getFullName()).getSmartName(this.recipe.getProjectKey()), inputReadParams);
                final FlowDatasetRef inputRef = SparkRecipeUtils.getInputFlowDatasetRef(inputDataset, readParams, false, this.recipe, (List<Partition>)inputPartitions);
                final FlowDatasetRef outputRef = SparkRecipeUtils.getOutputFlowDatasetRef(outputDataset, this.projectKey, outputPartition);
                JSON.prettyToFile((Object)expandedScript, (File)new File(outputTmpDir, "script.json"));
                JSON.prettyToFile(ClassicalPredictionScoringRecipeRunner.this.gatherer.getResourceMapping(), (File)new File(outputTmpDir, "resource_mapping.json"));
                FilesystemACLUtils.grantFSReadACLs(this.authCtxService.getAuthCtx(), fmi.getProjectKey(), fmi.getFolderEnsuringSecurity());
                final String hiveDb = SparkRecipeUtils.getHiveMetastoreDatabase(this.activity, this.datasetsDAO);
                this.runSpark("prediction", ClassicalPredictionScoringRecipeRunner.this.desc.sparkParams.sparkExecutionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

                    @Override
                    public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                        PredictionScoringJobDef def = new PredictionScoringJobDef();
                        def.input = inputRef;
                        def.output = outputRef;
                        def.projectKey = recipe.getProjectKey();
                        def.activeModelFolder = activeModelFolder.getAbsolutePath();
                        def.modelPartitionMode = modelPartitionMode;
                        def.fmi = fmi;
                        def.readParams = readParams;
                        def.script = expandedScript;
                        def.prepOutSchema = preparationOSchemaToUse;
                        def.resourceMapping = ClassicalPredictionScoringRecipeRunner.this.gatherer.getResourceMapping();
                        def.desc = ClassicalPredictionScoringRecipeRunner.this.desc;
                        File defFile = new File(outputTmpDir, "desc.json");
                        JSON.prettyToFile((Object)def, (File)defFile);
                        T job = helper.makeClassJobWithNonSecretGlobalFiles("DSS  (predict): " + activity.id(), effectiveConf, ClassicalPredictionScoringRecipeRunner.this.gatherer.getResourceFiles(), ClassicalPredictionScoringRecipeRunner.this.desc.backendType == MLTask.BackendType.H2O, "com.dataiku.dip.spark.JavaBasedScoringJob", defFile.getAbsolutePath());
                        ((SparkJob)job).secretDriverFiles.add(defFile.getAbsolutePath());
                        return job;
                    }

                    @Override
                    public SparkOverrideConfig getRecipeOverrideConf() {
                        return ClassicalPredictionScoringRecipeRunner.this.desc.sparkParams.sparkConf;
                    }

                    @Override
                    public Map<String, String> getContextOverrideConf() {
                        return CollectionUtils.appendableSSMap().put("spark.dku.ml.preparedDF.storageLevel", ClassicalPredictionScoringRecipeRunner.this.desc.sparkParams.sparkPreparedDFStorageLevel).put("spark.dku.ml.repartitionNonHDFS", String.valueOf(ClassicalPredictionScoringRecipeRunner.this.desc.sparkParams.sparkRepartitionNonHDFS)).put("spark.dku.ml.useGlobalMetastore", Boolean.toString(ClassicalPredictionScoringRecipeRunner.this.desc.sparkParams.sparkUseGlobalMetastore)).put("spark.dku.ml.hiveDb", StringUtils.defaultIfBlank((String)hiveDb, (String)"")).get();
                    }

                    @Override
                    public List<File> getExtraRecursiveFolders() {
                        return Lists.newArrayList((Object[])new File[]{activeModelFolder});
                    }
                }, null);
            }

            @Override
            public void init() throws Exception {
            }
        };
    }

    private PyPredictionScoringRecipeSubrunner.Scoring createPythonRunner(SavedModel sm, SerializedShakerScript script, Dataset inputDataset, @Nullable String managedFolderSmartId, Dataset outputDataset, File activeModelFolder, AutoDelete outputTmpDir, RemoteRunsRegistry.ExecutionType executionType, String cmd, FullModelId fmi) throws IOException {
        JSON.prettyToFile((Object)script, (File)new File((File)outputTmpDir, "script.json"));
        String inputDatasetSmartName = AnyLoc.resolveFull(inputDataset.getFullName()).getSmartName(this.recipe.getProjectKey());
        String outputDatasetSmartName = AnyLoc.resolveFull(outputDataset.getFullName()).getSmartName(this.recipe.getProjectKey());
        JsonObject containerPayload = new JsonObject();
        containerPayload.addProperty("inputDatasetSmartName", inputDatasetSmartName);
        containerPayload.addProperty("managedFolderSmartId", managedFolderSmartId);
        containerPayload.addProperty("outputDatasetSmartName", outputDatasetSmartName);
        containerPayload.addProperty("inputModel", fmi.toString());
        String codeEnvName = fmi.getResolvedCoreParams().executionParams.envName;
        return new PyPredictionScoringRecipeSubrunner.Scoring(this.activity, fmi, activeModelFolder, this.authCtx, codeEnvName, this.desc, executionType, outputTmpDir, containerPayload, cmd, activeModelFolder.getAbsolutePath(), inputDatasetSmartName, StringUtils.defaultIfBlank((String)managedFolderSmartId, (String)""), outputDatasetSmartName, new File((File)outputTmpDir, "desc.json").getAbsolutePath(), new File((File)outputTmpDir, "script.json").getAbsolutePath(), new File((File)outputTmpDir, "preparation_output_schema.json").getAbsolutePath(), new File((File)outputTmpDir, "conditional_outputs.json").getAbsolutePath(), fmi.toString());
    }

    private InitializableAbortableRecipeRunner createMLflowPyfuncRunner(SavedModel sm, final MLFlowModelVersionInfo mmvi, final File activeModelFolder, final Dataset inputDataset, final Dataset outputDataset, final AutoDelete outputTmpDir, final TabularPredictionScoringRecipePayloadParams desc, final FullModelId fmi, final String proxy) throws Exception {
        logger.info((Object)"Running with MLflow Pyfunc backend");
        return new AbstractPythonRecipeRunner(this.activity){

            @Override
            public void run() throws Exception {
                String forcedClassifierThreshold;
                String envName = mmvi.pythonCodeEnvName;
                logger.info((Object)("Run mlFlow scoring in code env " + StringUtils.defaultIfBlank((String)envName, (String)"built-in")));
                File additionalLogsDir = FlowJobUtils.getJobMadeDir("scoring-recipe", "additional-logs");
                File mainLogFile = FlowJobUtils.getJobTouchedFile("scoring-recipe", "python.log");
                FilesystemACLUtils.grantFSReadACLs(this.authCtxService.getAuthCtx(), fmi.getProjectKey(), fmi.getFolderEnsuringSecurity());
                String inputDatasetSmartName = AnyLoc.resolveFull(inputDataset.getFullName()).getSmartName(this.recipe.getProjectKey());
                String outputDatasetSmartName = AnyLoc.resolveFull(outputDataset.getFullName()).getSmartName(this.recipe.getProjectKey());
                ContainerExecSelection containerSelection = this.recipe.getModel().getParamsAs(ContainerRecipeParams.class).getContainerSelection();
                ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().selectForML_autoTXN(ClassicalPredictionScoringRecipeRunner.this.authCtx, this.recipe.getProjectKey(), containerSelection, desc.backendType);
                String realOutputStyle = desc.mlFlowOutputStyle == null ? "PARSED" : desc.mlFlowOutputStyle.toString();
                String string = forcedClassifierThreshold = desc.overrideModelSpecifiedThreshold ? Double.toString(desc.forcedClassifierThreshold) : "";
                if (containerConfig == null) {
                    this.executeModule(envName, (File)outputTmpDir, "dataiku.external_ml.mlflow.pyfunc_scoring_recipe", activeModelFolder.getAbsolutePath(), inputDatasetSmartName, outputDatasetSmartName, realOutputStyle, forcedClassifierThreshold, new File((File)outputTmpDir, "desc.json").getAbsolutePath(), desc.outputModelMetadata ? fmi.toString() : "", proxy);
                } else {
                    CodeEnvModel.UsedCodeEnvRef codeEnvRef = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName);
                    List<String> readablePaths = Collections.singletonList(activeModelFolder.getAbsolutePath());
                    JsonObject payload = new JsonObject();
                    payload.addProperty("inputDatasetSmartName", inputDatasetSmartName);
                    payload.addProperty("outputDatasetSmartName", outputDatasetSmartName);
                    payload.addProperty("outputStyle", realOutputStyle);
                    payload.addProperty("forcedClassifierThreshold", forcedClassifierThreshold);
                    payload.addProperty("inputModel", fmi.toString());
                    switch (containerConfig.type) {
                        case DOCKER: {
                            this.executeDockerCodeRecipe(codeEnvRef, containerConfig, activeModelFolder, mainLogFile, outputTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_SCORE_MLFLOW, payload.toString(), Collections.emptyMap(), readablePaths);
                            break;
                        }
                        case KUBERNETES: {
                            this.executeKubernetesCodeRecipe(codeEnvRef, containerConfig, activeModelFolder, mainLogFile, additionalLogsDir, outputTmpDir, RemoteRunsRegistry.ExecutionType.RECIPE_PREDICTION_SCORE_MLFLOW, payload.toString(), Collections.emptyMap(), readablePaths, new KubernetesExecUtils.KubernetesFailureCodeProvider(){

                                @Override
                                public InfoMessage.MessageCode codeForOOMKilled() {
                                    return RecipeCodes.ERR_RECIPE_ML_SCORING_K8S_OOM;
                                }
                            });
                        }
                    }
                }
            }

            @Override
            public void init() throws Exception {
            }
        };
    }

    private void scoreDatasetStreaming(JobActivity activity, Dataset inputDS, List<Partition> inputPartitions, Dataset outputDS, Partition outputPartition, SerializedShakerScript script, ScoringOutput scorer) throws Exception {
        Output.WriteMode writeMode;
        List<FlowDataset> inputFDS = activity.getSubgraph().getSourceDatasets();
        if (inputFDS.size() == 0) {
            throw ErrorContext.iae((String)"Missing input dataset in scoring recipe");
        }
        try (DatasetHandler outputDatasetHandler = DatasetHandlerFactory.build(this.authCtx, outputDS);){
            writeMode = this.recipe.getModel().getSingleOutput("main").getWriteMode();
            if (writeMode == Output.WriteMode.OVERWRITE && !outputDatasetHandler.outputHandlesClear()) {
                if (outputDatasetHandler.getMeta().isFSLike()) {
                    outputDatasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{outputPartition}));
                }
                writeMode = Output.WriteMode.APPEND;
            }
        }
        StreamColumnFactory scf = scorer.scf;
        StreamRowFactory srf = new StreamRowFactory();
        ToDatasetStreamer streamer = ToDatasetStreamer.newWithAutoBucketing(this.authCtx, outputDS, outputPartition, (ColumnFactory)scf, activity.warnContext, writeMode);
        ProcessorOutput out = streamer.getAsOutput();
        scorer.setStreamOutput(out);
        SerializedShakerScript expandedScript = script.expandedDeepCopy(this.variablesService.getForProject(this.recipe.getProjectKey()));
        StreamPipelineFactory.StreamPipeline streamPipeline = StreamPipelineFactory.build(expandedScript.steps, BaseProcessorsFactory.PipelineContext.sharedPipelineContext(), true);
        StreamedAdditionalInputAccessor additionalInputsAccessor = new StreamedAdditionalInputAccessor(this.authCtx, this.recipe.getProjectKey(), this.datasetsDAO);
        List<SingleCopyAdditionalInputsLoader> additionalInputLoaders = AdditionalInputsHelper.getLoadersForAllProcessors(additionalInputsAccessor, expandedScript.steps, null);
        logger.info((Object)"Collecting script resources");
        for (Object o : streamPipeline.allProcessors) {
            Object rproc;
            if (o instanceof ProcessorWithResourceFiles) {
                rproc = (ProcessorWithResourceFiles)o;
                rproc.setRequiredFiles(rproc.gatherRequirements());
            }
            if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithResourceFiles) {
                rproc = (ProcessorWithResourceFiles)((SRPAdapter)o).getProcessor();
                rproc.setRequiredFiles(rproc.gatherRequirements());
            }
            if (o instanceof ProcessorWithResolvedParams) {
                rproc = (ProcessorWithResolvedParams)o;
                rproc.resolve(this.authCtx, this.recipe.getProjectKey());
            }
            if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithResolvedParams) {
                rproc = (ProcessorWithResolvedParams)((SRPAdapter)o).getProcessor();
                rproc.resolve(this.authCtx, this.recipe.getProjectKey());
            }
            if (o instanceof ProcessorWithSubProcess) {
                rproc = (ProcessorWithSubProcess)o;
                rproc.spawn(this.authCtx, inputDS.getProjectKey(), true, null);
            }
            if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithSubProcess) {
                rproc = (ProcessorWithSubProcess)((SRPAdapter)o).getProcessor();
                rproc.spawn(this.authCtx, inputDS.getProjectKey(), true, null);
            }
            if (o instanceof SingleInputSingleOutputRowProcessor) {
                ((SingleInputSingleOutputRowProcessor)o).setFactories((ColumnFactory)scf, (RowFactory)srf);
                ((SingleInputSingleOutputRowProcessor)o).init();
                continue;
            }
            if (!(o instanceof ProcessorWithFactories)) continue;
            ((ProcessorWithFactories)o).setFactories((ColumnFactory)scf, (RowFactory)srf);
        }
        AdditionalInputsHelper.setAdditionalInputsOnProcessors(additionalInputsAccessor, additionalInputLoaders, streamPipeline.allProcessors);
        Object last = Iterables.getLast(streamPipeline.allProcessors);
        if (!(last instanceof SingleOutputRowProcessor)) {
            throw ErrorContext.iae((String)"Could not plug output, no end of pipe");
        }
        ((SingleOutputRowProcessor)last).setProcessorOutput((ProcessorOutput)scorer);
        Object first = streamPipeline.allProcessors.get(0);
        if (!(first instanceof SingleInputRowProcessor)) {
            throw ErrorContext.iae((String)"Could not plug input");
        }
        ProcessorOutputToSIP connector = new ProcessorOutputToSIP((SingleInputRowProcessor)first);
        logger.info((Object)"Scoring the streamed dataset");
        StreamableDatasetSelection selection = StreamableDatasetSelection.full();
        selection.withSelectedPartitions(inputPartitions);
        UniversalSingleThreadPusher.push(this.authCtx, inputDS, selection, (ProcessorOutput)connector, (ColumnFactory)scf, (RowFactory)srf);
        scorer.lastRowEmitted();
    }

    private static class RegressionScoringOutput
    extends ScoringOutput<Double, RegressionResult> {
        private RegressionScoringOutput(ResolvedPredictionPreprocessingParams rppp, MLTask.BackendType backendType, Schema preparationOutputSchema, RegressionPipeline pipe, FullModelId modelMetadataFMI) throws IOException {
            super(rppp, backendType, preparationOutputSchema, pipe, modelMetadataFMI);
            this.registerComputedColumn("prediction_interval_lower");
            this.registerComputedColumn("prediction_interval_upper");
        }
    }

    private static class BinaryProbabilisticClassificationScoringOutput
    extends MulticlassProbabilisticClassificationScoringOutput {
        final List<ConditionalOutput> conditionalOutputs;
        final List<Column> conditionalOutputOutCols;
        final List<Column> conditionalOutputInCols;

        private BinaryProbabilisticClassificationScoringOutput(ResolvedPredictionPreprocessingParams rppp, MLTask.BackendType backendType, Schema preparationOutputSchema, BinaryProbabilisticPipeline pipe, List<ConditionalOutput> conditionalOutputs, boolean withProbaPercentiles, FullModelId modelMetadataFMI) throws IOException {
            super(rppp, backendType, preparationOutputSchema, (ProbabilisticClassificationPipeline)pipe, modelMetadataFMI);
            assert (this.classes.length == 2);
            if (withProbaPercentiles) {
                this.registerComputedColumn("proba_percentile");
            }
            if (conditionalOutputs != null && !conditionalOutputs.isEmpty()) {
                this.conditionalOutputs = conditionalOutputs;
                this.conditionalOutputInCols = new ArrayList<Column>(conditionalOutputs.size());
                this.conditionalOutputOutCols = new ArrayList<Column>(conditionalOutputs.size());
                for (ConditionalOutput o : conditionalOutputs) {
                    this.conditionalOutputInCols.add((Column)this.scf.column(o.input));
                    this.conditionalOutputOutCols.add((Column)this.scf.column(o.name));
                }
            } else {
                this.conditionalOutputs = null;
                this.conditionalOutputInCols = null;
                this.conditionalOutputOutCols = null;
            }
        }

        @Override
        public void processSuccess(RawObservation observation, ClassificationResult result, Row row) {
            super.processSuccess(observation, result, row);
            String percentileColumnName = "proba_percentile";
            if (this.conditionalOutputs != null) {
                for (int i = 0; i < this.conditionalOutputs.size(); ++i) {
                    ConditionalOutput out = this.conditionalOutputs.get(i);
                    double input = percentileColumnName.equals(out.input) ? row.getAsDoubleOrNaN((Column)this.scf.column(percentileColumnName)) : row.getAsDoubleOrNaN(this.conditionalOutputInCols.get(i));
                    row.put(this.conditionalOutputOutCols.get(i), out.apply(input));
                }
            }
        }
    }

    private static class MulticlassProbabilisticClassificationScoringOutput
    extends ScoringOutput<String, ClassificationResult> {
        protected final String[] classes;

        private MulticlassProbabilisticClassificationScoringOutput(ResolvedPredictionPreprocessingParams rppp, MLTask.BackendType backendType, Schema preparationOutputSchema, ProbabilisticClassificationPipeline pipe, FullModelId modelMetadataFMI) throws IOException {
            super(rppp, backendType, preparationOutputSchema, pipe, modelMetadataFMI);
            this.classes = pipe.getClasses();
            for (int i = 0; i < this.classes.length; ++i) {
                this.registerComputedColumn(AbstractProbabilisticClassificationPipeline.ProbabilityColumnComputer.getColumnName((String[])this.classes, (int)i));
            }
        }
    }

    private static class NonProbabilisticClassificationScoringOutput
    extends ScoringOutput<String, NonProbabilisticClassificationResult> {
        private NonProbabilisticClassificationScoringOutput(ResolvedPredictionPreprocessingParams rppp, MLTask.BackendType backendType, Schema preparationOutputSchema, NonProbabilisticClassificationPipeline pipe, FullModelId modelMetadataFMI) throws IOException {
            super(rppp, backendType, preparationOutputSchema, pipe, modelMetadataFMI);
        }
    }

    public static abstract class ScoringOutput<PT, Y extends Result<PT>>
    extends FilteringProcessorOutput {
        private final Pipeline<PT, Y> pipe;
        protected final Column[] cols;
        protected final StreamColumnFactory scf;
        private final Coercion coercion;
        private final Normalization normalization;
        protected final boolean outputModelMetadata;
        protected final List<Column> modelMetadataColumns;
        protected final List<String> modelMetadata;
        protected final Map<String, List<String>> partitionedModelMetadata;
        protected final List<Column> partitionColumns;
        protected final List<String> computedColumns = new ArrayList<String>();

        private ScoringOutput(ResolvedPredictionPreprocessingParams rppp, MLTask.BackendType backendType, Schema preparationOutputSchema, Pipeline<PT, Y> pipe, FullModelId fmi) throws IOException {
            int i;
            this.pipe = pipe;
            this.scf = new StreamColumnFactory();
            this.coercion = ScoringOutput.buildCoercion(rppp);
            this.normalization = ScoringOutput.buildNormalization(rppp, preparationOutputSchema, backendType.isSparkBased());
            List<FeaturePreprocessingParams> features = ScoringOutput.getInputFeatures(rppp);
            String[] partitioning = pipe instanceof PartitionedPipeline ? ((PartitionedPipeline)pipe).getPartitioning() : new String[]{};
            int nbFeatures = features.size();
            this.cols = new Column[nbFeatures + partitioning.length];
            for (i = 0; i < nbFeatures; ++i) {
                FeaturePreprocessingParams f = features.get(i);
                this.cols[i] = this.scf.column(f.name);
            }
            for (i = 0; i < partitioning.length; ++i) {
                this.cols[nbFeatures + i] = this.scf.column(partitioning[i]);
            }
            boolean bl = this.outputModelMetadata = fmi != null;
            if (!this.outputModelMetadata) {
                this.modelMetadataColumns = null;
                this.modelMetadata = null;
                this.partitionedModelMetadata = null;
                this.partitionColumns = null;
            } else {
                this.modelMetadataColumns = ScoringRecipeUtils.ModelMetadataUtils.getModelMetadataColumns(this.scf);
                if (partitioning.length > 0) {
                    this.modelMetadata = null;
                    this.partitionedModelMetadata = ScoringRecipeUtils.ModelMetadataUtils.getPartitionedModelMetadata(fmi);
                    this.partitionColumns = new ArrayList<Column>();
                    for (String partitionCol : partitioning) {
                        this.partitionColumns.add((Column)this.scf.column(partitionCol));
                    }
                } else {
                    this.partitionedModelMetadata = null;
                    this.partitionColumns = null;
                    this.modelMetadata = ScoringRecipeUtils.ModelMetadataUtils.getModelMetadata(fmi);
                }
            }
            this.registerComputedColumn(AbstractPipeline.PredictionComputer.COLUMN_NAME);
            if (pipe.hasOverrides()) {
                this.registerComputedColumn(AbstractPipeline.OverrideColumnComputer.COLUMN_NAME);
            }
        }

        public static Coercion buildCoercion(ResolvedPredictionPreprocessingParams rppp) {
            HashMap<String, Boolean> mapping = new HashMap<String, Boolean>();
            for (Map.Entry e : rppp.per_feature.entrySet()) {
                if (((FeaturePreprocessingParams)e.getValue()).role != FeaturePreprocessingParams.Role.INPUT) continue;
                mapping.put((String)e.getKey(), ((FeaturePreprocessingParams)e.getValue()).type.equals((Object)FeaturePreprocessingParams.FeatureType.NUMERIC));
            }
            return new Coercion(mapping);
        }

        public static Normalization buildNormalization(ResolvedPredictionPreprocessingParams rppp, Schema schema, boolean isMllib) {
            HashMap<String, Normalization.Action> actions = new HashMap<String, Normalization.Action>();
            block3: for (Map.Entry e : rppp.per_feature.entrySet()) {
                SchemaColumn column = schema.getColumn((String)e.getKey());
                if (column == null) {
                    switch (((FeaturePreprocessingParams)e.getValue()).role) {
                        case TARGET: 
                        case REJECT: 
                        case WEIGHT: {
                            continue block3;
                        }
                    }
                    throw new IllegalArgumentException("Missing input column for feature " + (String)e.getKey());
                }
                if (((FeaturePreprocessingParams)e.getValue()).role == FeaturePreprocessingParams.Role.TARGET) continue;
                if (((FeaturePreprocessingParams)e.getValue()).type == FeaturePreprocessingParams.FeatureType.NUMERIC && column.getType().isTemporal()) {
                    actions.put((String)e.getKey(), isMllib ? Normalization.Action.TO_MLLIB_EPOCH : Normalization.Action.TO_EPOCH);
                    continue;
                }
                if (((FeaturePreprocessingParams)e.getValue()).type != FeaturePreprocessingParams.FeatureType.CATEGORY || !column.getType().isTemporal()) continue;
                actions.put((String)e.getKey(), isMllib ? Normalization.Action.TO_MLLIB_STRING : Normalization.Action.TO_STRING);
            }
            return new Normalization(actions);
        }

        private static List<FeaturePreprocessingParams> getInputFeatures(ResolvedPredictionPreprocessingParams rppp) {
            ArrayList<FeaturePreprocessingParams> features = new ArrayList<FeaturePreprocessingParams>();
            for (Map.Entry e : rppp.per_feature.entrySet()) {
                FeaturePreprocessingParams p = (FeaturePreprocessingParams)e.getValue();
                if (p.role != FeaturePreprocessingParams.Role.INPUT) continue;
                p.name = (String)e.getKey();
                features.add(p);
            }
            return features;
        }

        public void setStreamOutput(ProcessorOutput downstream) {
            this.setDownstream(downstream);
        }

        public void processRow(Row row) {
            RawObservation observation = this.buildObservation(row);
            Try res = this.pipe.getPredictionResults(observation);
            if (res.isSuccess()) {
                Result result = (Result)res.get();
                this.processSuccess(observation, result, row);
            } else {
                logger.warn((Object)("Failed to process row : " + res.getMessage()));
            }
        }

        protected void processSuccess(RawObservation observation, Y result, Row row) {
            this.pipe.getComputedColumnsValues(observation, result, this.computedColumns).forEach(nameValuePair -> ((Optional)nameValuePair.getValue()).ifPresent(output -> row.put((Column)this.scf.column((String)nameValuePair.getKey()), output.toString())));
        }

        protected RawObservation buildObservation(Row row) {
            ObservationBuilder.NormalizingCoercingBuilder b = new ObservationBuilder.NormalizingCoercingBuilder(this.coercion, this.normalization);
            for (int i = 0; i < this.cols.length; ++i) {
                String raw = row.get(this.cols[i]);
                String col = this.cols[i].getName();
                b.with(col, raw);
            }
            return b.build();
        }

        public void emitRow(Row row) throws Exception {
            this.processRow(row);
            if (this.outputModelMetadata) {
                this.addModelMetadataToRow(row);
            }
            this.downstream.emitRow(row);
        }

        private void addModelMetadataToRow(Row row) {
            block4: {
                block3: {
                    if (this.modelMetadata == null) break block3;
                    for (int i = 0; i < this.modelMetadataColumns.size(); ++i) {
                        row.put(this.modelMetadataColumns.get(i), this.modelMetadata.get(i));
                    }
                    break block4;
                }
                StringBuilder partitionNameSB = new StringBuilder();
                for (Column partitionCol : this.partitionColumns) {
                    partitionNameSB.append(row.get(partitionCol)).append('|');
                }
                String partitionName = partitionNameSB.substring(0, partitionNameSB.length() - 1);
                if (!this.partitionedModelMetadata.containsKey(partitionName)) break block4;
                for (int i = 0; i < this.modelMetadataColumns.size(); ++i) {
                    row.put(this.modelMetadataColumns.get(i), this.partitionedModelMetadata.get(partitionName).get(i));
                }
            }
        }

        void registerComputedColumn(String columnName) {
            this.scf.column(columnName);
            this.computedColumns.add(columnName);
        }
    }
}

