/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesBasicService;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class EvaluationRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private PredictionRecipesBasicService service;
    @Autowired
    private TransactionService transactionService;
    private EvaluationRecipePayloadParams params;
    static DKULogger logger = DKULogger.getLogger((String)"dku.analysis.flow");

    public EvaluationRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.params = (EvaluationRecipePayloadParams)JSON.parse((String)payload, EvaluationRecipePayloadParams.class);
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        if (role.equals("main")) {
            try (Transaction t = this.transactionService.beginRead();){
                this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            }
            Schema mainSchema = this.getMainSchema_NT();
            return this.recipe.getOutputsForRole("main").isEmpty() ? Collections.emptyList() : Lists.newArrayList((Object[])new Schema[]{mainSchema});
        }
        if ("metrics".equals(role)) {
            return this.recipe.getOutputsForRole("metrics").isEmpty() ? Lists.newArrayList() : Lists.newArrayList((Object[])new Schema[]{this.getMetricsSchema()});
        }
        return Lists.newArrayList();
    }

    private Schema getMainSchema_NT() throws Exception {
        Schema schema = this.service.getEvaluationRecipeOutputSchema_NT(this.activity, this.params, this.authCtx);
        if (!this.params.dontComputePerformance && this.params.outputs.contains("error")) {
            schema.addColumn("error", Type.DOUBLE);
        }
        if (!this.params.dontComputePerformance && this.params.outputs.contains("error_decile")) {
            schema.addColumn("error_decile", Type.SMALLINT);
        }
        if (!this.params.dontComputePerformance && this.params.outputs.contains("abs_error_decile")) {
            schema.addColumn("abs_error_decile", Type.SMALLINT);
        }
        if (!this.params.dontComputePerformance && this.params.outputs.contains("prediction_correct")) {
            schema.addColumn("prediction_correct", Type.BOOLEAN);
        }
        if (!this.params.dontComputePerformance && this.params.outputs.contains("relative_error")) {
            schema.addColumn("relative_error", Type.DOUBLE);
        }
        return schema;
    }

    private Schema getMetricsSchema() throws Exception {
        return this.service.getEvaluationRecipeMetricsSchema_NT(this.activity, this.params, this.authCtx);
    }
}

