/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.guess;

import com.dataiku.dip.analysis.ml.prediction.guess.ClassicalPredictionGuesser;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.exceptions.DSSIllegalArgumentException;

public class DecisionTreeGuesser
extends ClassicalPredictionGuesser {
    public DecisionTreeGuesser(PredictionMLTask.ClassicalPredictionMLTask task, MemTable table) {
        super(task, table);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PredictionModelingParams initAlgorithmsParams(PredictionMLTask.ClassicalPredictionMLTask task, boolean keepExistingParams) {
        if (!keepExistingParams) return new PredictionModelingParams(task.predictionType, task.modeling);
        PredictionModelingParams params = task.modeling;
        if (task.backendType == MLTask.BackendType.PY_MEMORY) {
            switch (task.predictionType) {
                case REGRESSION: {
                    params.decision_tree_regression = new PredictionModelingParams.DecisionTreeHyperparametersSpace();
                    return params;
                }
                case BINARY_CLASSIFICATION: 
                case MULTICLASS: {
                    params.decision_tree_classification = new PredictionModelingParams.DecisionTreeHyperparametersSpace();
                    return params;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported prediction type:" + String.valueOf((Object)task.predictionType));
                }
            }
        }
        if (task.backendType != MLTask.BackendType.MLLIB) throw new DSSIllegalArgumentException("Backend " + String.valueOf((Object)task.backendType) + " is not supported for Decision Tree guessing.");
        params.mllib_dt = new PredictionModelingParams.MLLibDecisionTreeGridParams();
        return params;
    }

    @Override
    public PredictionModelingParams guessAlgorithms(MemTable table, PredictionMLTask.ClassicalPredictionMLTask task, boolean keepExistingParams) {
        PredictionModelingParams params;
        block7: {
            block6: {
                params = this.initAlgorithmsParams(task, keepExistingParams);
                if (task.backendType != MLTask.BackendType.PY_MEMORY) break block6;
                switch (task.predictionType) {
                    case REGRESSION: {
                        params.decision_tree_regression.enabled = true;
                        break block7;
                    }
                    case BINARY_CLASSIFICATION: 
                    case MULTICLASS: {
                        params.decision_tree_classification.enabled = true;
                        break block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported prediction type:" + String.valueOf((Object)task.predictionType));
                    }
                }
            }
            if (task.backendType == MLTask.BackendType.MLLIB) {
                params.mllib_dt.enabled = true;
            } else {
                throw new DSSIllegalArgumentException("Backend " + String.valueOf((Object)task.backendType) + " is not supported for Decision Tree guessing.");
            }
        }
        return params;
    }
}

