/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.databricks;

import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.DatabricksDeploymentInfo;
import com.dataiku.dip.apideployer.deployments.DatabricksDeploymentConfigManager;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksRegisteredModelVersion;
import com.dataiku.dip.externalinfras.databricks.datamodel.actual.DatabricksEndpoint;
import com.dataiku.dip.externalinfras.databricks.datamodel.actual.DatabricksEndpointConfig;
import com.dataiku.dip.externalinfras.databricks.datamodel.actual.DatabricksModelVersion;
import com.dataiku.dip.variables.VariablesContext;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DatabricksDataModelBuilder {
    private DatabricksDataModelBuilder() {
    }

    @Nonnull
    public static DatabricksModelVersion buildModelVersion(@Nonnull DatabricksRegisteredModelVersion modelVersion) {
        return new DatabricksModelVersion(modelVersion.name, modelVersion.version);
    }

    @Nullable
    public static DatabricksModelVersion buildModelVersion(@Nonnull DatabricksDeploymentInfo deploymentInfo) {
        String modelName = deploymentInfo.dbxModelName;
        String modelVersion = deploymentInfo.dbxModelVersion;
        if (StringUtils.isBlank((CharSequence)modelName) || StringUtils.isBlank((CharSequence)modelVersion)) {
            return null;
        }
        return new DatabricksModelVersion(modelName, modelVersion);
    }

    @Nonnull
    public static DatabricksEndpoint buildEndpoint(@Nonnull String endpointName, DatabricksAPIDeployment deployment, DatabricksAPIDeploymentInfra infra, VariablesContext vc) {
        DatabricksEndpointConfig config = DatabricksDataModelBuilder.buildEndpointConfig(deployment, infra, vc);
        return new DatabricksEndpoint(endpointName, config);
    }

    @Nullable
    public static DatabricksEndpoint buildKnownEndpoint(DatabricksAPIDeployment deployment, DatabricksAPIDeploymentInfra infra, VariablesContext vc, @Nonnull DatabricksDeploymentInfo deploymentInfo) {
        String endpointName = deploymentInfo.dbxEndpointName;
        if (StringUtils.isBlank((CharSequence)endpointName)) {
            return null;
        }
        return DatabricksDataModelBuilder.buildEndpoint(endpointName, deployment, infra, vc);
    }

    @Nonnull
    private static DatabricksEndpointConfig buildEndpointConfig(DatabricksAPIDeployment deployment, DatabricksAPIDeploymentInfra infra, VariablesContext vc) {
        DatabricksDeploymentConfigManager configManager = new DatabricksDeploymentConfigManager(deployment, infra, vc);
        DatabricksAPIDeploymentInfra.ServedEntitySettings servedEntitySettings = deployment.getServedEntitySettings(infra);
        Map<String, String> environmentVariables = configManager.getEnvironmentVariablesMap();
        Map<String, String> tags = configManager.prepareTags();
        return new DatabricksEndpointConfig(servedEntitySettings, environmentVariables, tags);
    }
}

