/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDockerDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.APIDeployerImageBuilderService;
import com.dataiku.dip.apideployer.deployments.AbstractAPIServiceDeploymentManager;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.filters.RoutingKeyFiltering;
import com.dataiku.dip.filters.TopicsFiltering;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.RegularPasswordEncryptionService;
import com.dataiku.dip.security.audit.model.EventServerTargetSettings;
import com.dataiku.dip.security.audit.model.FsLikeTargetSettings;
import com.dataiku.dip.security.audit.model.KafkaTargetSettings;
import com.dataiku.dip.security.audit.model.Log4JTargetSettings;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.lambda.APIServiceCodes;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAPIServiceDockerDeploymentManager
extends AbstractAPIServiceDeploymentManager<DockerBasedDeploymentReport> {
    @Autowired
    APIDeployerImageBuilderService apiDeployerImageBuilderService;
    @Autowired
    VariablesService variablesService;
    protected boolean rebuildCodeEnv;

    @Override
    protected abstract AbstractAPIServiceDockerDeployment getDeployment();

    @Override
    protected abstract AbstractAPIDockerDeploymentInfra getInfra();

    protected AbstractAPIServiceDockerDeploymentManager(AuthCtx authCtx, int connectTimeout, int socketTimeout) {
        super(authCtx, connectTimeout, socketTimeout);
    }

    protected void setRebuildCodeEnv(boolean rebuildCodeEnv) {
        this.rebuildCodeEnv = rebuildCodeEnv;
    }

    @Override
    protected void preDeploymentActions(@Nonnull DockerBasedDeploymentReport report, @Nonnull DKUtils.SmartLogTailBuilder logTailBuilder) {
    }

    @Override
    @Nonnull
    protected DockerBasedDeploymentReport initializeDeploymentReport() {
        return new DockerBasedDeploymentReport();
    }

    public void enrichLambdaServerConfig(RegularPasswordEncryptionService dockerImagePasswordEncryptionService, LambdaServerConfig lsc) throws CodedException {
        AbstractAPIDockerDeploymentInfra infra = this.getInfra();
        AbstractAPIServiceDockerDeployment deployment = this.getDeployment();
        AbstractAPIDockerDeploymentInfra.APINodeGraphiteConfig graphiteConfig = infra.graphiteConfig;
        if (graphiteConfig != null && StringUtils.isNotBlank((String)graphiteConfig.graphiteCarbonServerURL)) {
            lsc.graphiteCarbonServerURL = graphiteConfig.graphiteCarbonServerURL;
            lsc.graphiteCarbonPrefix = graphiteConfig.graphiteCarbonCommonPrefix + ".deployments." + deployment.id;
            lsc.graphiteCarbonIntervalMinutes = graphiteConfig.graphiteCarbonIntervalMinutes;
        }
        AbstractAPIDockerDeploymentInfra.DockerAPINodeLogging apiNodeLogging = deployment.getNodeLogging(infra);
        lsc.auditLog = (LambdaServerConfig.AuditLog)JSON.deepCopy((Object)apiNodeLogging.auditLog);
        if (infra.getInfraType() == AbstractDeploymentInfra.InfraType.K8S && DKUApp.isDataikuCloud() && lsc.auditLog.logQueries) {
            this.getLogger().info((Object)"Configuring logging of apinode-query and authfail audit events to log4j");
            Log4JTargetSettings l4jts = new Log4JTargetSettings();
            l4jts.routingKeysFiltering = RoutingKeyFiltering.ALL;
            l4jts.topicsFiltering = TopicsFiltering.SELECTED;
            l4jts.topics.add("apinode-query");
            l4jts.topics.add("authfail");
            lsc.auditLog.settings.targets.add(l4jts);
        }
        boolean hasAuditRoutingKey = StringUtils.isNotBlank(deployment.generationsMapping != null ? deployment.generationsMapping.auditRoutingKey : null);
        if (apiNodeLogging.automaticallyConfigureEventServerReporting && hasAuditRoutingKey) {
            this.getLogger().info((Object)"Setting up logging to DSS Event Server");
            EventServerTargetSettings ests = new EventServerTargetSettings();
            ests.routingKeysFiltering = RoutingKeyFiltering.ALL;
            ests.topicsFiltering = TopicsFiltering.SELECTED;
            ests.topics.add("apinode-query");
            ests.topics.add("authfail");
            AbstractAPIDeploymentInfra.EventServerRef ref = apiNodeLogging.getEventServer();
            ests.url = ref.getEventServerURL();
            ests.authKey = ((PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class)).decryptIfEncrypted(ref.getEventServerAuthKey());
            ests.trustAllSSLCertificates = apiNodeLogging.trustAllSSLCertificates;
            lsc.auditLog.settings.targets.add(ests);
        }
        if (apiNodeLogging.automaticallyConfigureKafkaReporting && hasAuditRoutingKey) {
            this.getLogger().info((Object)"Setting up logging to Kafka");
            KafkaTargetSettings kts = new KafkaTargetSettings();
            kts.routingKeysFiltering = RoutingKeyFiltering.ALL;
            kts.topicsFiltering = TopicsFiltering.SELECTED;
            kts.topics.add("apinode-query");
            kts.topics.add("authfail");
            kts.connection = apiNodeLogging.kafkaConnectionName;
            kts.topic = apiNodeLogging.kafkaTopic;
            lsc.auditLog.settings.targets.add(kts);
        }
        if (apiNodeLogging.automaticallyConfigureFsLikeReporting && hasAuditRoutingKey && FeatureFlags.isEnabled((String)"fsLikeApiNodeLogging")) {
            AbstractAPIDeploymentInfra.APINodeLogging.FsLikeSettings fsLikeSettings = apiNodeLogging.fsLikeSettings;
            this.getLogger().info((Object)"Setting up logging to filesystem-like connection");
            FsLikeTargetSettings fsts = new FsLikeTargetSettings();
            fsts.routingKeysFiltering = RoutingKeyFiltering.ALL;
            fsts.topicsFiltering = TopicsFiltering.SELECTED;
            fsts.topics.add("apinode-query");
            fsts.topics.add("authfail");
            fsts.fileLikeConnectionName = fsLikeSettings.connectionName;
            fsts.fileLikePathWithinConnection = fsLikeSettings.pathWithinConnection;
            fsts.bucket = fsLikeSettings.bucket;
            fsts.partitioningPeriod = fsLikeSettings.partitioningPeriod;
            fsts.flushEveryBytes = fsLikeSettings.flushEveryBytes;
            fsts.flushEveryS = fsLikeSettings.flushEveryS;
            fsts.folderByTopic = fsLikeSettings.folderByTopic;
            fsts.folderByRoutingKey = fsLikeSettings.folderByRoutingKey;
            this.checkIfFsLikeConnectionIsSet(fsts.fileLikeConnectionName);
            lsc.auditLog.settings.targets.add(fsts);
        }
        if (infra.activityMonitoringSettings instanceof ActivityMonitoringSettings.Push) {
            this.getLogger().info((Object)"Setting up sending activity metrics to DSS Activity Server");
            try {
                ActivityMonitoringSettings.PushExplicit pushSettings = ((ActivityMonitoringSettings.Push)infra.activityMonitoringSettings).toPushSettings();
                if (StringUtils.isBlank((String)pushSettings.activityServerAPIURL) || StringUtils.isBlank((String)pushSettings.apiKey)) {
                    this.getLogger().warn((Object)"Activity server Url or api key not set at the infra level. Disabling the sending of activity metrics for this deployment.");
                    lsc.activityMonitoringSettings = new ActivityMonitoringSettings.Disabled();
                } else {
                    ActivityMonitoringSettings.PushExplicit copiedPushSettings = (ActivityMonitoringSettings.PushExplicit)JSON.deepCopy((Object)pushSettings);
                    PasswordEncryptionService localPasswordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
                    copiedPushSettings.decryptFields(localPasswordEncryptionService);
                    copiedPushSettings.encryptFields((PasswordEncryptionService)dockerImagePasswordEncryptionService);
                    lsc.activityMonitoringSettings = copiedPushSettings;
                    this.getLogger().infoV("DSS Activity Server url set to %s", new Object[]{pushSettings.activityServerAPIURL});
                }
            }
            catch (IllegalConfigurationException ice) {
                this.getLogger().warnV("Sending of activity metrics not configured. Reason: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)ice)});
            }
        }
    }

    private void checkIfFsLikeConnectionIsSet(@Nullable String connection) throws CodedException {
        if (StringUtils.isEmpty((String)connection)) {
            throw new CodedException((InfoMessage.MessageCode)APIServiceCodes.ERR_INFRASTRUCTURE_INVALID_CONFIG, "Audit reporting using an object storage or a filesystem is active but the associated connection is missing.");
        }
        if (!this.getInfra().remappedConnections.containsKey(connection)) {
            throw new CodedException((InfoMessage.MessageCode)APIServiceCodes.ERR_INFRASTRUCTURE_INVALID_CONFIG, "Connection '" + connection + "' is missing from the infrastructure settings but required by audit reporting.");
        }
    }

    public static class DockerBasedDeploymentReport
    extends AbstractAPIServiceDeploymentManager.APIDeploymentReport {
        @Nullable
        public InfoMessage.InfoMessages syncReport;

        @Override
        public boolean preDeploymentActionsSucceeded() {
            return true;
        }

        @Override
        public void setActualDeploymentStepReport(@Nonnull InfoMessage.InfoMessages report) {
            this.syncReport = report;
            this.mergeFrom(report);
        }

        @Override
        public DockerBasedDeploymentReport copyHookStatusWithSensitiveDataAdded() {
            DockerBasedDeploymentReport copy = new DockerBasedDeploymentReport();
            copy.mergeFrom(this);
            copy.messages = DockerBasedDeploymentReport.copyWithAdminDetails(this.messages);
            copy.copyInterruptedAndHookStatus(this);
            copy.deploymentHookExecutionStatus.updateMessageWithSensitiveData();
            if (this.syncReport != null) {
                copy.syncReport = (InfoMessage.InfoMessages)JSON.deepCopy((Object)this.syncReport);
                copy.syncReport.messages = DockerBasedDeploymentReport.copyWithAdminDetails(this.syncReport.messages);
            }
            return copy;
        }

        @Override
        public DockerBasedDeploymentReport copyWithNonAdminDeploymentFailureMessage() {
            DockerBasedDeploymentReport copy = new DockerBasedDeploymentReport();
            copy.mergeFrom(this);
            copy.messages = DockerBasedDeploymentReport.copyWithoutAdminDetails(this.messages);
            copy.copyInterruptedAndHookStatus(this);
            if (this.syncReport != null) {
                copy.syncReport = (InfoMessage.InfoMessages)JSON.deepCopy((Object)this.syncReport);
                copy.syncReport.messages = DockerBasedDeploymentReport.copyWithoutAdminDetails(this.syncReport.messages);
            }
            return copy;
        }

        @Override
        public InfoMessage.Severity getMaxSeverity() {
            if (this.syncReport == null) {
                return InfoMessage.Severity.ERROR;
            }
            return this.maxSeverity;
        }
    }
}

