/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.monitoring;

import com.dataiku.dip.apideployer.monitoring.MetricType;
import com.dataiku.dip.apideployer.monitoring.MonitoringMetric;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.rrd4j.ConsolFun;

public class ActivityMetric
implements MonitoringMetric<Type> {
    @Nonnull
    private final Type type;
    private double value;

    public ActivityMetric(@Nonnull Type type, double value) {
        this.type = type;
        this.value = value;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    public static enum Type implements MetricType
    {
        ALL_REQUESTS_IN_COUNT_PER_S("allRequestsInCountPerSecond", ConsolFun.AVERAGE),
        ERROR_REQUESTS_IN_COUNT_PER_S("errorRequestsInCountPerSecond", ConsolFun.AVERAGE),
        AVG_PROCESSING_TIME_IN_MS_PER_REQUEST("processingTimeInMsPerRequest", ConsolFun.AVERAGE),
        P95_PROCESSING_TIME_IN_MS_PER_REQUEST("p95ProcessingTimeInMsPerRequest", ConsolFun.AVERAGE),
        TOTAL_PROCESSING_TIME_IN_MS("totalProcessingTimeInMs", ConsolFun.TOTAL),
        TOTAL_P95_PROCESSING_TIME_IN_MS("p95ProcessingTimeInMs", ConsolFun.TOTAL);

        private final String rrdFieldName;
        public final ConsolFun consolidationToUse;
        static final Map<String, Type> byRrdFieldName;
        public static final Set<Type> rrdMetrics;

        private Type(String rrdFieldName, ConsolFun aggregationToUse) {
            this.rrdFieldName = rrdFieldName;
            this.consolidationToUse = aggregationToUse;
        }

        @Override
        public String getRrdFieldName() {
            return this.rrdFieldName;
        }

        static {
            byRrdFieldName = new HashMap<String, Type>();
            for (Type mt : Type.values()) {
                byRrdFieldName.put(mt.rrdFieldName, mt);
            }
            rrdMetrics = ImmutableSet.of((Object)ALL_REQUESTS_IN_COUNT_PER_S, (Object)ERROR_REQUESTS_IN_COUNT_PER_S, (Object)TOTAL_PROCESSING_TIME_IN_MS, (Object)TOTAL_P95_PROCESSING_TIME_IN_MS);
        }
    }

    public static class TimeAndMetrics {
        public long timestampInSeconds;
        @Nonnull
        public Map<Type, ActivityMetric> activityMetricsByType;

        public TimeAndMetrics(long timestampInSeconds) {
            this.timestampInSeconds = timestampInSeconds;
            this.activityMetricsByType = new EnumMap<Type, ActivityMetric>(Type.class);
        }
    }

    public static class TimeAndMetricsByTime
    extends TreeMap<Long, TimeAndMetrics> {
    }

    public static class TimeAndMetricsForEndpoint {
        @Nonnull
        public String endpointId;
        @Nonnull
        public TimeAndMetricsByTime timeAndMetricsOrderedByTime;

        public TimeAndMetricsForEndpoint(@Nonnull String endpointId) {
            this.endpointId = endpointId;
            this.timeAndMetricsOrderedByTime = new TimeAndMetricsByTime();
        }
    }

    public static class TimeAndMetricsByEndpoint
    extends HashMap<String, TimeAndMetricsForEndpoint> {

        public static class None
        extends TimeAndMetricsByEndpoint {
        }
    }

    public static class TimeAndMetricsForDeployment {
        @Nonnull
        public String deploymentId;
        @Nonnull
        public Map<String, TimeAndMetricsForEndpoint> timeAndMetricsForEndpoint;

        public TimeAndMetricsForDeployment(@Nonnull String deploymentId) {
            this.deploymentId = deploymentId;
            this.timeAndMetricsForEndpoint = new HashMap<String, TimeAndMetricsForEndpoint>();
        }
    }

    public static class TimeAndMetricsByDeploymentAndEndpoint
    extends HashMap<String, TimeAndMetricsForDeployment> {

        public static class None
        extends TimeAndMetricsByDeploymentAndEndpoint {
        }
    }
}

