/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.dao.impl.FilesBasedUsersDAO;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class RemoveUserCommand
extends CLICommandWithInvalidateCommonFilesCache {
    @Override
    public String usageString() {
        return "remove-user LOGIN";
    }

    @Override
    public String description() {
        return "Remove a user from the DSS configuration";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "remove-user", true);
        if (cmdLine.getArgs().length < 2) {
            return this.usage(1, "Missing argument");
        }
        String login = cmdLine.getArgs()[1];
        CLISetup.doSpringUtilsAndCoreServicesSetupForTestsAndCLI();
        try (RWTransaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginWriteAsDSS();){
            FilesBasedUsersDAO ud = new FilesBasedUsersDAO();
            ud.forceDeleteUser(login);
            t.commit("CLI: Removed user " + login);
        }
        return 0;
    }
}

