/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class SparkOverrideMask {
    public boolean enabled;
    public boolean jdbc;
    public boolean configForJupyter;
    public boolean configForSEK;
    public boolean configForInteractive;
    public boolean interactiveExecutionEngine;
    public boolean engineCreationSettings;
    public boolean properties;
    public boolean environmentVariables;
    public boolean yarnCluster;

    public static SparkOverrideMask fromJsonObject(JsonObject settings) {
        SparkOverrideMask mask = new SparkOverrideMask();
        if (settings == null) {
            return mask;
        }
        mask.enabled = true;
        if (settings.has("interactiveExecutionEngine") && !settings.get("interactiveExecutionEngine").isJsonNull()) {
            mask.interactiveExecutionEngine = true;
        }
        if (settings.has("executionConfigs") && !settings.get("executionConfigs").isJsonNull()) {
            mask.properties = true;
        }
        if (settings.has("executionConfigsGenericOverrides") && !settings.get("executionConfigsGenericOverrides").isJsonNull()) {
            mask.properties = true;
        }
        if (settings.has("engineCreationSettings") && !settings.get("engineCreationSettings").isJsonNull()) {
            mask.engineCreationSettings = true;
        }
        if (settings.has("configForSEK") && !settings.get("configForSEK").isJsonNull()) {
            mask.configForSEK = true;
        }
        if (settings.has("configForJupyter") && !settings.get("configForJupyter").isJsonNull()) {
            mask.configForJupyter = true;
        }
        if (settings.has("configForInteractive") && !settings.get("configForInteractive").isJsonNull()) {
            mask.configForInteractive = true;
        }
        if (settings.has("environmentVariables") && !settings.get("environmentVariables").isJsonNull()) {
            mask.environmentVariables = true;
        }
        if (settings.has("yarnClusterSettings") && !settings.get("yarnClusterSettings").isJsonNull()) {
            mask.yarnCluster = true;
        }
        return mask;
    }

    public SparkSettings apply(SparkSettings base, SparkSettings overrides) {
        SparkSettings overriden = (SparkSettings)JSON.deepCopy((Object)base);
        if (!this.enabled) {
            return overriden;
        }
        overriden.sparkEnabled = overrides.sparkEnabled;
        overriden.sparkHome = overrides.sparkHome;
        overriden.additionalSparkSubmitJars = overrides.additionalSparkSubmitJars;
        if (this.interactiveExecutionEngine) {
            overriden.interactiveExecutionEngine = overrides.interactiveExecutionEngine;
        }
        if (this.configForJupyter) {
            overriden.configForJupyter = overrides.configForJupyter;
        }
        if (this.configForSEK) {
            overriden.configForSEK = overrides.configForSEK;
        }
        if (this.configForInteractive) {
            overriden.configForInteractive = overrides.configForInteractive;
        }
        if (this.engineCreationSettings) {
            overriden.engineCreationSettings = overrides.engineCreationSettings;
        }
        if (this.properties) {
            HashMap baseConfigs = Maps.newHashMap();
            for (SparkExecutionConfig sparkExecutionConfig : base.executionConfigs) {
                baseConfigs.put(sparkExecutionConfig.name, sparkExecutionConfig);
            }
            HashMap overridesConfigs = Maps.newHashMap();
            for (SparkExecutionConfig config : overrides.executionConfigs) {
                overridesConfigs.put(config.name, config);
            }
            HashSet hashSet = Sets.newHashSet();
            hashSet.addAll(baseConfigs.keySet());
            hashSet.addAll(overridesConfigs.keySet());
            ArrayList configs = Lists.newArrayList();
            for (String name : hashSet) {
                SparkExecutionConfig baseConfig = (SparkExecutionConfig)baseConfigs.get(name);
                SparkExecutionConfig overridesConfig = (SparkExecutionConfig)overridesConfigs.get(name);
                if (baseConfig != null && overridesConfig != null) {
                    overridesConfig.conf = baseConfig.conf.getOverriden(overridesConfig.conf);
                    configs.add(overridesConfig);
                    continue;
                }
                if (baseConfig != null) {
                    configs.add(baseConfig);
                    continue;
                }
                configs.add(overridesConfig);
            }
            ArrayList configsWithGenericOverrides = Lists.newArrayList();
            for (SparkExecutionConfig config : configs) {
                SparkExecutionConfig configWithGenericOverrides = (SparkExecutionConfig)JSON.deepCopy((Object)config);
                configWithGenericOverrides.conf = config.conf.getOverriden(overrides.executionConfigsGenericOverrides);
                configsWithGenericOverrides.add(configWithGenericOverrides);
            }
            overriden.executionConfigs = configsWithGenericOverrides;
        }
        if (this.environmentVariables) {
            overriden.environmentVariables.addAll(overrides.environmentVariables);
        }
        if (this.yarnCluster) {
            overriden.yarnClusterSettings = overrides.yarnClusterSettings;
        }
        return overriden;
    }
}

