/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.PythonCodeStudioKernel;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class PythonPluginCodeStudioCommonUtils {
    private String pluginId;
    private String elementType;
    private CustomPythonElementService<?, ?> service;
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.python.plugin");

    public PythonPluginCodeStudioCommonUtils(String pluginId, String elementType, CustomPythonElementService<?, ?> service) {
        this.pluginId = pluginId;
        this.elementType = elementType;
        this.service = service;
    }

    public <T> T run(AuthCtx authCtx, String projectKey, File tmpDir, String ticketSecret, JsonObject config, CodeStudioKernelCommand<T> command) throws IOException {
        PythonCodeStudioKernel kernel = null;
        SingleCommandKernelLink link = null;
        try {
            String secret = SecretKeyGenerator.generate((int)16);
            PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
            link = new SingleCommandKernelLink(secret, dssPortRange);
            CodeEnvSelector envSelector = new CodeEnvSelector();
            String envName = envSelector.selectForCustomPythonRecipe(this.pluginId);
            String resourceFolder = this.service.getResourceFolder(this.elementType);
            String libFolder = this.service.getLibFolder(this.elementType);
            kernel = new PythonCodeStudioKernel(link, ticketSecret, resourceFolder, libFolder, tmpDir, projectKey, authCtx, envName);
            kernel.start();
            String code = this.service.getCode(this.elementType);
            PluginSettingsResolver.ResolvedSettings resolvedSettings = this.service.getExpandedPluginSettings(this.elementType, authCtx, projectKey, config);
            T t = command.run(resolvedSettings, code, link);
            return t;
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail(kernel);
            throw kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        catch (SocketBlockLink.SecretKernelTimeoutException e) {
            logger.error((Object)"Failure during kernel startup", (Throwable)e);
            throw new CustomPythonKernelException("Failure during kernel startup", (Exception)((Object)e), kernel.getLogTail());
        }
        catch (Exception e) {
            logger.error((Object)"Generic failure during Code Studio block computation", (Throwable)e);
            throw new CustomPythonKernelException("Failure during Code Studio block computation", e, kernel != null ? kernel.getLogTail() : null);
        }
        finally {
            if (kernel != null) {
                try {
                    kernel.killWithoutMercy();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to kill kernel", (Throwable)e);
                }
            }
            if (link != null) {
                try {
                    link.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close link", (Throwable)e);
                }
            }
        }
    }

    public static interface CodeStudioKernelCommand<T> {
        public T run(PluginSettingsResolver.ResolvedSettings var1, String var2, SingleCommandKernelLink var3) throws IOException;
    }

    public static class CodeStudioBlockListReq {
        public final String type = "build_block_list";
        public boolean codeDefinesBlock;
        public String code;
        public JsonObject config;
        public JsonObject pluginConfig;
        public CodeStudioMeta.ImageBuildEnv buildEnv;
        public CodeStudioMeta.CodeStudioLaunchEnv launchEnv;
        public CodeStudioMeta.CreationEnv creationEnv;
    }

    public static class CreationSpecReq {
        public final String type = "build_creation";
        public boolean codeDefinesBlock;
        public String code;
        public JsonObject config;
        public JsonObject pluginConfig;
        public CodeStudioMeta.CreationEnv env;
        public CodeStudioMeta.CreationSpec in;
    }

    public static class CodeStudioPostProcessSpecReq {
        public final String type = "postprocess_launch";
        public boolean codeDefinesBlock;
        public String code;
        public JsonObject config;
        public JsonObject pluginConfig;
        public CodeStudioMeta.CodeStudioLaunchEnv env;
        public CodeStudioMeta.CodeStudioLaunchSpec in;
    }

    public static class CodeStudioLaunchSpecReq {
        public final String type = "build_launch";
        public boolean codeDefinesBlock;
        public String code;
        public JsonObject config;
        public JsonObject pluginConfig;
        public CodeStudioMeta.CodeStudioLaunchEnv env;
        public CodeStudioMeta.CodeStudioLaunchSpec in;
    }

    public static class ImageBuildSpecReq {
        public final String type = "build_spec";
        public boolean codeDefinesBlock;
        public String code;
        public JsonObject config;
        public JsonObject pluginConfig;
        public CodeStudioMeta.ImageBuildEnv env;
        public CodeStudioMeta.ImageBuildSpec in;
        public CodeStudioTemplate template;
    }
}

