/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.HDFSAbleConnection;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;

public abstract class AbstractCloudStorageConnection
extends DSSConnection
implements HDFSAbleConnection,
FSProviderizableConnection {
    public static final String DKU_EXTRA_HADOOP_CONF_PREFIX = "dku.extraHadoopConf.";
    public static final String DKU_EXTRA_SPARK_HADOOP_CONF_PREFIX = "dku.extraSparkHadoopConf.";

    public abstract String getHDFSScheme();

    protected void addDisableCacheIfNeeded(List<AbstractSQLConnection.CustomDatabaseProperty> ret, List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties) {
        AbstractSQLConnection.CustomDatabaseProperty disableCache = DSSConnection.DkuConnectionParams.getDkuProperty("dku.no.disable.hdfs.cache", dkuProperties);
        if (disableCache == null || !"true".equalsIgnoreCase(disableCache.value)) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs." + this.getHDFSScheme() + ".impl.disable.cache", "true", false));
        }
    }

    protected void addExtraHadoopConf(List<AbstractSQLConnection.CustomDatabaseProperty> ret, List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties) {
        String prefix;
        switch (ApplicationConfigurator.getProcessType()) {
            case BACKEND: 
            case JEK: 
            case FEK: 
            case CAK: 
            case EVENTSERVER: {
                prefix = DKU_EXTRA_HADOOP_CONF_PREFIX;
                break;
            }
            case UNKNOWN: {
                prefix = DKU_EXTRA_SPARK_HADOOP_CONF_PREFIX;
                break;
            }
            default: {
                return;
            }
        }
        for (AbstractSQLConnection.CustomDatabaseProperty p : dkuProperties) {
            if (!((String)StringUtils.defaultIfEmpty((CharSequence)p.name, (CharSequence)"")).startsWith(prefix)) continue;
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty(p.name.substring(prefix.length()), p.value, p.secret));
        }
    }

    public String getPredictionLogsRoot() {
        return "";
    }

    public static JsonObject refreshCredentials(String connectionName, String projectKey, final boolean mustResolveOnDSSHost, final boolean mustResolveOnBackend) throws IOException {
        MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(new CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetcher(){

            @Override
            public boolean forceLocalResolution() {
                return false;
            }

            @Override
            public boolean mustResolveOnDSSHost() {
                return mustResolveOnDSSHost;
            }

            @Override
            public boolean mustResolveOnBackend() {
                return mustResolveOnBackend;
            }
        });
        CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo = new CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo(rmiTo);
        return CredentialsRemoteFetchConfigurationProvider.getFromRemote(fetchInfo, "/connections/get-fully-resolved-credentials", JsonObject.class, "projectKey", projectKey, "useTokenCache", true, "name", connectionName);
    }
}

