/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.SQLiteDialect;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SQLiteConnection
extends AbstractSQLConnection {
    public static final String connectionType = "SQLite";
    public Params params = new Params();
    private static final SQLiteDialect dialect = new SQLiteDialect();

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public SQLiteDialect getDialect() {
        return dialect;
    }

    @Override
    String getJarsDirectory() {
        if (StringUtils.isNotBlank((String)this.params.jarsDirectory)) {
            return this.params.jarsDirectory;
        }
        return DKUApp.getInstallFile((String[])new String[]{"lib", "ivy", "backend-run"}).getAbsolutePath();
    }

    @Override
    String getDriver() {
        return "org.sqlite.JDBC";
    }

    @Override
    String getJdbcUrl() {
        return "jdbc:sqlite:" + this.params.filepath;
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.getJdbcUrl();
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        SQLConnectionProvider.GenericSQLConnectionData cd = new SQLConnectionProvider.GenericSQLConnectionData(this.getType(), (SQLDialect)this.getDialect(), (AbstractSQLConnection)this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory());
        this.fillConnectionData(cd);
        return cd;
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        throw new UnsupportedOperationException("Not applicable");
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParams {
        public String filepath;
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    }
}

