/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.simba;

import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StackHeavyMethodWrapper {
    private static final String QUERY_IS_TOO_COMPLEX_TO_BE_HANDLED_BY_SIMBA = "Query is too complex to be handled by the Simba BigQuery JDBC driver. Please report this problem to Google support.";
    private static final int MAX_STACK_SIZE = 0x1000000;
    private static Logger logger = Logger.getLogger((String)"dku.sql.bigquery.wrapper");

    public static <T> T execute(SQLMethod<T> method) throws SQLException {
        try {
            return method.execute();
        }
        catch (StackOverflowError e) {
            logger.info((Object)"The Simba BigQuery driver threw a StackOverflow exception. You might want to increase the max stack size of the JVM.");
            return StackHeavyMethodWrapper.executeWithThread(method, 0x1000000);
        }
        catch (AssertionError e) {
            throw new SQLException("BigQuery JDBC internal driver error. An empty BigQuery table is known to cause this kind of error.", (Throwable)((Object)e));
        }
    }

    private static <T> T executeWithThread(SQLMethod<T> method, int stackSize) throws SQLException {
        MethodRunnerThread<T> thread = new MethodRunnerThread<T>(method, stackSize);
        logger.debug((Object)"Starting thread");
        thread.start();
        logger.debug((Object)"Waiting for thread termination");
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new SQLException(QUERY_IS_TOO_COMPLEX_TO_BE_HANDLED_BY_SIMBA, interruptedException);
        }
        logger.debug((Object)"Getting thread result");
        return thread.getResult();
    }

    public static interface SQLMethod<T> {
        public T execute() throws SQLException;
    }

    private static class MethodRunnerThread<T>
    extends Thread {
        private SQLMethod<T> method;
        private ExecutionResult<T> executionResult;

        public MethodRunnerThread(SQLMethod<T> method, int stackSize) {
            super(null, null, Thread.currentThread().getName() + "-wrapStackHeavyMethod", stackSize);
            this.method = method;
            this.executionResult = new ExecutionResult();
        }

        @Override
        public void run() {
            try {
                this.executionResult.result = this.method.execute();
                this.executionResult.successful = true;
            }
            catch (Exception | StackOverflowError e) {
                this.executionResult.exception = e;
            }
        }

        public T getResult() throws SQLException {
            if (this.executionResult.successful) {
                return this.executionResult.result;
            }
            if (this.executionResult.exception == null) {
                throw new SQLException(StackHeavyMethodWrapper.QUERY_IS_TOO_COMPLEX_TO_BE_HANDLED_BY_SIMBA);
            }
            if (this.executionResult.exception instanceof SQLException) {
                throw (SQLException)this.executionResult.exception;
            }
            if (this.executionResult.exception instanceof StackOverflowError) {
                throw new SQLException(StackHeavyMethodWrapper.QUERY_IS_TOO_COMPLEX_TO_BE_HANDLED_BY_SIMBA);
            }
            if (this.executionResult.exception instanceof RuntimeException) {
                throw (RuntimeException)this.executionResult.exception;
            }
            String exceptionMessage = this.executionResult.exception.getMessage();
            String message = StackHeavyMethodWrapper.QUERY_IS_TOO_COMPLEX_TO_BE_HANDLED_BY_SIMBA + (String)(StringUtils.isNotBlank((String)exceptionMessage) ? ": " + exceptionMessage : "");
            throw new SQLException(message, this.executionResult.exception);
        }
    }

    private static class ExecutionResult<T> {
        public boolean successful;
        public boolean stackOverflow;
        public Throwable exception;
        public T result;

        private ExecutionResult() {
        }
    }
}

