/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.ISISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.graph.utils.GraphUtils;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SISORecipeExecutor
implements ISISORecipeExecutor {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected VariablesService variablesService;
    protected JobActivity activity;
    protected Dataset inputDS;
    protected Dataset outputDS;
    protected StreamingEndpoint outputSE;
    protected List<Partition> inputPartitions;
    protected Partition outputPartition;
    protected WarningsContext warnContext;
    protected Output.WriteMode writeMode;
    protected Output.WriteMode originalWriteMode;
    protected AuthCtx authCtx;
    protected String contextProjectKey;

    public SISORecipeExecutor() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void init(JobActivity activity, Output.WriteMode writeMode) throws Exception {
        RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        FlowDataset inputFD = GraphUtils.getSingleSource(subgraph.getRecipe());
        FlowComputable outputFC = GraphUtils.getSingleTargetAnyComputable(subgraph.getRecipe());
        if (outputFC.getType() == FlowComputable.FCType.DATASET) {
            this.outputDS = ((FlowDataset)outputFC).getMandatory(this.datasetsDAO);
        } else if (outputFC.getType() == FlowComputable.FCType.STREAMING_ENDPOINT) {
            this.outputSE = ((FlowStreamingEndpoint)outputFC).getStreamingEndpoint();
        }
        this.activity = activity;
        this.contextProjectKey = subgraph.getRecipe().getProjectKey();
        this.inputDS = inputFD.getMandatory(this.datasetsDAO);
        this.inputPartitions = subgraph.getSourcePartitions(inputFD);
        if (this.outputDS != null && !subgraph.isAllTargetPartitions()) {
            this.outputPartition = subgraph.getTargetPartition(outputFC);
        }
        this.writeMode = writeMode;
        this.originalWriteMode = writeMode;
        this.authCtx = ((JobAuthCtxService)SpringUtils.getBean(JobAuthCtxService.class)).getAuthCtx();
        this.warnContext = activity.warnContext;
        this.clearOutputPartitionsIfNeeded();
    }

    protected void clearOutputPartitionsIfNeeded() throws Exception {
        if (this.outputDS != null) {
            try (DatasetHandler outputDatasetHandler = DatasetHandlerFactory.build(this.authCtx, this.outputDS);){
                if (this.writeMode == Output.WriteMode.OVERWRITE && !outputDatasetHandler.outputHandlesClear()) {
                    if (outputDatasetHandler.getMeta().isFSLike()) {
                        outputDatasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{this.outputPartition}));
                    }
                    this.writeMode = Output.WriteMode.APPEND;
                }
            }
        }
    }

    protected FilterDesc expandFilter(FilterDesc filterDesc) {
        FilterDesc expandedFilterDesc = (FilterDesc)JSON.deepCopy((Object)filterDesc);
        VariablesContext vc = this.variablesService.getForProject(this.contextProjectKey);
        if (expandedFilterDesc != null) {
            FilterDescUtils.expandExpressionIfNeeded(expandedFilterDesc, vc);
        }
        return expandedFilterDesc;
    }

    @Override
    public abstract void run() throws Exception;

    protected static class CompatibilityCheck {
        public String errorMessage;

        protected CompatibilityCheck() {
        }

        public static CompatibilityCheck ok() {
            return new CompatibilityCheck();
        }

        public static CompatibilityCheck unsupported(String errorMessage) {
            CompatibilityCheck result = new CompatibilityCheck();
            result.errorMessage = (String)Preconditions.checkNotNull((Object)errorMessage);
            return result;
        }

        public boolean isOk() {
            return this.errorMessage == null;
        }
    }
}

