/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.Matcher;

public class LevenshteinMatcher
extends Matcher {
    public LevenshteinMatcher(double threshold, Integer relativeTo, boolean debugMode) {
        super(threshold, relativeTo, debugMode);
    }

    @Override
    protected boolean isValidInputs(String query, String candidate) {
        return query != null && candidate != null;
    }

    @Override
    public double computeDistance(String query, String candidate) {
        int i;
        if (query == null || candidate == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        double normalisationFactor = this.computeNormalisationFactor(query, candidate);
        int n = query.length();
        int m = candidate.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            String tmp = query;
            query = candidate;
            candidate = tmp;
            n = m;
            m = candidate.length();
        }
        int[] d = new int[n + 1];
        int[] p1 = new int[n + 1];
        int[] p2 = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p1[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char candidateChar = candidate.charAt(j - 1);
            d[0] = j;
            double curLineMin = 2.147483647E9;
            for (i = 1; i <= n; ++i) {
                char queryChar = query.charAt(i - 1);
                int cost = queryChar == candidateChar ? 0 : 1;
                int deletion = d[i - 1] + 1;
                int insertion = p1[i] + 1;
                int substitution = p1[i - 1] + cost;
                d[i] = Math.min(Math.min(deletion, insertion), substitution);
                if ((double)d[i] < curLineMin) {
                    curLineMin = d[i];
                }
                if (i <= 1 || j <= 1 || queryChar != candidate.charAt(j - 2) || query.charAt(i - 2) != candidateChar) continue;
                d[i] = Math.min(d[i], p2[i - 2] + cost);
            }
            if (this.isRelative()) {
                curLineMin /= normalisationFactor;
            }
            if (!this.debugMode && curLineMin > this.threshold) {
                return -1.0;
            }
            int[] swapPlaceholder = p2;
            p2 = p1;
            p1 = d;
            d = swapPlaceholder;
        }
        return p1[n];
    }

    @Override
    protected double computeNormalisationFactor(String reference, String query) {
        if (this.relativeTo == null) {
            return 1.0;
        }
        return this.relativeTo == 0 ? (double)reference.length() : (double)query.length();
    }

    @Override
    protected FuzzyJoinRecipePayloadParams.DistanceType getDistanceType() {
        return FuzzyJoinRecipePayloadParams.DistanceType.LEVENSHTEIN;
    }
}

