/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.geojoin.GeoUtils;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeQueryGenerator;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import java.util.Map;

public class GeoJoinQueryGenerator
extends JoinLikeQueryGenerator<GeoJoinRecipePayloadParams, GeoJoinRecipePayloadParams.MatchingCondition, GeoJoinRecipePayloadParams.JoinDesc> {
    public GeoJoinQueryGenerator(GeoJoinRecipePayloadParams params, Map<String, Dataset> sources, Map<String, SQLUtils.SQLTable> tables, Dataset outputDataset) {
        super(params, sources, tables, outputDataset, JoinOutputRole.MAIN);
    }

    @Override
    protected void joinUsingTypeSpecificOperators(SelectQueryBuilder wrapper, SelectQueryBuilder query, GeoJoinRecipePayloadParams.JoinDesc join, SelectQueryBuilder.JoinClauseBuilder joinBuilder, JoinInputDescBase table1Desc, JoinInputDescBase table2Desc) {
        for (GeoJoinRecipePayloadParams.MatchingCondition cond : join.getJoinConditions()) {
            ExpressionBuilder col1 = this.col(cond.column1);
            ExpressionBuilder col2 = this.col(cond.column2);
            switch (cond.type) {
                case EQ: {
                    joinBuilder.on(col1.stEquals(col2));
                    break;
                }
                case DWITHIN: {
                    joinBuilder.on(col1.stDwithin(col2, GeoUtils.convertToMeters(cond.threshold, cond.unit)));
                    break;
                }
                case BEYOND: {
                    joinBuilder.on(col1.stBeyond(col2, GeoUtils.convertToMeters(cond.threshold, cond.unit)));
                    break;
                }
                case WITHIN: {
                    joinBuilder.on(col1.stWithin(col2));
                    break;
                }
                case TOUCHES: {
                    joinBuilder.on(col1.stTouches(col2));
                    break;
                }
                case CONTAINS: {
                    joinBuilder.on(col1.stContains(col2));
                    break;
                }
                case DISJOINT: {
                    joinBuilder.on(col1.stDisjoint(col2));
                    break;
                }
                case INTERSECTS: {
                    joinBuilder.on(col1.stIntersects(col2));
                }
            }
        }
    }

    @Override
    protected boolean requiresWrapper(GeoJoinRecipePayloadParams.JoinDesc join) {
        return false;
    }
}

