/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.ModalitySlugifier;
import com.dataiku.dip.dataflow.exec.pivot.ModalitySlugifiers;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.dataflow.exec.pivot.PivotElementsModalitiesSnapshot;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeExecutor;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.pivot.PivotRecipeStatusComputer;
import com.dataiku.dip.dataflow.exec.pivot.PivotSchemaGenerator;
import com.dataiku.dip.dataflow.exec.pivot.PivotedModality;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.kernel.slave.KernelSession;
import com.dataiku.dip.dataflow.streaming.DatasetWritingService;
import com.dataiku.dip.datalayer.CellData;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.RowsComparator;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.dataiku.dip.datalayer.utils.SchemaComparator;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.exceptions.TransactionContextError;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPivotRecipeExecutor
implements PivotRecipeExecutor {
    @Autowired
    protected JobAuthCtxService authCtxService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetWritingService datasetWritingService;
    @Autowired
    private VisualSQLRecipesBaseService visualRecipesService;
    protected final JobActivity activity;
    protected final FlowRecipe recipe;
    protected final PivotRecipePayloadParams params;
    protected Dataset inputDS;
    protected Dataset outputDS;
    protected List<Partition> sourcePartitions;
    protected final VisualSQLRecipesBaseService.SQLBasedEngineStatus engine;
    protected boolean lowercaseColumns;
    protected List<String> identifiers;
    private final List<Runnable> abortHooks = Lists.newArrayList();
    protected static Logger logger = Logger.getLogger((String)"dku.recipe.pivot");

    public AbstractPivotRecipeExecutor(VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, JobActivity activity, PivotRecipePayloadParams params) {
        SpringUtils.getInstance().autowire((Object)this);
        this.engine = engine;
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.activity.initStatus();
        this.params = params;
    }

    @Override
    public void init() throws Exception {
        FlowDataset inputFD = this.activity.getSubgraph().getSingleSourceDataset();
        this.inputDS = inputFD.getMandatory(this.datasetsDAO);
        FlowDataset outputFD = this.activity.getSubgraph().getSingleTargetDataset();
        this.outputDS = outputFD.getMandatory(this.datasetsDAO);
        this.sourcePartitions = this.activity.getSubgraph().getSourcePartitions(inputFD);
        PivotRecipeStatusComputer.PivotRecipeStatus status = new PivotRecipeStatusComputer.PivotRecipeStatus();
        status.pivot = new RecipeStatus.StepStatus();
        status.otherColumns = new RecipeStatus.StepStatus();
        PivotRecipeStatusComputer.checkParamsStageConsistency(this.params, status, this.inputDS.getSchema());
        if (status.isInvalid()) {
            throw new IllegalArgumentException("Invalid params " + status.gatherAllMessages().report());
        }
        this.identifiers = this.params.buildIdentifierList(this.inputDS.getSchema());
        this.lowercaseColumns = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, this.engine);
    }

    @Override
    public void run() throws Exception {
        PivotElementsModalitiesSnapshot pivotElementsModalities = PivotRecipeSchemaComputer.getPivotElementsModalitiesIfUptodate(this.params, this.outputDS.getSchema());
        boolean updateSchemaMetadataOnlyIfNeeded = true;
        if (this.params.schemaComputation != PivotRecipePayloadParams.SchemaComputation.ONLY_IF_NO_METADATA || pivotElementsModalities == null) {
            logger.info((Object)"Modalities list is not up to date, recomputing");
            pivotElementsModalities = this.getModalities(this.params.pivots);
            updateSchemaMetadataOnlyIfNeeded = false;
        } else {
            logger.info((Object)"Modalities list exists and is up to date");
        }
        SQLDialect dialect = this.getOutputDialect();
        SchemaUtils.SchemalessSafeColumnIdentifierSuffixer safeColumnIdentifierSuffixer = new SchemaUtils.SchemalessSafeColumnIdentifierSuffixer(this.params.getModalityMaxLength(dialect));
        for (PivotElementsModalitiesSnapshot.PivotElementsModalities pivotElementsModality : pivotElementsModalities.pivotElementsModalities) {
            pivotElementsModality.applySafeSuffixing(safeColumnIdentifierSuffixer);
        }
        this.updateOutputSchema(pivotElementsModalities.pivotElementsModalities, updateSchemaMetadataOnlyIfNeeded, this.schemaComparisonIsCaseSensitive());
        logger.info((Object)"Run the pivot query");
        this.execute(pivotElementsModalities.pivotElementsModalities);
    }

    protected abstract void execute(List<PivotElementsModalitiesSnapshot.PivotElementsModalities> var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AutoCloseable startAbortableTask(final Runnable runnable) {
        List<Runnable> list = this.abortHooks;
        synchronized (list) {
            this.abortHooks.add(runnable);
        }
        return new AutoCloseable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                List<Runnable> list = AbstractPivotRecipeExecutor.this.abortHooks;
                synchronized (list) {
                    AbstractPivotRecipeExecutor.this.abortHooks.remove(runnable);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBeforeAborting() {
        ArrayList hooks;
        List<Runnable> list = this.abortHooks;
        synchronized (list) {
            hooks = Lists.newArrayList(this.abortHooks);
        }
        logger.info((Object)("Aborting executor : " + hooks.size() + " hooks to run"));
        for (Runnable hook : hooks) {
            try {
                hook.run();
            }
            catch (Exception e) {
                logger.error((Object)"Fail to run abort hook", (Throwable)e);
            }
        }
    }

    protected boolean schemaComparisonIsCaseSensitive() {
        return true;
    }

    protected PivotElementsModalitiesSnapshot getModalities(List<PivotElement> pivotElements) throws Exception {
        ArrayList pivotModalities = Lists.newArrayList();
        for (PivotElement pivotElement : pivotElements) {
            if (pivotElement.valueLimit == PivotElement.PivotValueLimit.EXPLICIT) {
                pivotModalities.add(new PivotElementsModalitiesSnapshot.PivotElementsModalities(pivotElement, this.getExplicitModalities(pivotElement)));
                continue;
            }
            List<PivotedModality> modalities = this.doCollectModalities(pivotElement);
            if (this.params.sortModalities) {
                modalities = this.sortModalities(pivotElement, modalities);
            }
            pivotModalities.add(new PivotElementsModalitiesSnapshot.PivotElementsModalities(pivotElement, modalities));
        }
        PivotElementsModalitiesSnapshot snapshot = new PivotElementsModalitiesSnapshot();
        snapshot.pivotElementsModalities = pivotModalities;
        snapshot.engineType = this.engine.type;
        return snapshot;
    }

    protected abstract List<PivotedModality> doCollectModalities(PivotElement var1) throws Exception;

    protected List<PivotedModality> sortModalities(PivotElement pivotElement, List<PivotedModality> modalities) {
        PivotSchemaGenerator generator = new PivotSchemaGenerator(this.params);
        Schema schema = generator.generateForPivotStage(this.inputDS.getSchema());
        ArrayList specs = Lists.newArrayList();
        for (String string : pivotElement.keyColumns) {
            Sorter.SortSpec spec = new Sorter.SortSpec(string, true);
            spec.factoryColumn = new ModalityColumn(string, specs.size());
            spec.schemaColumn = schema.getColumn(string);
            specs.add(spec);
        }
        ArrayList rows = Lists.newArrayList();
        for (PivotedModality modality : modalities) {
            rows.add(new NumberedRow(new ModalityRow(modality), rows.size()));
        }
        RowsComparator rowsComparator = new RowsComparator(specs, RowsComparator.NullsOrdering.NULLS_FIRST);
        Collections.sort(rows, rowsComparator);
        ArrayList sorted = Lists.newArrayList();
        for (NumberedRow row : rows) {
            sorted.add(((ModalityRow)row.row).modality);
        }
        return sorted;
    }

    protected List<PivotedModality> getExplicitModalities(PivotElement pivotElement) {
        ArrayList modalities = Lists.newArrayList();
        ModalitySlugifier modalitySlugifier = ModalitySlugifiers.getSlugifier(this.params.modalitySlugification);
        for (List<String> keyValues : pivotElement.explicitValues) {
            if (keyValues.size() < pivotElement.keyColumns.size()) {
                logger.warn((Object)("Explicit list of values is too short : " + keyValues.size() + " < " + pivotElement.keyColumns.size() + ", extending."));
            }
            while (keyValues.size() < pivotElement.keyColumns.size()) {
                keyValues.add(null);
            }
            if (keyValues.size() < pivotElement.keyColumns.size()) {
                logger.warn((Object)("Explicit list of values is too long : " + keyValues.size() + " > " + pivotElement.keyColumns.size() + ", truncating."));
            }
            while (keyValues.size() > pivotElement.keyColumns.size()) {
                keyValues.remove(keyValues.size() - 1);
            }
            PivotedModality modality = PivotedModality.fromModalities(keyValues, pivotElement, modalitySlugifier);
            modalities.add(modality);
        }
        return modalities;
    }

    private void updateOutputSchema(List<PivotElementsModalitiesSnapshot.PivotElementsModalities> pivotElementsModalities, boolean onlyIfNeeded, boolean caseSensitive) throws TransactionContextError, Exception {
        PivotSchemaGenerator schemaGenerator = new PivotSchemaGenerator(this.params);
        SQLDialect dialect = this.getOutputDialect();
        Schema schema = schemaGenerator.generate(this.inputDS.getSchema(), this.identifiers, pivotElementsModalities, this.params.getModalityMaxLength(dialect), this.lowercaseColumns);
        if (onlyIfNeeded && SchemaComparator.findIncompatibilities(this.outputDS.getSchema(), schema, caseSensitive).isEmpty()) {
            logger.info((Object)"No change in the output schema");
        } else {
            logger.info((Object)("Schema or modalities changed (onlyIfNeeded=" + onlyIfNeeded + ")"));
            PivotElementsModalitiesSnapshot snapshot = new PivotElementsModalitiesSnapshot();
            snapshot.pivotElementsModalities = pivotElementsModalities;
            snapshot.engineType = this.engine.type;
            schema.metadata = JSON.toJsonObject((Object)snapshot);
            logger.info((Object)("Overriding the schema of the dataset to " + JSON.pretty((Object)schema)));
            this.datasetWritingService.writeDatasetSchema(TransactionContext.retrieveWrite().getUser(), this.outputDS.getLoc(), schema, false, null);
            KernelSession.propagateSchemaToJekOrBackend(this.outputDS.getFullName(), schema);
            this.outputDS.setSchema(schema);
        }
    }

    protected SQLDialect getOutputDialect() throws IOException, SQLException, DKUSecurityException {
        return null;
    }

    private static class ModalityColumn
    extends Column {
        private final String name;
        private final int index;

        public ModalityColumn(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public Column setName(String name) {
            throw new Error("unreachable");
        }
    }

    private static class ModalityRow
    implements Row {
        private final PivotedModality modality;

        public ModalityRow(PivotedModality modality) {
            this.modality = modality;
        }

        public String get(Column cd) {
            int index = ((ModalityColumn)cd).getIndex();
            return this.modality.keyValues.get(index);
        }

        public String get(Column cd, String defaultValue) {
            return StringUtils.defaultIfBlank((String)this.get(cd), (String)defaultValue);
        }

        public boolean empty(Column cd) {
            return StringUtils.isBlank((String)this.get(cd));
        }

        public Row.RowContext getRowContext() {
            throw new NotImplementedException();
        }

        public void put(Column key, String value) {
            throw new Error("unreachable");
        }

        public void put(Column key, int value) {
            throw new Error("unreachable");
        }

        public void put(Column key, long value) {
            throw new Error("unreachable");
        }

        public void put(Column key, double value) {
            throw new Error("unreachable");
        }

        public void put(Column key, boolean value) {
            throw new Error("unreachable");
        }

        public Row with(Column key, String value) {
            throw new Error("unreachable");
        }

        public Row with(Column key, int value) {
            throw new Error("unreachable");
        }

        public Row with(Column key, long value) {
            throw new Error("unreachable");
        }

        public Row with(Column key, double value) {
            throw new Error("unreachable");
        }

        public Row with(Column key, boolean value) {
            throw new Error("unreachable");
        }

        public void delete(Column key) {
            throw new Error("unreachable");
        }

        public void delete() {
            throw new Error("unreachable");
        }

        public boolean isDeleted() {
            throw new Error("unreachable");
        }

        public Row with(ColumnFactory cf, String key, String value) {
            throw new Error("unreachable");
        }

        public void get(Column cd, CellData buf) {
            throw new Error("unreachable");
        }

        public double getAsDoubleOrNaN(Column cd) {
            throw new Error("unreachable");
        }
    }
}

