/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ConnectionsView
extends AbstractFlowTool.FlowView {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    private ConnectionsViewState state;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.connections");

    public ConnectionsView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized ConnectionsViewState computeState() throws Exception {
        this.state = new ConnectionsViewState();
        try (Transaction tr = this.transactionService.beginRead();){
            String connectionName;
            String nodeId;
            for (ManagedFolder folder : this.managedFolderDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forManagedFolder(folder.projectKey, folder.id);
                try {
                    connectionName = folder.getParams().getConnection();
                    this.computeTaggableObjectState(connectionName, nodeId, null);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to get dataset connection", (Throwable)e);
                }
            }
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forDataset(sd.projectKey, sd.name);
                try {
                    connectionName = sd.getParams().getConnection();
                    String formatType = sd.formatType;
                    this.computeTaggableObjectState(connectionName, nodeId, formatType);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to get dataset connection", (Throwable)e);
                }
            }
            for (StreamingEndpoint se : this.streamingEndpointsDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forStreamingEndpoint(se.projectKey, se.id);
                try {
                    if (!"kafka".equals(se.type)) continue;
                    KafkaStreamingEndpointParams seParams = se.getParamsAs(KafkaStreamingEndpointParams.class);
                    String connectionName2 = seParams.connection;
                    String formatType = seParams.formatType;
                    this.computeTaggableObjectState(connectionName2, nodeId, formatType);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to get streaming endpoint connection", (Throwable)e);
                }
            }
            for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                nodeId = GraphIds.forRetrievableKnowledge(rk.projectKey, rk.id);
                try {
                    if (rk.vectorStoreType == null || !rk.vectorStoreType.hasConnection) continue;
                    connectionName = rk.connection;
                    this.computeTaggableObjectState(connectionName, nodeId, null);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to get retrievable knowledge connection", (Throwable)e);
                }
            }
        }
        return this.state;
    }

    private void computeTaggableObjectState(String connectionName, String nodeId, String formatType) throws IOException, DKUSecurityException {
        if (StringUtils.isBlank((String)connectionName)) {
            this.add(nodeId, "No connection", null);
        } else {
            DSSConnection conn = this.connectionsDAO.getConnectionUnsafeUnexpanded(this.authCtx, connectionName);
            if (conn != null) {
                this.add(nodeId, connectionName, formatType);
            }
        }
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private void add(String nodeId, String connection, String formatType) {
        NodeConnectionInfo val = new NodeConnectionInfo();
        val.connection = connection;
        val.formatType = formatType;
        this.state.valueByNode.put(nodeId, val);
    }

    public class ConnectionsViewState
    implements AbstractFlowTool.FlowState {
        Map<String, NodeConnectionInfo> valueByNode = new HashMap<String, NodeConnectionInfo>();
        public Collection<String> focused = new HashSet<String>();
    }

    public class NodeConnectionInfo {
        String connection;
        String formatType;
    }
}

