/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RecipesEnginesView
extends AbstractFlowTool.FlowView {
    private RecipesEnginesViewState state;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.engines");

    public RecipesEnginesView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        if (this.state != null) {
            Collection<String> currentFocus = this.state.focused;
            this.computeState();
            this.state.focused = currentFocus;
        } else {
            this.computeState();
        }
        return this.state;
    }

    @Override
    public synchronized RecipesEnginesViewState computeState() throws Exception {
        List recipesList;
        this.state = new RecipesEnginesViewState();
        try (Transaction listTr = this.transactionService.beginRead();){
            recipesList = this.recipesDAO.listUnsafe(this.projectKey);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to list recipes for project " + this.projectKey), (Throwable)e);
            throw e;
        }
        for (SerializedRecipe sr : recipesList) {
            FutureProgressState.checkInterrupt();
            RecipeEngineStatus engineStatus = null;
            String nodeId = GraphIds.forRecipe(sr.name);
            try {
                Transaction recipeTr = this.transactionService.beginRead();
                try {
                    engineStatus = this.getEngineStatus(sr);
                    if (engineStatus == null) continue;
                    ContainerExecRuntimeConfig containerConfig = this.getContainerConfig(sr);
                    if (containerConfig != null) {
                        engineStatus = this.updateEngineStatus(engineStatus, containerConfig.type.name().toLowerCase());
                    }
                    this.state.valueByNode.put(nodeId, engineStatus);
                }
                finally {
                    if (recipeTr == null) continue;
                    recipeTr.close();
                }
            }
            catch (Exception e) {
                logger.info((Object)("Failed to get recipe settings for recipe " + sr.name + " (nodeId: " + nodeId + ")"), (Throwable)e);
            }
        }
        return this.state;
    }

    private ContainerExecRuntimeConfig getContainerConfig(SerializedRecipe sr) throws Exception {
        String payload = this.recipesDAO.getPayloadOrNull(this.projectKey, sr.name);
        RecipeMeta recipeMeta = RecipeRegistry.getMeta(sr.getType());
        ContainerExecSelection containerSelection = recipeMeta.getContainerExecSelection(sr, payload);
        if (containerSelection == null) {
            return null;
        }
        RecipeMeta.RecipeCategoryFlags recipeFlags = recipeMeta.getCategoryFlags();
        if (recipeFlags != null && recipeFlags.isVisualRecipe) {
            try {
                return new ContainerExecConfigSelector().select_autoTXN_visualRecipesWorkloads(this.authCtx, this.projectKey, containerSelection);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to get container config for recipe", (Throwable)e);
                return null;
            }
        }
        try {
            return new ContainerExecConfigSelector().select_autoTXN(this.authCtx, this.projectKey, containerSelection);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to get container config for recipe", (Throwable)e);
            return null;
        }
    }

    private RecipeEngineStatus updateEngineStatus(RecipeEngineStatus engineStatus, String containerType) {
        switch (engineStatus.type) {
            case "DSS": {
                if (engineStatus.isCDEDowngradedToLocal != null && engineStatus.isCDEDowngradedToLocal.booleanValue()) {
                    return engineStatus;
                }
            }
            case "USER_CODE": {
                engineStatus.variantLabel = engineStatus.variantLabel + String.format(" (%s)", containerType);
                engineStatus.type = engineStatus.type + " in container";
                return engineStatus;
            }
            case "PLUGIN_CODE": {
                return new RecipeEngineStatus("DOCKER/KUBERNETES", "Docker/Kubernetes", StringUtils.capitalize((String)containerType), StringUtils.capitalize((String)containerType), "Docker/Kubernetes");
            }
        }
        return engineStatus;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    private RecipeEngineStatus getEngineStatus(SerializedRecipe sr) throws Exception {
        RecipeEngineStatus lightStatus = new RecipeEngineStatus();
        lightStatus.type = "OTHER";
        lightStatus.typeLabel = "Other";
        lightStatus.label = "Other";
        try {
            RecipeMeta meta = RecipeRegistry.getMeta(sr);
            String payload = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name);
            RecipeStatusComputer cs2 = meta.buildStatusComputer(sr, payload);
            if (cs2 == null) {
                return lightStatus;
            }
            RecipeStatus status = cs2.fastStatusIgnorePartitions(this.authCtx);
            if (status == null) {
                return lightStatus;
            }
            RecipeEngineStatus engineStatus = status.selectedEngine;
            if (engineStatus == null) {
                return lightStatus;
            }
            lightStatus.type = engineStatus.type;
            lightStatus.typeLabel = engineStatus.typeLabel;
            lightStatus.variant = engineStatus.variant;
            lightStatus.variantLabel = engineStatus.variantLabel;
            lightStatus.label = engineStatus.label;
            lightStatus.statusWarnLevel = engineStatus.statusWarnLevel;
            lightStatus.statusMessage = engineStatus.statusMessage;
            lightStatus.isCDEDowngradedToLocal = engineStatus.isCDEDowngradedToLocal;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to compute recipe status: ", (Throwable)e);
            lightStatus.type = "ERROR";
            lightStatus.typeLabel = "Error";
            lightStatus.label = "Error";
        }
        return lightStatus;
    }

    public class RecipesEnginesViewState
    implements AbstractFlowTool.FlowState {
        Map<String, RecipeEngineStatus> valueByNode = new HashMap<String, RecipeEngineStatus>();
        public Collection<String> focused = new HashSet<String>();
    }
}

