/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pdep;

import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.dataflow.pdep.DimensionDependencyEvaluator;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;

public class LatestAvailableEvaluator
extends DimensionDependencyEvaluator {
    private final Partitionable dataset;
    private final AuthCtx authCtx;

    public LatestAvailableEvaluator(AuthCtx authCtx, Partitionable dataset) {
        this.dataset = dataset;
        this.authCtx = authCtx;
    }

    @Override
    public List<DimensionValue> getDependent(DimensionValue target, Dimension srcDim, Map<String, List<Partition>> datasetPartitionCache) throws Exception {
        List<Partition> partitions = this.getPartitionList(this.dataset, this.authCtx, datasetPartitionCache);
        if (partitions.size() == 0) {
            throw new IllegalArgumentException("Cannot evaluate latest partition of " + this.dataset.getFullName() + ": no partition is available");
        }
        Partition latestPartition = PartitioningUtils.sort(partitions, true).get(0);
        return Lists.newArrayList((Object[])new DimensionValue[]{(DimensionValue)latestPartition.getDimensionValues().get(srcDim.getName())});
    }

    @Override
    public List<DimensionValue> getDependent(DimensionValue target, Dimension srcDim) throws Exception {
        return this.getDependent(target, srcDim, null);
    }
}

