/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.dynamic;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.dynamic.SmallDatasetEasyLoadHelper;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class VariablesExpansionLoopItemsIterable
implements Iterable<JsonObject> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.dynamic.veloop.iterable");
    private final AuthCtx authCtx;
    private final String contextProjectKey;
    private final VariablesExpansionLoopConfig config;

    public static JsonObject firstIterationOnlyFailIfNone(AuthCtx authCtx, String contextProjectKey, VariablesExpansionLoopConfig config, String errorMessage) {
        VariablesExpansionLoopItemsIterable veit = new VariablesExpansionLoopItemsIterable(authCtx, contextProjectKey, config);
        Iterator<JsonObject> veitIterator = veit.iterator();
        if (veitIterator.hasNext()) {
            return veitIterator.next();
        }
        throw new IllegalArgumentException(errorMessage);
    }

    public VariablesExpansionLoopItemsIterable(AuthCtx authCtx, String contextProjectKey, @Nullable VariablesExpansionLoopConfig config) {
        this.authCtx = authCtx;
        this.contextProjectKey = contextProjectKey;
        if (config == null) {
            config = new VariablesExpansionLoopConfig();
        }
        this.config = config;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public Iterator<JsonObject> iterator() {
        try {
            return new VariablesExpansionLoopItemsIterator();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to iterate", e);
        }
    }

    class VariablesExpansionLoopItemsIterator
    implements Iterator<JsonObject> {
        private int nextIndex = 0;
        private MemTable mt = new MemTable();

        VariablesExpansionLoopItemsIterator() throws Exception {
            if (VariablesExpansionLoopItemsIterable.this.config.isEnabled()) {
                if (StringUtils.isBlank((String)VariablesExpansionLoopItemsIterable.this.config.datasetRef)) {
                    throw new IllegalArgumentException("No parameters dataset selected for repeating dataset/recipe");
                }
                int maxIterationsCount = DKUApp.getParams().getIntParamOrElse("dku.flow.repeating.maxIterationsCount", 10000);
                this.mt = SmallDatasetEasyLoadHelper.load_AutoTXN(VariablesExpansionLoopItemsIterable.this.authCtx, AnyLoc.resolveSmart(VariablesExpansionLoopItemsIterable.this.contextProjectKey, VariablesExpansionLoopItemsIterable.this.config.datasetRef), maxIterationsCount);
                logger.info((Object)("Ready to iterate on veloop, iterationsCount=" + this.mt.nrows()));
            }
        }

        @Override
        public boolean hasNext() {
            if (VariablesExpansionLoopItemsIterable.this.config.isEnabled()) {
                return this.nextIndex < this.mt.nrows();
            }
            return this.nextIndex == 0;
        }

        @Override
        public JsonObject next() {
            JsonObject jo = new JsonObject();
            if (VariablesExpansionLoopItemsIterable.this.config.isEnabled()) {
                logger.info((Object)"next on real veloop iterator");
                Row nextRow = this.mt.rows.get(this.nextIndex);
                switch (VariablesExpansionLoopItemsIterable.this.config.mode) {
                    case CREATE_VARIABLE_FOR_EACH_COLUMN: {
                        for (Column cd : this.mt.columns()) {
                            String value = nextRow.get(cd);
                            if (value == null) continue;
                            jo.addProperty(cd.getName(), value);
                        }
                        break;
                    }
                    case MULTIPLE_REPLACEMENTS: {
                        for (VariablesExpansionLoopConfig.VariableReplacement vr : VariablesExpansionLoopItemsIterable.this.config.replacements) {
                            MemColumn cd = this.mt.getColumn(vr.column);
                            if (cd == null) {
                                throw new IllegalArgumentException("Requested column " + vr.column + " for dynamic-loop expansion does not exist");
                            }
                            String value = nextRow.get((Column)cd);
                            if (value == null) continue;
                            jo.addProperty(vr.variableName, value);
                        }
                        break;
                    }
                }
            }
            ++this.nextIndex;
            logger.trace(() -> "Iteration data: " + JSON.json((Object)jo));
            return jo;
        }
    }
}

