/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.elasticsearch;

import com.dataiku.dip.datasets.elasticsearch.ElasticSearchIndex;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchUtils;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.ElasticSearchIndexPartitioner;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.entity.StringEntity;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.NotImplementedException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ElasticSearchUnmanagedPartitionUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.elasticsearch");

    static List<Partition> listPartitionsExternal(ElasticSearchIndex esIndex, long limit) throws Exception {
        switch (esIndex.unmanagedPartitioningType) {
            case INDEX: {
                ElasticSearchIndexPartitioner partitioner = new ElasticSearchIndexPartitioner(esIndex.partitioningScheme, esIndex.partitioningIndexPattern);
                return partitioner.getPartitions(esIndex.listIndicesWithCount().keySet());
            }
            case COLUMN: {
                return ElasticSearchUnmanagedPartitionUtils.listPartitionsExternalColumnBased(esIndex, limit);
            }
        }
        throw new IllegalArgumentException("Unknown partitioning type: " + String.valueOf((Object)esIndex.unmanagedPartitioningType));
    }

    static String resolvePartitionIdentifierInPattern(String pattern, Partition partition, PartitioningScheme scheme) {
        ElasticSearchIndexPartitioner partitioner = new ElasticSearchIndexPartitioner(scheme, pattern);
        String resolved = partitioner.resolvePartitionIdentifierInPattern(partition);
        if (resolved != null) {
            return ElasticSearchUtils.normalizeName(resolved, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Partition> listPartitionsExternalColumnBased(ElasticSearchIndex esIndex, long limit) throws IOException {
        LinkedHashSet<Partition> partitions = new LinkedHashSet<Partition>();
        HttpPost req = new HttpPost(esIndex.dialect.getBaseUrl(esIndex.address, esIndex.rootIndex, esIndex.typeUrl) + "/_search?" + esIndex.dialect.countArgs);
        JSONObject query = new JSONObject().put("aggregations", (Object)new JSONObject().put("a", (Object)new JSONObject().put("terms", (Object)new JSONObject().put("field", (Object)esIndex.partitioningColumn).put("size", limit))));
        req.setEntity((HttpEntity)new StringEntity(query.toString(), ElasticSearchIndex.REQ_CONTENT_TYPE));
        HttpResponse resp = esIndex.execute((HttpUriRequest)req, false, "Can't fetch values for field " + esIndex.partitioningColumn, new int[0]);
        try {
            JSONArray buckets = new JSONObject(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent())).getJSONObject("aggregations").getJSONObject("a").getJSONArray("buckets");
            Dimension dimension = esIndex.partitioningScheme.getDimension(esIndex.partitioningColumn);
            for (int i = 0; i < buckets.length(); ++i) {
                DimensionValue value;
                Partition p = new Partition(esIndex.partitioningScheme);
                try {
                    value = dimension.getValueFromId(buckets.getJSONObject(i).getString("key"));
                }
                catch (IllegalArgumentException | JSONException e) {
                    JSONObject bucket = buckets.getJSONObject(i);
                    if (!(dimension instanceof TimeDimension) || !bucket.has("key_as_string")) {
                        throw e;
                    }
                    value = ElasticSearchUnmanagedPartitionUtils.unparseDateId((TimeDimension)dimension, bucket.getString("key_as_string"));
                }
                p.setDimensionValue(esIndex.partitioningColumn, value);
                partitions.add(p);
            }
            ArrayList<Partition> arrayList = new ArrayList<Partition>(partitions);
            return arrayList;
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
    }

    private static DimensionValue unparseDateId(TimeDimension dimension, String id) {
        int len = id.length();
        switch (dimension.mappedPeriod) {
            case YEAR: {
                len = 4;
                break;
            }
            case MONTH: {
                len = 7;
                break;
            }
            case DAY: {
                len = 10;
                break;
            }
            case HOUR: {
                len = 13;
            }
        }
        return dimension.getValueFromId(id.replace('T', '-').substring(0, len));
    }

    static String substitutePartitionIdentifierInPathForSuggestedName(String pattern, PartitioningScheme scheme) {
        for (int i = 0; i < scheme.getDimensionNames().size(); ++i) {
            String dname = (String)scheme.getDimensionNames().get(i);
            Dimension d = scheme.getDimension(dname);
            if (d instanceof TimeDimension) {
                pattern = pattern.replaceAll("%Y", "*");
                pattern = pattern.replaceAll("%M", "*");
                pattern = pattern.replaceAll("%D", "*");
                pattern = pattern.replaceAll("%H", "*");
                continue;
            }
            if (d instanceof ExactValueDimension) {
                pattern = pattern.replaceAll("%(\\(([^%]+?)\\))?\\{" + Pattern.quote(dname) + "\\}", "*");
                continue;
            }
            throw new NotImplementedException();
        }
        return pattern;
    }

    static String buildSearchPartitionIndex(ElasticSearchIndex esIndex, DSSAuthCtx user, ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery query, ElasticSearchIndex.InteractiveSearchResults results) throws Exception {
        List<String> partitionsStrs = query.datasetSelection.getPartitionIds(user, esIndex.dataset);
        ArrayList<String> indices = new ArrayList<String>();
        for (String partitionStr : partitionsStrs) {
            try {
                List<Partition> partitions = PartitionFactory.fromPartitionSpec(esIndex.dataset.getPartitioningSchema(), partitionStr);
                for (Partition partition : partitions) {
                    try {
                        String index = ElasticSearchUnmanagedPartitionUtils.resolvePartitionIdentifierInPattern(esIndex.partitioningIndexPattern, partition, esIndex.dataset.getPartitioningSchema());
                        if (index == null) continue;
                        indices.add(index);
                    }
                    catch (Exception e) {
                        results.warningsContext.addWarning(WarningsContext.WarningType.INPUT_ELASTICSEARCH_INDEX_NOT_FOUND, "Elasticsearch index or type not found: " + partition.toString(), logger);
                    }
                }
            }
            catch (Exception e) {
                results.warningsContext.addWarning(WarningsContext.WarningType.INPUT_ELASTICSEARCH_INDEX_NOT_FOUND, "Could not find Elasticsearch index for partition input: " + partitionStr, logger);
            }
        }
        return String.join((CharSequence)",", indices);
    }

    static JSONObject getPartitionFilter(List<Partition> partitions, String partitioningColumn, boolean addToRoot) {
        JSONArray terms = new JSONArray();
        JSONArray ranges = new JSONArray();
        for (Partition p : partitions) {
            String dimension = p.getScheme().getSingleDimension().getName();
            DimensionValue dimensionValue = (DimensionValue)p.getDimensionValues().get(dimension);
            if (dimensionValue instanceof TimeDimensionValue) {
                String fmt;
                TimeDimensionValue timeDimensionValue = (TimeDimensionValue)dimensionValue;
                JSONObject value = new JSONObject();
                switch (timeDimensionValue.getDimension().mappedPeriod) {
                    case HOUR: {
                        fmt = timeDimensionValue.id() + "||/h";
                        value.put("format", (Object)"yyyy-MM-dd-hh");
                        break;
                    }
                    case DAY: {
                        fmt = timeDimensionValue.id() + "||/d";
                        value.put("format", (Object)"yyyy-MM-dd");
                        break;
                    }
                    case MONTH: {
                        fmt = timeDimensionValue.id() + "||/M";
                        value.put("format", (Object)"yyyy-MM");
                        break;
                    }
                    case YEAR: {
                        fmt = timeDimensionValue.id() + "||/y";
                        value.put("format", (Object)"yyyy");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown period: " + String.valueOf(timeDimensionValue.getDimension().mappedPeriod));
                    }
                }
                value.put("gte", (Object)fmt);
                value.put("lte", (Object)fmt);
                ranges.put((Object)new JSONObject().put("range", (Object)new JSONObject().put(dimension, (Object)value)));
                continue;
            }
            terms.put((Object)dimensionValue.id());
        }
        JSONObject query = new JSONObject();
        if (ranges.length() == 1) {
            query = ranges.getJSONObject(0);
        } else if (ranges.length() > 1) {
            query.put("bool", (Object)new JSONObject().put("should", (Object)ranges));
        }
        if (terms.length() == 1) {
            query.put("term", (Object)new JSONObject().put(partitioningColumn, terms.get(0)));
        } else if (terms.length() > 1) {
            query.put("terms", (Object)new JSONObject().put(partitioningColumn, (Object)terms));
        }
        JSONObject filter = new JSONObject().put("filter", (Object)query);
        if (addToRoot) {
            return filter;
        }
        return new JSONObject().put("query", (Object)new JSONObject().put("bool", (Object)filter));
    }
}

