/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FTPConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.DirectoryAwareFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.FTPDatasetTestHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.remote.RemoteFileUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import java.io.IOException;

public class FTPDatasetHandler
extends DirectoryAwareFSDatasetHandler<BuiltinFSDatasets.FTPDatasetConfig>
implements FSDatasetBrowseService.BrowsableHandler {
    private final PasswordEncryptionService symetricCryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);

    public FTPDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
    }

    @Override
    public void checkConfiguration() throws IOException, DKUSecurityException {
        if (!((BuiltinFSDatasets.FTPDatasetConfig)this.resolvedConfig).urlMode) {
            this.getConnection();
        }
    }

    @Override
    public AbstractFSDatasetHandler.FSProviderAndPath getProviderInternal(String path) throws IOException, CodedException, DKUSecurityException {
        String providerPath;
        String string = providerPath = path == null ? ((BuiltinFSDatasets.FTPDatasetConfig)this.resolvedConfig).path : path;
        if (((BuiltinFSDatasets.FTPDatasetConfig)this.resolvedConfig).urlMode) {
            FTPConnection ftpConnection = RemoteFileUtils.ParseFtpConnection(providerPath, ((BuiltinFSDatasets.FTPDatasetConfig)this.resolvedConfig).urlModeUseGlobalProxy);
            BuiltinFSDatasets.FTPDatasetConfig config = new BuiltinFSDatasets.FTPDatasetConfig();
            config.connection = ftpConnection.name;
            config.path = ftpConnection.params.file;
            FSProvider provider = FSProviderFactory.getProvider("FTP", this.authCtx, this.dataset.getProjectKey(), config, ftpConnection.params.file, ftpConnection);
            return new AbstractFSDatasetHandler.FSProviderAndPath(provider, providerPath);
        }
        FTPConnection connection = (FTPConnection)this.getConnection();
        FSProvider provider = FSProviderFactory.getProvider("FTP", this.authCtx, this.dataset.getProjectKey(), this.resolvedConfig, providerPath, connection);
        return new AbstractFSDatasetHandler.FSProviderAndPath(provider, providerPath);
    }

    @Override
    protected DSSConnection getConnection() throws IOException, DKUSecurityException {
        return ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, ((BuiltinFSDatasets.FTPDatasetConfig)this.resolvedConfig).connection, FTPConnection.class);
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return BuiltinFSDatasets.FTP_META;
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new FTPDatasetTestHandler(this.authCtx, this, (DatasetHandler)this, this.dataset);
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return false;
    }
}

