/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLQueryDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowSequenceInputSplit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PartitionedSQLQueryDatasetHandler
extends AbstractSQLQueryDatasetHandler {
    protected List<Partition> explicitPartitionsList;

    public PartitionedSQLQueryDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
        super(authCtx, dataset, meta);
        if (!StringUtils.isBlank((String)this.resolvedAbstractConfig.explicitPartitionsList)) {
            this.explicitPartitionsList = PartitionFactory.fromPartitionSpec(dataset.getPartitioningSchema(), this.resolvedAbstractConfig.explicitPartitionsList);
        }
    }

    @Override
    public void checkConfiguration() throws IOException {
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        if (this.explicitPartitionsList != null) {
            return this.explicitPartitionsList;
        }
        return this.listPartitionsWithQuery(this.resolvedAbstractConfig.partitionsQuery);
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        for (Partition _p : this.listPartitions()) {
            if (!_p.id().equals(p.id())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected RowsInputSplit getHasDataSplit() throws Exception {
        if (StringUtils.isBlank((String)this.resolvedAbstractConfig.previewPartition)) {
            throw ErrorContext.iae((String)"For a custom query partitioned dataset, the preview partition is mandatory");
        }
        Partition part = PartitionFactory.fromIdentifier(this.dataset.getPartitioningSchema(), this.resolvedAbstractConfig.previewPartition);
        return new HasDataSplit(part);
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        return new QueryPartitionSplit(partition);
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        assert (filter != null);
        FilterResultWithSplits ret = new FilterResultWithSplits();
        if (!filter.hasPartitionsFiltering()) {
            for (Partition partition : this.listPartitions()) {
                ret.withMatchingPartition(partition).withSplit(this.getPartitionSplit(partition));
            }
        } else {
            for (Partition partition : filter.getPartitionsClause()) {
                ret.withMatchingPartition(partition).withSplit(this.getPartitionSplit(partition));
            }
        }
        return ret;
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        ArrayList<RowsInputSplit> splits = new ArrayList<RowsInputSplit>();
        for (Partition part : this.listPartitions()) {
            InputSplit split = this.getPartitionSplit(part);
            splits.add((RowsInputSplit)split);
        }
        return new RowSequenceInputSplit(splits);
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        if (StringUtils.isBlank((String)this.resolvedAbstractConfig.previewPartition)) {
            throw ErrorContext.iae((String)"For a custom query partitioned dataset, the preview partition is mandatory");
        }
        Partition part = PartitionFactory.fromIdentifier(this.dataset.getPartitioningSchema(), this.resolvedAbstractConfig.previewPartition);
        return (RowsInputSplit)this.getPartitionSplit(part);
    }

    @Override
    public long getPartitionRecords(Partition p) throws DataStoreIOException, DKUSecurityException, InterruptedException {
        return this.runInExpandedAndSplitQuery("Failed to count partition records", p, new AbstractSQLQueryDatasetHandler.WorkOnMainQuery<Long>(){

            @Override
            public Long work(SQLConnectionProvider.SQLConnectionWrapper conn, Statement stmt, String q) throws SQLException, DKUSecurityException {
                String mainQuery = "SELECT COUNT(*) FROM (" + q + ")" + PartitionedSQLQueryDatasetHandler.this.getDialect().quoteIdentifier("subQuery");
                ResultSet rs2 = stmt.executeQuery(mainQuery);
                rs2.next();
                return rs2.getLong(1);
            }
        });
    }

    class HasDataSplit
    extends RowsInputSplit {
        Partition partition;

        HasDataSplit(Partition partition) {
            this.partition = partition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            long l;
            String q = PartitionedSQLQueryDatasetHandler.this.expandQueryForPartition(this.partition);
            q = limit != null && limit.maxRecords > 0L ? PartitionedSQLQueryDatasetHandler.this.getDialect().getLimitedQuery(q, limit.maxRecords) : q;
            SQLConnectionProvider.SQLConnectionWrapper conn = PartitionedSQLQueryDatasetHandler.this.newConnection();
            try {
                l = PartitionedSQLQueryDatasetHandler.this.executePush(conn, q, out, cf, rf, limit, listener, warningsContext, false);
            }
            catch (Throwable throwable) {
                try {
                    SQLUtils.unsafeRollbackAndClose(conn);
                    throw throwable;
                }
                catch (MemTableAppendingOutput.MemTableSizeLimitReachedException e) {
                    throw e;
                }
                catch (SQLException e) {
                    throw new DataStoreIOException("Failed to read data from DB", (Throwable)e);
                }
            }
            SQLUtils.unsafeRollbackAndClose(conn);
            return l;
        }

        public String getDesc() {
            return "SQL Split " + this.partition.id();
        }
    }

    class QueryPartitionSplit
    extends RowsInputSplit {
        Partition partition;

        QueryPartitionSplit(Partition partition) {
            this.partition = partition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            long l;
            String q = PartitionedSQLQueryDatasetHandler.this.expandQueryForPartition(this.partition);
            q = limit != null && limit.maxRecords > 0L ? PartitionedSQLQueryDatasetHandler.this.getDialect().getLimitedQuery(q, limit.maxRecords) : q;
            SQLConnectionProvider.SQLConnectionWrapper conn = PartitionedSQLQueryDatasetHandler.this.newConnection();
            try {
                l = PartitionedSQLQueryDatasetHandler.this.executePush(conn, q, out, cf, rf, limit, listener, warningsContext, true);
            }
            catch (Throwable throwable) {
                try {
                    SQLUtils.unsafeRollbackAndClose(conn);
                    throw throwable;
                }
                catch (MemTableAppendingOutput.MemTableSizeLimitReachedException e) {
                    throw e;
                }
                catch (SQLException e) {
                    throw new DataStoreIOException("Failed to read data from DB", (Throwable)e);
                }
            }
            SQLUtils.unsafeRollbackAndClose(conn);
            return l;
        }

        public String getDesc() {
            return "SQL Split " + this.partition.id();
        }
    }
}

